/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

abstract class MultiFloatFunction
extends ValueSource {
    protected final ValueSource[] sources;

    public MultiFloatFunction(ValueSource[] sources) {
        this.sources = sources;
    }

    protected abstract String name();

    protected abstract float func(int var1, DocValues[] var2);

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name() + '(');
        boolean firstTime = true;
        for (ValueSource source : this.sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source);
        }
        sb.append(')');
        return sb.toString();
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final DocValues[] valsArr = new DocValues[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            valsArr[i] = this.sources[i].getValues(reader);
        }
        return new DocValues(){

            public float floatVal(int doc) {
                return MultiFloatFunction.this.func(doc, valsArr);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(MultiFloatFunction.this.name() + '(');
                boolean firstTime = true;
                for (DocValues vals : valsArr) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(vals.toString(doc));
                }
                sb.append(')');
                return sb.toString();
            }
        };
    }

    public int hashCode() {
        return Arrays.hashCode(this.sources) + this.name().hashCode();
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MultiFloatFunction other = (MultiFloatFunction)o;
        return this.name().equals(other.name()) && Arrays.equals(this.sources, other.sources);
    }
}

