/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.function.ConstValueSource;
import org.apache.solr.search.function.FunctionQuery;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionQParser
extends QParser {
    protected QueryParsing.StrParser sp;

    public FunctionQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws ParseException {
        this.sp = new QueryParsing.StrParser(this.getString());
        ValueSource vs = this.parseValueSource();
        return new FunctionQuery(vs);
    }

    public boolean hasMoreArguments() throws ParseException {
        char ch = this.sp.peek();
        return ch != '\u0000' && ch != ')';
    }

    public String parseId() throws ParseException {
        String value = this.sp.getId();
        this.consumeArgumentDelimiter();
        return value;
    }

    public Float parseFloat() throws ParseException {
        float value = this.sp.getFloat();
        this.consumeArgumentDelimiter();
        return Float.valueOf(value);
    }

    public List<ValueSource> parseValueSourceList() throws ParseException {
        ArrayList<ValueSource> sources = new ArrayList<ValueSource>(3);
        do {
            sources.add(this.parseValueSource(false));
        } while (this.consumeArgumentDelimiter());
        return sources;
    }

    public ValueSource parseValueSource() throws ParseException {
        return this.parseValueSource(true);
    }

    public Query parseNestedQuery() throws ParseException {
        Query nestedQuery;
        if (this.sp.opt("$")) {
            String param = this.sp.getId();
            this.sp.pos += param.length();
            String qstr = this.getParam(param);
            qstr = qstr == null ? "" : qstr;
            nestedQuery = this.subQuery(qstr, null).parse();
        } else {
            HashMap<String, String> nestedLocalParams;
            int start = this.sp.pos;
            int end = this.sp.pos;
            String v = this.sp.val;
            String qs = v.substring(start);
            end = QueryParsing.parseLocalParams(qs, start, nestedLocalParams = new HashMap<String, String>(), this.getParams());
            if (end > start) {
                if (nestedLocalParams.get("v") == null) {
                    QParser sub = this.subQuery(qs, null);
                    throw new ParseException("Nested local params must have value in v parameter.  got '" + qs + "'");
                }
            } else {
                throw new ParseException("Nested function query must use $param or {!v=value} forms. got '" + qs + "'");
            }
            QParser sub = this.subQuery(qs.substring(0, end), null);
            this.sp.pos += end - start;
            nestedQuery = sub.getQuery();
        }
        this.consumeArgumentDelimiter();
        return nestedQuery;
    }

    protected ValueSource parseValueSource(boolean doConsumeDelimiter) throws ParseException {
        ValueSource valueSource;
        char ch = this.sp.peek();
        if (ch >= '0' && ch <= '9' || ch == '.' || ch == '+' || ch == '-') {
            valueSource = new ConstValueSource(this.sp.getFloat());
        } else {
            String id = this.sp.getId();
            if (this.sp.opt("(")) {
                ValueSourceParser argParser = this.req.getCore().getValueSourceParser(id);
                if (argParser == null) {
                    throw new ParseException("Unknown function " + id + " in FunctionQuery(" + this.sp + ")");
                }
                valueSource = argParser.parse(this);
                this.sp.expect(")");
            } else {
                SchemaField f = this.req.getSchema().getField(id);
                valueSource = f.getType().getValueSource(f, this);
            }
        }
        if (doConsumeDelimiter) {
            this.consumeArgumentDelimiter();
        }
        return valueSource;
    }

    protected boolean consumeArgumentDelimiter() throws ParseException {
        if (this.hasMoreArguments()) {
            this.sp.expect(",");
            return true;
        }
        return false;
    }
}

