/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElevationComparatorSource
implements SortComparatorSource {
    private final Map<String, Integer> priority;

    public ElevationComparatorSource(Map<String, Integer> boosts) {
        this.priority = boosts;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
        final FieldCache.StringIndex index = FieldCache.DEFAULT.getStringIndex(reader, fieldname);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc d0, ScoreDoc d1) {
                int f0 = index.order[d0.doc];
                int f1 = index.order[d1.doc];
                String id0 = index.lookup[f0];
                String id1 = index.lookup[f1];
                Integer b0 = (Integer)ElevationComparatorSource.this.priority.get(id0);
                Integer b1 = (Integer)ElevationComparatorSource.this.priority.get(id1);
                int v0 = b0 == null ? -1 : b0;
                int v1 = b1 == null ? -1 : b1;
                return v1 - v0;
            }

            public Comparable sortValue(ScoreDoc d0) {
                int f0 = index.order[d0.doc];
                String id0 = index.lookup[f0];
                Integer b0 = (Integer)ElevationComparatorSource.this.priority.get(id0);
                int v0 = b0 == null ? -1 : b0;
                return new Integer(v0);
            }

            public int sortType() {
                return 9;
            }
        };
    }
}

