/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javanet.staxutils.BaseXMLInputFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisRequestHandler
extends RequestHandlerBase {
    public static Logger log = Logger.getLogger(AnalysisRequestHandler.class.getName());
    private XMLInputFactory inputFactory;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = BaseXMLInputFactory.newInstance();
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.fine("Unable to set the 'reuse-instance' property for the input factory: " + this.inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams != null) {
            for (ContentStream stream : req.getContentStreams()) {
                Reader reader = stream.getReader();
                try {
                    XMLStreamReader parser = this.inputFactory.createXMLStreamReader(reader);
                    NamedList<Object> result = this.processContent(parser, req.getSchema());
                    rsp.add("response", result);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
        }
    }

    NamedList<Object> processContent(XMLStreamReader parser, IndexSchema schema) throws XMLStreamException, IOException {
        SimpleOrderedMap result = new SimpleOrderedMap();
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 8: {
                    parser.close();
                    return result;
                }
                case 1: {
                    String currTag = parser.getLocalName();
                    if (!"doc".equals(currTag)) break;
                    log.finest("Tokenizing doc...");
                    SolrInputDocument doc = this.readDoc(parser);
                    SchemaField uniq = schema.getUniqueKeyField();
                    SimpleOrderedMap theTokens = new SimpleOrderedMap();
                    result.add(doc.getFieldValue(uniq.getName()).toString(), (Object)theTokens);
                    Iterator i$ = doc.getFieldNames().iterator();
                    block5: while (true) {
                        if (!i$.hasNext()) continue block4;
                        String name = (String)i$.next();
                        FieldType ft = schema.getFieldType(name);
                        Analyzer analyzer = ft.getAnalyzer();
                        Collection vals = doc.getFieldValues(name);
                        Iterator i$2 = vals.iterator();
                        while (true) {
                            if (!i$2.hasNext()) continue block5;
                            Object val = i$2.next();
                            StringReader reader = new StringReader(val.toString());
                            TokenStream tstream = analyzer.tokenStream(name, (Reader)reader);
                            NamedList<NamedList<Object>> tokens = AnalysisRequestHandler.getTokens(tstream);
                            theTokens.add(name, tokens);
                        }
                        break;
                    }
                }
            }
        }
    }

    static NamedList<NamedList<Object>> getTokens(TokenStream tstream) throws IOException {
        NamedList tokens = new NamedList();
        Token t = null;
        while ((t = tstream.next()) != null) {
            SimpleOrderedMap token = new SimpleOrderedMap();
            tokens.add("token", (Object)token);
            token.add("value", (Object)new String(t.termBuffer(), 0, t.termLength()));
            token.add("start", (Object)t.startOffset());
            token.add("end", (Object)t.endOffset());
            token.add("posInc", (Object)t.getPositionIncrement());
            token.add("type", (Object)t.type());
        }
        return tokens;
    }

    SolrInputDocument readDoc(XMLStreamReader parser) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        StringBuilder text = new StringBuilder();
        String name = null;
        String attrName = "";
        float boost = 1.0f;
        boolean isNull = false;
        block5: while (true) {
            int event = parser.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                    break;
                }
                case 2: {
                    if ("doc".equals(parser.getLocalName())) {
                        return doc;
                    }
                    if (!"field".equals(parser.getLocalName()) || isNull) continue block5;
                    doc.addField(name, (Object)text.toString(), boost);
                    boost = 1.0f;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = parser.getLocalName();
                    if (!"field".equals(localName)) {
                        log.warning("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    String attrVal = "";
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        attrVal = parser.getAttributeValue(i);
                        if (!"name".equals(attrName)) continue;
                        name = attrVal;
                    }
                    continue block5;
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "Provide Analysis of text";
    }

    @Override
    public String getVersion() {
        return "$Revision:$";
    }

    @Override
    public String getSourceId() {
        return "$Id:$";
    }

    @Override
    public String getSource() {
        return "$URL:$";
    }
}

