/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.br.BrazilianStemmer;

public final class BrazilianStemFilter
extends TokenFilter {
    private BrazilianStemmer stemmer = new BrazilianStemmer();
    private Set exclusions = null;

    public BrazilianStemFilter(TokenStream in) {
        super(in);
    }

    public BrazilianStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public final Token next(Token reusableToken) throws IOException {
        String s;
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        String term = nextToken.term();
        if (!(this.exclusions != null && this.exclusions.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
            nextToken.setTermBuffer(s);
        }
        return nextToken;
    }
}

