/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThesaurusTreeHelper
extends NavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    public static final JAXXContextEntryDef<Thesaurus> THESAURUS = Util.newContextEntryDef((String)"thesaurus", Thesaurus.class);
    protected NavigationTreeNode rootNode = null;
    protected ThesaurusTreeModelBuilder builder = null;
    protected Thesaurus rootThesaurus = null;

    public ThesaurusTreeHelper(Thesaurus rootThesaurus) {
        super(rootThesaurus.getName());
        this.rootThesaurus = rootThesaurus;
    }

    protected ThesaurusHandler getHandler(JAXXContext context) {
        return (ThesaurusHandler)context.getContextValue(ThesaurusHandler.class);
    }

    public ThesaurusTreeModelBuilder getBuilder() {
        return this.builder;
    }

    public void setRootThesaurus(Thesaurus root) {
        this.rootThesaurus = root;
    }

    public NavigationTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getRootName() {
        return this.rootThesaurus.getName();
    }

    public void createModel(JAXXContext context) {
        THESAURUS.setContextValue(context, (Object)this.rootThesaurus);
    }

    public NavigationTreeModel createTreeModel(JAXXContext context) {
        if (this.builder == null) {
            this.builder = new ThesaurusTreeModelBuilder(context);
        }
        this.rootNode = this.builder.buildEmptyRoot(THESAURUS, this.rootThesaurus.getName());
        this.buildChildren(context, this.builder, null, this.rootThesaurus);
        NavigationTreeModel model = this.builder.getModel();
        if (log.isInfoEnabled()) {
            this.builder.printModel(model.getRoot());
        }
        this.setTreeModel(context, model);
        return model;
    }

    private void buildChildren(JAXXContext context, ThesaurusTreeModelBuilder builder, NavigationTreeNode parentNode, Thesaurus parent) {
        ArrayList<NavigationTreeNode> result = new ArrayList<NavigationTreeNode>();
        if (parent.getChildren() != null) {
            for (Thesaurus child : parent.getChildren()) {
                NavigationTreeNode childNode = builder.addThesaurus(context, parentNode, child);
                result.add(childNode);
                if (child.getWikittyId() == null) continue;
                this.buildChildren(context, builder, childNode, child);
            }
        }
    }

    public NavigationTreeHandler createTreeHandler(JAXXObject context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create handler");
        }
        NavigationTreeHandler handler = new NavigationTreeHandler(this.getPrefix(), context, NavigationTreeHandler.Strategy.PER_NODE){
            private static final long serialVersionUID = 1L;

            protected NavigationTreeModel getNavigationTreeModel() {
                return ThesaurusTreeHelper.this.getSafeTreeModel((JAXXContext)this.getContext());
            }

            protected void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }

            public ThesaurusUI getContext() {
                return (ThesaurusUI)this.context;
            }

            protected Component getCurrentUI() {
                return null;
            }

            protected Component getUI(NavigationTreeNode node) {
                return ThesaurusTreeHelper.this.getHandler(this.context).getUI(this.context);
            }

            protected boolean closeUI(Component component) throws Exception {
                return true;
            }

            protected Component createUI(NavigationTreeNode node) throws Exception {
                return ThesaurusTreeHelper.this.getHandler(this.context).getUI(this.context);
            }

            protected void openUI(Component newUI, NavigationTreeNode node) throws Exception {
            }
        };
        handler.setSelectionMode(4);
        this.setTreeHandler((JAXXContext)context, handler);
        this.setTree((JAXXContext)context, ((ThesaurusUI)context).getThesaurus());
        return handler;
    }

    public void tryToSelect(JAXXContext context, Set<String> thesaurusId) {
        if (thesaurusId != null) {
            ArrayList<NavigationTreeNode> nodes = new ArrayList<NavigationTreeNode>();
            for (String id : thesaurusId) {
                this.tryToSelect(id, this.getRootNode(), nodes);
            }
            JTree tree = this.getTree(context);
            TreePath[] paths = new TreePath[nodes.size()];
            int i = 0;
            for (NavigationTreeNode node : nodes) {
                Object[] treeNodes = node.getPath();
                TreePath path = new TreePath(treeNodes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try to select path : " + path));
                }
                paths[i++] = path;
                tree.expandPath(path);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("path " + paths[i - 1] + " for node " + node));
            }
            tree.setSelectionPaths(paths);
        }
    }

    public void tryToSelect(String thesaurusId, NavigationTreeNode node, List<NavigationTreeNode> nodes) {
        if (thesaurusId != null) {
            if (thesaurusId.equals(this.getWikittyId(node))) {
                nodes.add(node);
            } else {
                Enumeration children = node.children();
                while (children.hasMoreElements()) {
                    NavigationTreeNode child = (NavigationTreeNode)children.nextElement();
                    this.tryToSelect(thesaurusId, child, nodes);
                }
            }
        }
    }

    protected String getWikittyId(NavigationTreeNode node) {
        Thesaurus thesaurus = (Thesaurus)node.getBean();
        return thesaurus.getWikittyId();
    }

    protected Decorator<Thesaurus> getThesaurusDecorator() {
        Decorator tDecorator = VradiContext.get().getDecorateurProvinder().getDecorator(Thesaurus.class);
        return tDecorator;
    }

    public class ThesaurusTreeModelBuilder
    extends NavigationTreeModelBuilder {
        public ThesaurusTreeModelBuilder(JAXXContext context) {
            super("/", context, null, null);
        }

        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode parentNode) {
            NavigationTreeModel treeModel = ThesaurusTreeHelper.this.getTreeModel(context);
            treeModel.removeNodeFromParent((MutableTreeNode)parentNode);
            return treeModel.getRoot().getChildCount() == 0;
        }

        public NavigationTreeNode addThesaurus(JAXXContext context, Thesaurus thesaurus) {
            NavigationTreeNode selectedNode = ThesaurusTreeHelper.this.getSelectedNode(context);
            return this.addThesaurus(context, selectedNode, thesaurus);
        }

        public NavigationTreeNode addThesaurus(JAXXContext context, NavigationTreeNode parent, Thesaurus thesaurus) {
            return this.addThesaurus(parent, thesaurus.getWikittyId());
        }

        public NavigationTreeNode addThesaurus(NavigationTreeNode parent, String thesaurusId) {
            NavigationTreeNode result = null;
            Decorator<Thesaurus> tDecorator = ThesaurusTreeHelper.this.getThesaurusDecorator();
            String path = "";
            if (parent == null) {
                parent = ThesaurusTreeHelper.this.getRootNode();
                path = "..children[@wikittyId=\"" + thesaurusId + "\"]";
            } else {
                path = "../children[@wikittyId=\"" + thesaurusId + "\"]";
            }
            result = ThesaurusTreeHelper.this.builder.build(parent, tDecorator, path, thesaurusId, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("addThesaurus : " + thesaurusId + " to parent : " + parent == null ? "null" : (parent.getFullPath() + " fullPath : " + result == null ? "result is null" : result.getFullPath())));
            }
            return result;
        }
    }
}

