/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.DateFormTypeFilterHandler;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.ThesaurusUI;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;

public class ThesaurusHandler {
    private static Log log = LogFactory.getLog(ThesaurusHandler.class);

    public ThesaurusUI initUI(JAXXContext rootContext, Thesaurus rootThesaurus, Form bean) {
        return this.initUI(rootContext, rootThesaurus, bean, false);
    }

    public ThesaurusUI initUI(JAXXContext rootContext, Thesaurus rootThesaurus, Form bean, boolean deletable) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        ThesaurusTreeHelper helper = new ThesaurusTreeHelper(rootThesaurus);
        ThesaurusUI ui = new ThesaurusUI((JAXXContext)context, helper);
        ui.setDeletable(deletable);
        ui.setBean(bean);
        return ui;
    }

    ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI)context;
        }
        return null;
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return ((OfferEditHandler)context.getContextValue(OfferEditHandler.class)).getUI(context);
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return ((OfferListHandler)context.getContextValue(OfferListHandler.class)).getUI(context);
    }

    public static Thesaurus getRootThesaurus() {
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            return new Thesaurus(rootTreeNode);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant get thesaurus caused by : " + (Object)((Object)ex)));
            return null;
        }
    }

    protected NavigationTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return helper.getRootNode();
        }
        return (NavigationTreeNode)path.getLastPathComponent();
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = this.getListUI(context);
        NavigationTreeNode parentNode = this.getParentNode(helper, path);
        Thesaurus thesaurus = (Thesaurus)parentNode.getBean(context);
        this.getUI(context).getParentContainer(OfferListUI.class).getHandler().getCriteriaHandler(context).addAndPersistCriteria(context, thesaurus.getBean());
        ui.validate();
    }

    public void addThesaurus(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        if (path != null) {
            NavigationTreeNode parentNode = (NavigationTreeNode)path.getLastPathComponent();
            helper.getBuilder().removeNodeFromParent(context, parentNode);
            Thesaurus thesaurusParent = (Thesaurus)parentNode.getBean(context);
            OfferEditUI ui = this.getEditUI(context);
            this.addThesaurus(context, thesaurusParent, true, true);
        }
    }

    public void addThesaurus(JAXXContext context, Thesaurus root, boolean deletable, boolean save) {
        if (root != null) {
            ThesaurusTreeHelper helper = new ThesaurusTreeHelper(root);
            ThesaurusUI thesaurusChildUI = new ThesaurusUI(context, helper);
            thesaurusChildUI.setDeletable(deletable);
            this.getThesaurusContainer(context).add((Component)((Object)thesaurusChildUI));
            if (save) {
                VradiHelper.addVradiListThesaurus(root.getBean());
            }
            this.getUI(context).validate();
        }
    }

    public void addChildToRoot(JAXXContext context, ThesaurusTreeHelper helper) {
        Thesaurus rootThesaurus = ThesaurusHandler.getRootThesaurus();
        Thesaurus newThesaurus = this.addChild(context, rootThesaurus);
        this.addThesaurus(context, newThesaurus, false, false);
    }

    public void addChildToSelected(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        NavigationTreeNode parentNode = this.getParentNode(helper, path);
        Thesaurus thesaurusParent = (Thesaurus)parentNode.getBean(context);
        Thesaurus newThesaurus = this.addChild(context, thesaurusParent);
        if (newThesaurus != null) {
            helper.getBuilder().addThesaurus(context, parentNode, newThesaurus);
        }
    }

    protected Thesaurus addChild(JAXXContext context, Thesaurus thesaurusParent) {
        String name = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), (Object)I18n._((String)"vradi.thesausur.askName"));
        if (name != null && !name.isEmpty()) {
            VradiStorageService service = ServiceHelper.getVradiStorageService();
            TreeNode treeNodeParent = thesaurusParent.getBean();
            TreeNodeImpl newTreeNode = new TreeNodeImpl();
            newTreeNode.setName(name);
            treeNodeParent.addChildren(newTreeNode.getWikittyId());
            newTreeNode.setParent(treeNodeParent.getWikittyId());
            try {
                service.updateThesaurus(treeNodeParent);
                service.updateThesaurus((TreeNode)newTreeNode);
            }
            catch (TechnicalException ex) {
                log.error((Object)("Cant save thsaurus : " + newTreeNode.getWikittyId() + " caused by : "), (Throwable)ex);
            }
            Thesaurus newThesaurus = new Thesaurus((TreeNode)newTreeNode);
            thesaurusParent.addChild(newThesaurus);
            ((DateFormTypeFilterHandler)VradiContext.CRITERIA_HANDLER_ENTRY_DEF.getContextValue(context)).initCriteria(context);
            return newThesaurus;
        }
        return null;
    }

    public void addColumn(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        NavigationTreeNode node = this.getParentNode(helper, path);
        Thesaurus thesaurus = (Thesaurus)node.getBean(context);
        VradiHelper.addVradiListColumns(thesaurus.getBean());
        this.getListUI(context).updateTableModel();
    }

    public void closeThesaurus(ThesaurusUI context) {
        OfferEditUI ui = this.getEditUI((JAXXContext)context);
        this.closeThesaurus((JAXXContext)context, context);
        ui.validate();
    }

    public void closeThesaurus(JAXXContext context, ThesaurusUI thesaurus) {
        this.getThesaurusContainer(context).remove((Component)((Object)thesaurus));
        Thesaurus selected = (Thesaurus)thesaurus.helper.getRootNode().getBean();
        VradiHelper.removeVradiListThesaurus(selected.getBean());
        this.getEditUI(context).getHandler().addThesaurus(context, selected);
        this.getUI(context).validate();
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return ((OfferEditUI)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(context)).getThesaurus();
    }
}

