package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.wikitty.WikittyExtension;

import java.util.List;

/**
 * @author letellier
 */
public class FormNavigationTreeHelper extends VradiNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(FormNavigationTreeHelper.class);

    public FormNavigationTreeHelper(JAXXContext context) {
        super(FORMS.getName(), context);
    }

    @Override
    public NavigationTreeModel createTreeModel() {

        JAXXContext context = getContext();

        List<WikittyExtension> forms = FORMS.getContextValue(context);

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        NavigationTreeNode formNode = builder.build(
                rootNode,
                _(FORMS.getName()),
                FORMS,
                "forms",
                AdminFormTypeUI.class,
                null);

        for (WikittyExtension f : forms) {
            builder.addForm(context, formNode, f);
        }

        NavigationTreeModel model = builder.getModel();

        if (log.isDebugEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        setSelectedNode(context, formNode);

        return model;
    }
}
