package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import java.util.List;
import java.util.Set;

/**
 * @author letellier
 */
public class ClientNavigationTreeHelper extends VradiNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    public ClientNavigationTreeHelper(JAXXContext context) {
        super(CLIENTS.getName(), context);
    }

    @Override
    public NavigationTreeModel createTreeModel() {

        JAXXContext context = getContext();

        List<Client> clients = CLIENTS.getContextValue(context);

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        NavigationTreeNode clientsNode = builder.build(
                rootNode,
                _(CLIENTS.getName()),
                CLIENTS,
                "clients",
                AdminClientUI.class,
                null);

        for (Client c : clients) {

            NavigationTreeNode clientNode = builder.addClient(context, clientsNode, c);

            Set<String> usersId = c.getUser();
            if (usersId != null) {
                for (String userId : usersId) {

                    builder.addUser(clientNode.getChildAt(0), userId);
                }
            }
        }

        NavigationTreeModel model = builder.getModel();

        if (log.isDebugEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        setSelectedNode(context, clientsNode);

        return model;
    }
}
