/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.*;
import jaxx.runtime.swing.navigation.NavigationTreeHandler.Strategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.Tree;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;

import javax.swing.*;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import java.awt.*;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class ThesaurusTreeHelper extends NavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    /**
     * where the movies are hold in context
     */
    public static final JAXXContextEntryDef<Thesaurus> THESAURUS = Util.newContextEntryDef("thesaurus", Thesaurus.class);

    protected NavigationTreeNode rootNode = null;

    protected ThesaurusTreeModelBuilder builder = null;

    protected Thesaurus rootThesaurus = null;

    public ThesaurusTreeHelper(Thesaurus rootThesaurus) {
        super(rootThesaurus.getName());
        this.rootThesaurus = rootThesaurus;
    }

    protected ThesaurusHandler getHandler(JAXXContext context) {
        return context.getContextValue(ThesaurusHandler.class);
    }

    public ThesaurusTreeModelBuilder getBuilder() {
        return builder;
    }

    public void setRootThesaurus(Thesaurus root){
        this.rootThesaurus = root;
    }

    public NavigationTreeNode getRootNode() {
        return rootNode;
    }

    public String getRootName() {
        return rootThesaurus.getName();
    }

    /**
     * Create the model and store it in the given context.
     *
     * @param context the context where to hold the model
     */
    public void createModel(JAXXContext context) {
        THESAURUS.setContextValue(context, rootThesaurus);
    }

    @Override
    public NavigationTreeModel createTreeModel(JAXXContext context) {
        if (builder == null) {
            builder = new ThesaurusTreeModelBuilder(context);
        }

        // construction du noeud root
        // il ne contient pas de context et ne sera passsss visible
        rootNode = builder.buildEmptyRoot(THESAURUS, rootThesaurus.getName());

        buildChildren(context, builder, null, rootThesaurus);

        NavigationTreeModel model = builder.getModel();

        if (log.isInfoEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        return model;
    }

    private void buildChildren(JAXXContext context, ThesaurusTreeModelBuilder builder, NavigationTreeNode parentNode, Thesaurus parent) {

        List<NavigationTreeNode> result = new ArrayList<NavigationTreeNode>();
        if (parent.getChildren() != null) {
            for (Thesaurus child : parent.getChildren()) {
                NavigationTreeNode childNode = builder.addThesaurus(context, parentNode, child);
                result.add(childNode);

                // Build childs
                if (child.getWikittyId() != null){
                    buildChildren(context, builder, childNode, child);
                }
            }
        }
    }

    @Override
    public NavigationTreeHandler createTreeHandler(JAXXObject context) {

        if (log.isDebugEnabled()) {
            log.debug("create handler");
        }

        NavigationTreeHandler handler;

        handler = new NavigationTreeHandler(
                getPrefix(),
                context,
                Strategy.PER_NODE) {

            private static final long serialVersionUID = 1L;

            @Override
            protected NavigationTreeModel getNavigationTreeModel() {
                return getSafeTreeModel(getContext());
            }

            @Override
            protected void treateError(Exception e) {
                ErrorDialogUI.showError(e);
            }

            @Override
            public ThesaurusUI getContext() {
                return (ThesaurusUI) this.context;
            }

            @Override
            protected Component getCurrentUI() {
                return null;
            }

            @Override
            protected Component getUI(NavigationTreeNode node) {
                return getHandler(context).getUI(context);
            }

            @Override
            protected boolean closeUI(Component component) throws Exception {
                return true;
            }

            @Override
            protected Component createUI(NavigationTreeNode node) throws Exception {
                return getHandler(context).getUI(context);
            }

            @Override
            protected void openUI(Component newUI, NavigationTreeNode node) throws Exception {
            }
        };
        // Selection multiple
        handler.setSelectionMode(NavigationTreeHandler.DISCONTIGUOUS_TREE_SELECTION);

        // save handler in ui context
        setTreeHandler(context, handler);

        // save tree in context
        setTree(context, ((ThesaurusUI) context).getThesaurus());

        return handler;
    }

    public void tryToSelect(JAXXContext context, Set<String> thesaurusId) {
        if (thesaurusId != null){
            List<NavigationTreeNode> nodes = new ArrayList<NavigationTreeNode>();

            // Find recursivly
            for (String id : thesaurusId){
                tryToSelect(id, getRootNode(), nodes);
            }

            // Select all
            JTree tree = getTree(context);
            TreePath[] paths = new TreePath[nodes.size()];
            int i=0;
            for (NavigationTreeNode node : nodes) {

                javax.swing.tree.TreeNode[] treeNodes = node.getPath();
                TreePath path = new TreePath(treeNodes);

                if (log.isDebugEnabled()){
                    log.debug("Try to select path : " + path);
                }

                paths[i++] = path;
                
                // Expend
                tree.expandPath(path);

                if (log.isDebugEnabled()){
                    log.debug("path "+paths[i-1]+" for node "+node);
                }
            }
            // Select all
            tree.setSelectionPaths(paths);
        }
    }

    public void tryToSelect(String thesaurusId, NavigationTreeNode node, List<NavigationTreeNode> nodes) {
        if (thesaurusId != null){
            if (thesaurusId.equals(getWikittyId(node))){
                // Add to select list
                nodes.add(node);

            } else {
                // Find in child
                Enumeration<NavigationTreeNode> children = node.children();
                while (children.hasMoreElements()) {
                    NavigationTreeNode child = children.nextElement();
                    tryToSelect(thesaurusId, child, nodes);
                }
            }
        }
    }

    protected String getWikittyId(NavigationTreeNode node){
        Thesaurus thesaurus = (Thesaurus)node.getBean();
        return thesaurus.getWikittyId();
    }

    public class ThesaurusTreeModelBuilder extends NavigationTreeModelBuilder {
        public ThesaurusTreeModelBuilder(JAXXContext context) {
            super("/", context, null, null);
        }

        // Return true if empty
        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode parentNode) {
            NavigationTreeModel treeModel = getTreeModel(context);
            treeModel.removeNodeFromParent(parentNode);
            return treeModel.getRoot().getChildCount() == 0;
        }

        public NavigationTreeNode addThesaurus(JAXXContext context, Thesaurus thesaurus) {
            NavigationTreeNode selectedNode = getSelectedNode(context);

            return addThesaurus(context, selectedNode, thesaurus);
        }

        public NavigationTreeNode addThesaurus(JAXXContext context, NavigationTreeNode parent, Thesaurus thesaurus) {
            return addThesaurus(parent, thesaurus.getWikittyId());
        }

        public NavigationTreeNode addThesaurus(NavigationTreeNode parent, String thesaurusId) {
            NavigationTreeNode result = null;
            Decorator<Thesaurus> tDecorator = getThesaurusDecorator();
            String path = "";
            if (parent == null) {
                parent = getRootNode();
                path = "..children[@wikittyId=\"" + thesaurusId + "\"]";
            } else {
                path = "../children[@wikittyId=\"" + thesaurusId + "\"]";
            }

            result = builder.build(parent, tDecorator, path, thesaurusId, null, null);
            if (log.isDebugEnabled()){
                log.debug("addThesaurus : " + thesaurusId + " to parent : " + parent == null ? "null" : parent.getFullPath() + " fullPath : " + result == null ? "result is null"  : result.getFullPath());
            }
            return result;
        }
    }

    protected Decorator<Thesaurus> getThesaurusDecorator() {
        Decorator<Thesaurus> tDecorator = VradiContext.get().getDecorateurProvinder().getDecorator(Thesaurus.class);
        return tDecorator;
    }
}
