package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;

import java.util.*;

public class Thesaurus {
    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(Thesaurus.class);
    
    protected TreeNode bean;
    protected String name;
    protected String wikittyId;
    protected TreeNode parent;
    protected Map<String,Thesaurus> children = new HashMap<String, Thesaurus>();

    public Thesaurus(TreeNode bean) {
        setBean(bean);
    }

    public TreeNode getBean() {
        bean.setName(getName());
        bean.clearChildren();
        for (Thesaurus child : getChildren()){
            bean.addChildren(child.getWikittyId());
        }
        if (parent != null){
            bean.setParent(parent.getWikittyId());
        }
        return bean;
    }

    public void setBean(TreeNode bean) {
        this.bean = bean;
        setName(bean.getName());
        this.setWikittyId(bean.getWikittyId());
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        try {
            if (bean.getChildren() != null){
                for (String thesaurusId : bean.getChildren()) {
                    TreeNode treeNodeChild = service.getThesaurus(thesaurusId);
                    if (treeNodeChild != null){
                        addChild(new Thesaurus(treeNodeChild));
                    }
                }
            }
            String parent = bean.getParent();
            if (parent != null){
                TreeNode treeNodeParent = service.getThesaurus(parent);
                if (treeNodeParent != null){
                    setParent(treeNodeParent);
                }
            }
        } catch (TechnicalException e) {
            log.error("Cant find thesaurus ", e);
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWikittyId() {
        return wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public TreeNode getParent() {
        return parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public Collection<Thesaurus> getChildren() {
        return children.values();
    }

    public void addChild(Thesaurus element) {
        children.put(element.getWikittyId(), element);
    }

    public void clearChildren() {
        children.clear();
    }

    public void removeChild(Thesaurus child) {
        children.remove(child);
    }

    public boolean addChildRecursif(Thesaurus child) {
        TreeNode p = child.getParent();
        if (bean.equals(p)){
            children.put(child.getWikittyId(), child);
            return true;
        } else {
            for (Thesaurus c : children.values()){
                return c.addChildRecursif(child);
            }
        }
        return false;
    }

    public Thesaurus removeThesaurusRecursivly(String id){
        Thesaurus thesaurus = children.get(id);
        if (thesaurus != null){
            return children.remove(id);
        } else {
            for (Thesaurus c : children.values()){
                return c.removeThesaurusRecursivly(id);
            }
        }
        return null;
    }

    public Thesaurus findThesaurus(String id) {
        Thesaurus thesaurus = children.get(id);
        if (thesaurus != null){
            return thesaurus;
        } else {
            for (Thesaurus c : children.values()){
                return c.findThesaurus(id);
            }
        }
        return null;
    }

    public void display(String s){
        String indent = "";
        log.info(s + " " + name + " " + wikittyId);
        displayChildren(children, s, indent);
    }

    private void displayChildren(Map<String, Thesaurus> children, String s, String indent) {
        indent = indent + "   ";
        for (Thesaurus c : children.values()){
            log.info(s + indent + c.name + " " + c.wikittyId);
        }
    }
}
