package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.VradiContext;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.EntityComboBox;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.n_;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXDatePicker;
import com.jurismarches.vradi.entities.Form;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.table.TableCellRenderer;
import com.jurismarches.vradi.VradiHelper;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.sharengo.wikitty.TreeNode;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OfferListUI extends javax.swing.JSplitPane implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferListUI.class);
    private static String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected java.lang.Boolean advencedSearchCollapsed;
    protected javax.swing.JButton clear;
    protected javax.swing.JButton colapse;
    protected org.jdesktop.swingx.JXCollapsiblePane collapsiblePane;
    protected javax.swing.JPanel criteriaPanel;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected javax.swing.JTabbedPane editTabs;
    protected org.jdesktop.swingx.JXTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.OfferListTableModel offerListTableModel;
    protected javax.swing.JTextArea request;
    protected javax.swing.ComboBoxModel requestModel;
    protected javax.swing.JComboBox requests;
    protected javax.swing.JButton search;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane4;
    private javax.swing.JScrollPane $JScrollPane6;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table3;
    private jaxx.runtime.swing.Table $Table5;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource12 = new DataBindingListener(this, "requests.model");
    private PropertyChangeListener $DataSource13 = new DataBindingListener(this, "colapse.text");
    private PropertyChangeListener $DataSource15 = new DataBindingListener(this, "collapsiblePane.collapsed");
    private PropertyChangeListener $DataSource19 = new DataBindingListener(this, "listTable.model");

    /* begin raw body code */    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    
        SwingUtil.fixTableColumnWidth(listTable, 2, 60);
    
        // Adding tooltip
        VradiHelper.setI18nTableHeaderRenderer(listTable,
                n_("vradi.offer.name"), n_("vradi.offer.name.tip"),
                n_("vradi.offerEdit.datePub"), n_("vradi.offerEdit.datePub.tip"),
                n_("vradi.offer.statut"), n_("vradi.offer.statut.tip"));
    
        listTable.setDefaultRenderer(JComponent.class, new TableCellRenderer() {
    
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof JComponent)
                    return (JComponent)value;
                return new JLabel(value.toString());
            }
        });
    
        listTable.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    getHandler().selectOffer(offerList);
                }
            }
    
        });
        java.util.List<String> queries = getHandler().loadRequests();
        requests.removeAllItems();
        for(String query : queries) {
            requests.addItem(query);
        }
    //    getOfferListTableModel().addToolTip();
    
        JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON3){
    
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    if (columnIndex > 2){
                        final String name = (String)column.getHeaderValue();
    
                        // Popup
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem menuRemoveCriteria = new JMenuItem();
                        menuRemoveCriteria.setText(_("vradi.menu.removeColumn"));
                        menuRemoveCriteria.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                removeColumn(name);
                            }
                        });
                        popup.add(menuRemoveCriteria);
    
                        // Show
                        popup.show(listTable, e.getX(), e.getY());
    
                    }
    
                }
            }
        });
    
    }
    
    protected void removeColumn(String name){
        OfferListTableModel model = (OfferListTableModel)listTable.getModel();
        TreeNode thesaurus = model.getThesaurusByName(name);
        getHandler().removeColumn(OfferListUI.this, thesaurus);
    }
    
    public void updateTableModel(){
        offerListTableModel = getHandler().getOfferListTableModel();
        listTable.setModel(offerListTableModel);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("requests.model".equals($binding)) {    
            addPropertyChangeListener("requestModel", $DataSource12);
        } else if ("colapse.text".equals($binding)) {    
            addPropertyChangeListener("advencedSearchCollapsed", $DataSource13);
        } else if ("collapsiblePane.collapsed".equals($binding)) {    
            addPropertyChangeListener("advencedSearchCollapsed", $DataSource15);
        } else if ("listTable.model".equals($binding)) {    
            addPropertyChangeListener("offerListTableModel", $DataSource19);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("requests.model".equals($dest)) {
                requests.setModel(getRequestModel());
            } else if ("colapse.text".equals($dest)) {
                colapse.setText(isAdvencedSearchCollapsed() ? _("vradi.criteria.notCollapse") : _("vradi.criteria.collapse"));
            } else if ("collapsiblePane.collapsed".equals($dest)) {
                collapsiblePane.setCollapsed(isAdvencedSearchCollapsed());
            } else if ("listTable.model".equals($dest)) {
                listTable.setModel(getOfferListTableModel());
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("requests.model".equals($binding)) {    
            removePropertyChangeListener("requestModel", $DataSource12);
        } else if ("colapse.text".equals($binding)) {    
            removePropertyChangeListener("advencedSearchCollapsed", $DataSource13);
        } else if ("collapsiblePane.collapsed".equals($binding)) {    
            removePropertyChangeListener("advencedSearchCollapsed", $DataSource15);
        } else if ("listTable.model".equals($binding)) {    
            removePropertyChangeListener("offerListTableModel", $DataSource19);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__clear(java.awt.event.ActionEvent event) {
        request.setText("");
    }

    public void doActionPerformed__on__colapse(java.awt.event.ActionEvent event) {
        setAdvencedSearchCollapsed(!isAdvencedSearchCollapsed());
    }

    public void doActionPerformed__on__requests(java.awt.event.ActionEvent event) {
        if(requests.getSelectedItem() != null) {request.setText(requests.getSelectedItem().toString());};
    }

    public void doActionPerformed__on__search(java.awt.event.ActionEvent event) {
        getHandler().executeQuery(this);validate();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.lang.Boolean getAdvencedSearchCollapsed() {
        return advencedSearchCollapsed;
    }

    public javax.swing.JButton getClear() {
        return clear;
    }

    public javax.swing.JButton getColapse() {
        return colapse;
    }

    public org.jdesktop.swingx.JXCollapsiblePane getCollapsiblePane() {
        return collapsiblePane;
    }

    public javax.swing.JPanel getCriteriaPanel() {
        return criteriaPanel;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public org.jdesktop.swingx.JXTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JTextArea getRequest() {
        return request;
    }

    public javax.swing.ComboBoxModel getRequestModel() {
        return requestModel;
    }

    public javax.swing.JComboBox getRequests() {
        return requests;
    }

    public javax.swing.JButton getSearch() {
        return search;
    }

    public java.lang.Boolean isAdvencedSearchCollapsed() {
        return advencedSearchCollapsed !=null && advencedSearchCollapsed;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAdvencedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advencedSearchCollapsed;
        this.advencedSearchCollapsed = newValue;
        firePropertyChange("advencedSearchCollapsed", oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange("offerListTableModel", oldValue, newValue);
    }

    public void setRequestModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.requestModel;
        this.requestModel = newValue;
        firePropertyChange("requestModel", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected jaxx.runtime.swing.Table get$Table5() {
        return $Table5;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add($Table1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane6, BorderLayout.CENTER);
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(requests, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($Table3, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(collapsiblePane, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JScrollPane4, new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add($Table5, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(request);
        // inline complete setup of $Table5
        $Table5.add(search, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table5.add(clear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table5.add(colapse, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToCollapsiblePane();
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(listTable);
        // init data bindings
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        applyDataBinding("requests.model");
        applyDataBinding("colapse.text");
        collapsiblePane.setAnimated(false);
        applyDataBinding("collapsiblePane.collapsed");
        listTable.setAutoResizeMode(2);
        applyDataBinding("listTable.model");
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListTableModel();
        createRequestModel();
        createAdvencedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.list.requests"));
        createRequests();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new jaxx.runtime.swing.Table());
        $Table3.setName("$Table3");
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new javax.swing.JScrollPane());
        $JScrollPane4.setName("$JScrollPane4");
        createRequest();
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new jaxx.runtime.swing.Table());
        $Table5.setName("$Table5");
        createSearch();
        createClear();
        createColapse();
        createCollapsiblePane();
        createCriteriaPanel();
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new javax.swing.JScrollPane());
        $JScrollPane6.setName("$JScrollPane6");
        createListTable();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

    protected void addChildrenToCollapsiblePane() {
        if (!allComponentsCreated) {
            return;
        }
        collapsiblePane.add(criteriaPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void createAdvencedSearchCollapsed() {
        $objectMap.put("advencedSearchCollapsed", advencedSearchCollapsed = false);
    }

    protected void createClear() {
        $objectMap.put("clear", clear = new javax.swing.JButton());
        clear.setName("clear");
        clear.setText(_("vradi.criteria.clear"));
        clear.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clear"));
    }

    protected void createColapse() {
        $objectMap.put("colapse", colapse = new javax.swing.JButton());
        colapse.setName("colapse");
        colapse.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__colapse"));
    }

    protected void createCollapsiblePane() {
        $objectMap.put("collapsiblePane", collapsiblePane = new org.jdesktop.swingx.JXCollapsiblePane());
        collapsiblePane.setName("collapsiblePane");
        collapsiblePane.setLayout(new BorderLayout());
    }

    protected void createCriteriaPanel() {
        $objectMap.put("criteriaPanel", criteriaPanel = new javax.swing.JPanel());
        criteriaPanel.setName("criteriaPanel");
        criteriaPanel.setLayout(new BorderLayout());
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        editTabs.setName("editTabs");
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new org.jdesktop.swingx.JXTable());
        listTable.setName("listTable");
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getHandler().getOfferListTableModel());
    }

    protected void createRequest() {
        $objectMap.put("request", request = new javax.swing.JTextArea());
        request.setName("request");
        request.setColumns(15);
        request.setLineWrap(true);
        request.setWrapStyleWord(true);
        request.setRows(3);
    }

    protected void createRequestModel() {
        $objectMap.put("requestModel", requestModel = getHandler().getRequestModel());
    }

    protected void createRequests() {
        $objectMap.put("requests", requests = new javax.swing.JComboBox());
        requests.setName("requests");
        requests.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__requests"));
    }

    protected void createSearch() {
        $objectMap.put("search", search = new javax.swing.JButton());
        search.setName("search");
        search.setText(_("vradi.criteria.search"));
        search.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__search"));
    }

}