/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class OfferListHandler {

    static private final Log log = LogFactory.getLog(OfferListHandler.class);

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param rootHandler
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        DateFormTypeFilterHandler criteriaHandler = new DateFormTypeFilterHandler();

        // Show criteria ui
        DateFormTypeFilterUI criteriaUI = criteriaHandler.initUI(rootContext);

        // show main ui
        context.add(this);
        context.add(criteriaHandler);
        context.add(criteriaUI);

        OfferListUI ui = new OfferListUI(context);

        ui.getCriteriaPanel().add(criteriaUI, BorderLayout.CENTER);

        // Saved in context
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, ui);

        return ui;
    }

    public DateFormTypeFilterHandler getCriteriaHandler(JAXXContext context) {
        return context.getContextValue(DateFormTypeFilterHandler.class);
    }

    public OfferListTableModel getOfferListTableModel() {
        List<Form> forms = new ArrayList<Form>();
        Calendar now = new GregorianCalendar();
        now.set(Calendar.HOUR, 0);
        now.set(Calendar.MINUTE, 0);
        now.set(Calendar.MILLISECOND, 0);
        try {
            forms = ServiceHelper.getVradiStorageService().findForms(null, null, null, now.getTime(), now.getTime(), null);
        } catch (TechnicalException eee) {
            log.error("Cant find forms for this day ", eee);
        }
        OfferListTableModel model = new OfferListTableModel(forms, true);
        return model;
    }

    public void addEditPane(JAXXContext context, Form data) {
        OfferListUI ui = getUI(context);
        ui.setDividerLocation(350);
        ui.setResizeWeight(0.65);
        ui.setDividerSize(10);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String id = data.getWikittyId();
        if (contentTabbedPane.indexOfTab(id) < 0) {
            OfferEditHandler handler = new OfferEditHandler();
            OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);

            VradiTabHeader panel = new VradiTabHeader();
            panel.getLabel().setText(data.getName());
            panel.setId(id);

            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), panel);
            panel.getCloseTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    closePane(e);
                }
            });
            panel.getDetachTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    detachPane(e);
                }
            });
        }

        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton) e.getSource();
        return (VradiTabHeader) button.getParent();
    }

    protected void closePane(MouseEvent e) {
        VradiTabHeader mytab = getTabHeader(e);
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        String id = mytab.getId();
        JTabbedPane contentTabbedPane = getContentPane(ui);
        contentTabbedPane.remove(contentTabbedPane.indexOfTab(id));
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();

        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = getContentPane(ui);
        OfferEditUI content = (OfferEditUI) contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));

        final JFrame frame = new JFrame(name);

        content.getValidate().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });

        content.getAnnuler().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });

        frame.setLayout(new BorderLayout());
        frame.add(content, BorderLayout.CENTER);
        frame.setVisible(true);
        frame.pack();
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI) context;
        }
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        edit(context, getUI(context).listTable.getSelectedRow(), getUI(context).offerListTableModel);
    }

    protected void edit(JAXXContext context, int i, OfferListTableModel model) {
        Form data = null;
        if (i == 0) {
            data = createForm(context);
        } else {
            data = model.getDatas().get(i - 1);
        }
        log.debug("Form selected : " + data);
        if (data != null) {
            addEditPane(context, data);
        }
    }

    public Form createForm(JAXXContext context) {
        List<WikittyExtension> extensions = null;
        try {
            extensions = ServiceHelper.getVradiStorageService().getAllFormTypes();
        } catch (TechnicalException ex) {
            log.error("Cant get all formTypes caused by : ", ex);
        }

//        String name = JOptionPane.showInputDialog(getUI(context), _("vradi.adminForm.askName"));
//        WikittyExtension ext = (WikittyExtension) JOptionPane.showInputDialog(getUI(context), _("vradi.adminForm.askName"),
//                _("vradi.adminForm.askName"), JOptionPane.QUESTION_MESSAGE, null,
//                extensions.toArray(), extensions.size() == 0 ? null : extensions.get(0));

        CreateOfferDialogUI dialog = new CreateOfferDialogUI(context);

        dialog.setVisible(true);

        log.debug(dialog.isOk());
        log.debug(dialog.getNameValue());
        log.debug(dialog.getFormType());

        if (dialog.isOk()) {
            String name = dialog.getNameValue();
            WikittyExtension ext = dialog.getFormType();

            log.debug("FormType selected : " + ext);

            // If is canceled
            if (ext == null) {
                return null;
            }
            Form form = new FormImpl();
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) form;
            Wikitty wikitty = entityWikitty.getWikitty();
            wikitty.addExtension(ext);
            form = (Form) entityWikitty;
            if (name != null && !name.isEmpty()) {
                form.setName(name);
            } else {
                form.setName(_("vradi.forms.new.defaultName"));
            }
            return form;
        }
        return null;
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public void executeQuery(OfferListUI ui) {
        String query = ui.getRequest().getText().trim();
        List<Form> forms;
        if (ui.isAdvencedSearchCollapsed()) {
            forms = VradiHelper.executeQuery(query, null, null, null, null, null);
        } else {
            DateFormTypeFilterUI criterias = getCriteriaHandler(ui).getUI(ui);
            Component[] thesaurusCriteria = criterias.getCriterias().getComponents();
            List<String>[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; i++) {
                Thesaurus th = (Thesaurus) ((VradiCriteriaField) thesaurusCriteria[i]).getCombo().getSelectedItem();
                if (th != null) {
                    thesaurus[i] = new ArrayList<String>();
                    thesaurus[i].add(th.getWikittyId());
                    VradiHelper.getThesaurusChildren(th, thesaurus[i]);
                }
            }
            forms = VradiHelper.executeQuery(query, (WikittyExtension) criterias.getFormTypeSelection().getSelectedItem(),
                    (String) criterias.getDateTypeSelection().getSelectedItem(),
                    criterias.getFromDate().getDate(), criterias.getToDate().getDate(), thesaurus);
        }
        log.debug(forms.size());
        addRequestToProperties(query);
        ((DefaultComboBoxModel) ui.getRequests().getModel()).removeElement(query);
        ui.getRequests().insertItemAt(query, 0);
        ui.getRequests().setSelectedIndex(0);
        ui.getOfferListTableModel().setDatas(forms);
    }

    public void addRequestToProperties(String request) {
        VradiHelper.addRequestToProperties(request);
    }

    public java.util.List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public void removeColumn(JAXXContext context, TreeNode thesaurus) {

        // Save in properties
        VradiHelper.removeVradiListColumns(thesaurus);

        // Refresh model
        getUI(context).updateTableModel();
    }
}
