/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi;

import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.VradiCriteriaField;
import com.jurismarches.vradi.ui.VradiI18nTableCellRenderer;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import org.nuiton.util.MD5;
import org.nuiton.util.Resource;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyDescriptor;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class VradiHelper {

    private static final Log log = LogFactory.getLog(VradiHelper.class);

    public static String QUERIES = "vradi.queries";
    public static String XML_STREAMS = "vradi.xmlStreams";
    public static String CRITERIAS = "vradi.criterias";
    public static String THESAURUS = "vradi.thesaurus";
    public static String COLUMNS = "vradi.columns";

    // Singleton sur les proprietes
    public static Properties userProperties = null;
    public static Properties querryProperties = null;

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    protected static Properties getUserProperties() {
        if (userProperties == null) {
            userProperties = getProperties(getVradiConfig().getUserFile());
        }
        return userProperties;
    }

    protected static Properties getProperties(File propertyFile) {
        Properties properties;
        try {
            properties = new Properties();

            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            InputStream input = new FileInputStream(propertyFile);
            properties.load(input);
        } catch (IOException ioe) {

            throw new IllegalStateException("could not get " + propertyFile.getName() + " caused by : " + ioe.getMessage(), ioe);
        }
        return properties;
    }

    protected static Properties store(Properties property, File file) {
        try {
            Writer fileOutputStream = new OutputStreamWriter(new FileOutputStream(file), "ISO-8859-1");
            property.store(fileOutputStream, "");
        } catch (IOException e) {
            log.error("Cant save request property caused by : ", e);
        }

        return property;
    }

    protected static void storeUserProperties(Properties properties) {

        File userFile = getVradiConfig().getUserFile();
        store(properties, userFile);
    }

    protected static List<String> getUserListOfStringFromProperties(String propertyName) {
        Properties properties = getUserProperties();
        List<String> result = new ArrayList<String>();
        // Recuperation des propriete

        String resultNames = properties.getProperty(propertyName);
        if (resultNames != null) {
            for (String resultName : resultNames.split(",")) {
                String utf8ResultName = null;
                try {
                    utf8ResultName = new String(resultName.getBytes("ISO-8859-1"), "UTF-8");
                } catch (UnsupportedEncodingException eee) {
                    utf8ResultName = resultName;
                }
                result.add(utf8ResultName);
            }
        } else {
            log.warn("Cant find property : " + propertyName);
        }
        return result;
    }

    protected static void storeUserListProperties(String propertyName, List<String> values) {
        Properties properties = getUserProperties();
        StringBuffer store = new StringBuffer();
        for (String value : values) {
            store.append(value).append(",");
        }

        // Removing last ","
        int length = store.length() - 1;
        if (length > 0) {
            store.deleteCharAt(length);
        }
        properties.setProperty(propertyName, store.toString());
        storeUserProperties(properties);
    }

    protected static void addToUserListProperties(String propertyName, String value) {
        addToUserListProperties(propertyName, value, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace) {
        addToUserListProperties(propertyName, value, replace, false, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace, boolean inverse, boolean uniqueValues) {
        List<String> result = replace ? new ArrayList<String>() : getUserListOfStringFromProperties(propertyName);
        if (value != null) {
            String isoValue;
            try {
                isoValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
            } catch (UnsupportedEncodingException eee) {
                isoValue = value;
            }
            if (uniqueValues && result.contains(isoValue)) {
                result.remove(isoValue);
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            } else {
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            }
        }
        storeUserListProperties(propertyName, result);
    }

    protected static List<String> removeToUserListProperties(String propertyName, String value) {
        Properties properties = getUserProperties();
        List<String> result = getUserListOfStringFromProperties(propertyName);
        result.remove(value);
        storeUserListProperties(propertyName, result);

        return result;
    }

    public static void addRequestToProperties(String request) {
        addToUserListProperties(QUERIES, request, false, true, true);
    }

    public static java.util.List<String> loadRequests() {
        return getUserListOfStringFromProperties(QUERIES);
    }

    public static void setLastItemOfXmlStream(String xmlStreamName, String value) {
        addToUserListProperties(XML_STREAMS + "." + xmlStreamName, value, true);
    }

    public static String getLastItemOfXmlStream(String xmlStreamName) {
        List<String> prop = getUserListOfStringFromProperties(XML_STREAMS + "." + xmlStreamName);
        if (!prop.isEmpty()) {
            return prop.get(0);
        }
        return null;
    }

    public static List<String> getVradiListCriteria() {
        return getUserListOfStringFromProperties(CRITERIAS);
    }

    public static void removeVradiListCriteria(TreeNode value) {
        removeToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static void addVradiListCriteria(TreeNode value) {
        addToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static List<String> getVradiListThesaurus() {
        return getUserListOfStringFromProperties(THESAURUS);
    }

    public static void removeVradiListThesaurus(TreeNode value) {
        removeToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static void addVradiListThesaurus(TreeNode value) {
        addToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static List<String> getVradiListColumns() {
        return getUserListOfStringFromProperties(COLUMNS);
    }

    public static void removeVradiListColumns(TreeNode value) {
        removeToUserListProperties(COLUMNS, value.getWikittyId());
    }

    public static void addVradiListColumns(TreeNode value) {
        addToUserListProperties(COLUMNS, value.getWikittyId());
    }

    public static String getEntityName(Object o) {
        return getStringValue(o, "name");
    }

    public static String getStringValue(Object o, String method) {
        try {
            if (o == null) {
                return "";
            }
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(o, method);
            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();

            Object invoke = getter.invoke(o);
            if (invoke == null) {
                return "";
            }
            String result = (String) invoke;
            return result;
        } catch (NoSuchMethodException ex) {
            log.error(ex);
        } catch (SecurityException ex) {
            log.error(ex);
        } catch (IllegalAccessException ex) {
            log.error(ex);
        } catch (IllegalArgumentException ex) {
            log.error(ex);
        } catch (InvocationTargetException ex) {
            log.error(ex);
        }
        return "";
    }

    // Models
    public static FieldTypeEnum getFieldTypeEnum(FieldType type) {
        for (FieldTypeEnum typeEnum : FieldTypeEnum.values()) {
            if (typeEnum.isType(type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static ComboBoxModel getFormTypesModel() {
        ComboBoxModel model = new DefaultComboBoxModel(getFormTypes());
        return model;
    }

    public static Object[] getFormTypes() {
        VradiStorageService vradiStorageService = ServiceHelper.getVradiStorageService();
        List<WikittyExtension> formTypes = new ArrayList<WikittyExtension>();
        try {
            formTypes = vradiStorageService.getAllFormTypes();
        } catch (TechnicalException eee) {
            eee.printStackTrace();
        }
        Object[] result = new Object[formTypes.size() + 1];
        result[0] = null;
        for (int i = 0; i < formTypes.size(); i++) {
            result[i + 1] = formTypes.get(i);
        }
        return result;
    }

    // Dates
    public static Date getLastDayDate() {
        Date result = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        cal.roll(Calendar.DAY_OF_MONTH, false);

        return cal.getTime();
    }

    public static Date getBeginMonthDate() {
        Date result = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        cal.set(Calendar.DAY_OF_MONTH, 1);

        return cal.getTime();
    }

    public static void getThesaurusChildren(Thesaurus th, List<String> thesaurusIds) {
        log.info(th.getName());
        for (Thesaurus child : th.getChildren()) {
            if (!thesaurusIds.contains(child.getWikittyId())) {
                thesaurusIds.add(child.getWikittyId());
                getThesaurusChildren(child, thesaurusIds);
            }
        }
    }

    public static List<Form> executeQuery(String query, WikittyExtension extension,
                                          String dateType, Date beginDate, Date endDate, List<String>[] thesaurus) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(query);
            }
            List<Form> result = ServiceHelper.getVradiStorageService().findForms(query, extension, dateType, beginDate, endDate, thesaurus);
            if (log.isDebugEnabled()) {
                log.debug(result.size());
            }
            if (log.isDebugEnabled()) {
                for (Form form : result) {
                    log.debug(form.getName());
                }
            }
            return result;
        } catch (TechnicalException eee) {
            log.error("Cant execute query : ", eee);
        }
        return null;
    }

    // I18n
    public static void setI18nTableHeaderRenderer(JTable table, String... libelles) {
        table.getTableHeader().setDefaultRenderer(new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles));
    }
}