/* *##%
 * Copyright (c) 2009 Sharengo, Guillaume Dufrene, Benjamin POUSSIN.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Each business object will inherit of this class.
 *
 * Last update: $Date$
 * by : $Author$
 */
public class BusinessEntityWikitty implements BusinessEntity {

    private static final long serialVersionUID = 1L;

    /** used to add property change support to wikitty object */
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    protected Wikitty wikitty;

	public BusinessEntityWikitty(Wikitty wi) {
		setWikitty(wi);
	}

	public BusinessEntityWikitty() {
		setWikitty( new Wikitty() );
	}

    public String getWikittyId() {
        String result = getWikitty().getId();
        return result;
    }

    public String getWikittyVersion() {
        String result = getWikitty().getVersion();
        return result;
    }

    public void setWikittyVersion(String version) {
        getWikitty().setVersion(version);
    }

    @Override
    public void addExtension(WikittyExtension extension) {
        getWikitty().addExtension(extension);
    }

    @Override
    public Collection<WikittyExtension> getExtensions() {
        return getWikitty().getExtensions();
    }

    public void setWikitty(Wikitty wikitty) {
        wikitty = upgradeData(wikitty, getStaticExtensions());
		for ( WikittyExtension ext : getStaticExtensions() ) {
			wikitty.addExtension(ext);
		}
		this.wikitty = wikitty;
	}

    public Wikitty getWikitty() {
		return wikitty;
	}
    
    public Collection<String> getExtensionNames() {
        Collection<String> result = getWikitty().getExtensionNames();
        return result;
    }

    public Collection<String> getExtensionFields(String ext) {
        Collection<String> result = getWikitty().getExtension(ext).getFieldNames();
        return result;
    }

    public FieldType getFieldType(String ext, String fieldName) {
        FieldType result = getWikitty().getExtension(ext).getFieldType(fieldName);
        return result;
    }

    public Object getField(String ext, String fieldName) {
        Object result = null;
        FieldType type = getFieldType(ext, fieldName);
        if(type.isCollection()) {
            result = getWikitty().getFieldAsObject(ext, fieldName);
        } else {
            switch(type.getType()) {
                case BOOLEAN:
                    result = getWikitty().getFieldAsBoolean(ext, fieldName);
                    break;
                case DATE:
                    result = getWikitty().getFieldAsDate(ext, fieldName);
                    break;
                case NUMERIC:
                    result = getWikitty().getFieldAsBigDecimal(ext, fieldName);
                    break;
                case STRING:
                    result = getWikitty().getFieldAsString(ext, fieldName);
                    break;
                case WIKITTY:
                    result = getWikitty().getFieldAsString(ext, fieldName);   
                    break;
                default:
                    result = getWikitty().getFieldAsObject(ext, fieldName);
                    break;
            }
        }
        return result;
    }

    public void setField(String ext, String fieldName, Object value) {
        getWikitty().setField(ext, fieldName, value);
        propertyChange.firePropertyChange(fieldName,null,value);
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return Collections.emptyList();
    }

    protected Wikitty upgradeData(Wikitty wikitty, Collection<WikittyExtension> extensions) {
        for (WikittyExtension ext : extensions) {
            if (wikitty.hasExtension(ext.getName())) {
                WikittyExtension oldExt = wikitty.getExtension(ext.getName());
                String newVersion = ext.getVersion();
                String oldVersion = oldExt.getVersion();
                if (WikittyUtil.versionGreaterThan(newVersion, oldVersion)) {
                    WikittyExtensionMigration migration =
                            WikittyExtensionMigration.migrationRegistry.get(ext.getName());
                    if (migration != null) {
                        wikitty = migration.migrate(wikitty, oldExt, ext);
                    }
                }
            }
        }
        return wikitty;
    }

}
