/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class OfferListTableModel
extends AbstractTableModel {
    private static Log log = LogFactory.getLog(OfferListTableModel.class);
    public static String NEW_FORM = I18n._((String)"vradi.offer.create");
    protected List<Form> datas;
    protected Map<String, TreeNode> thesaurus;
    protected List<String> columnNames;
    protected boolean creationEnabled;

    public OfferListTableModel(List<Form> datas, boolean creationEnabled) {
        this.creationEnabled = creationEnabled;
        this.columnNames = new ArrayList<String>();
        this.columnNames.add(I18n.n_((String)"vradi.offer.name"));
        this.columnNames.add(I18n.n_((String)"vradi.offerEdit.datePub"));
        this.columnNames.add(I18n.n_((String)"vradi.offer.statut"));
        this.thesaurus = new HashMap<String, TreeNode>();
        List<String> columnsThesaurusId = VradiHelper.getVradiListColumns();
        for (String id : columnsThesaurusId) {
            try {
                TreeNode t = ServiceHelper.getVradiStorageService().getThesaurus(id);
                if (t == null) continue;
                this.thesaurus.put(t.getName(), t);
                this.columnNames.add(t.getName());
            }
            catch (TechnicalException e) {
                log.error((Object)("Cant get thesaurus : " + id), (Throwable)e);
            }
        }
        this.datas = datas;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    @Override
    public int getRowCount() {
        int count = this.datas.size();
        if (this.creationEnabled) {
            ++count;
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rowData = this.datas.size();
        if (this.creationEnabled) {
            rowData = row - 1;
        }
        if (this.creationEnabled && row == 0) {
            if (col == 0) {
                return NEW_FORM;
            }
            return "";
        }
        if (rowData < this.datas.size() && this.datas.get(rowData) != null) {
            if (col < 3) {
                if (col == 0) {
                    return this.datas.get(rowData).getName();
                }
                if (col == 1) {
                    return this.datas.get(rowData).getDatePub().toString();
                }
                if (col == 2) {
                    return this.datas.get(rowData).getStatut();
                }
            } else {
                Set<String> thesaurusIdOfBean = this.datas.get(rowData).getThesaurus();
                String result = "";
                if (thesaurusIdOfBean != null) {
                    TreeNode thesaurusOfColumns = this.thesaurus.get(this.columnNames.get(col - 3));
                    for (String idOfBean : thesaurusIdOfBean) {
                        if (!thesaurusOfColumns.getChildren().contains(idOfBean)) continue;
                        TreeNode thesaurusToDisplay = null;
                        try {
                            thesaurusToDisplay = ServiceHelper.getVradiStorageService().getThesaurus(idOfBean);
                        }
                        catch (TechnicalException e) {
                            log.error((Object)("cant get thesaurus : " + idOfBean), (Throwable)e);
                        }
                        if (thesaurusToDisplay == null) continue;
                        result = result + thesaurusToDisplay.getName() + ", ";
                    }
                    if (result.length() > 0) {
                        result = result.substring(0, result.length() - 2);
                    }
                }
                return result;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        if (this.creationEnabled && this.getRowCount() == 1) {
            return String.class;
        }
        return this.getValueAt(1, c) == null ? null : this.getValueAt(1, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public List<Form> getDatas() {
        return this.datas;
    }

    public void setDatas(List<Form> datas) {
        this.datas = datas;
        this.fireTableDataChanged();
    }

    public TreeNode getThesaurusByName(String name) {
        return this.thesaurus.get(name);
    }
}

