/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.spelling.QueryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellingQueryConverter
extends QueryConverter {
    protected Pattern QUERY_REGEX = Pattern.compile("(?:(?!(\\w+:|\\d+)))\\w+");

    @Override
    public Collection<Token> convert(String original) {
        if (original == null) {
            return Collections.emptyList();
        }
        ArrayList<Token> result = new ArrayList<Token>();
        Matcher matcher = this.QUERY_REGEX.matcher(original);
        while (matcher.find()) {
            String word = matcher.group(0);
            if (word.equals("AND") || word.equals("OR")) continue;
            try {
                Token token;
                TokenStream stream = this.analyzer.reusableTokenStream("", (Reader)new StringReader(word));
                while ((token = stream.next()) != null) {
                    token.setStartOffset(matcher.start());
                    token.setEndOffset(matcher.end());
                    result.add(token);
                }
            }
            catch (IOException e) {
            }
        }
        return result;
    }
}

