/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateRequest
extends SolrRequest {
    private List<SolrInputDocument> documents = null;
    private List<String> deleteById = null;
    private List<String> deleteQuery = null;
    private ModifiableSolrParams params;

    public UpdateRequest() {
        super(SolrRequest.METHOD.POST, "/update");
    }

    public UpdateRequest(String url) {
        super(SolrRequest.METHOD.POST, url);
    }

    public void clear() {
        if (this.documents != null) {
            this.documents.clear();
        }
        if (this.deleteById != null) {
            this.deleteById.clear();
        }
        if (this.deleteQuery != null) {
            this.deleteQuery.clear();
        }
    }

    public UpdateRequest add(SolrInputDocument doc) {
        if (this.documents == null) {
            this.documents = new ArrayList<SolrInputDocument>(2);
        }
        this.documents.add(doc);
        return this;
    }

    public UpdateRequest add(Collection<SolrInputDocument> docs) {
        if (this.documents == null) {
            this.documents = new ArrayList<SolrInputDocument>(docs.size() + 1);
        }
        this.documents.addAll(docs);
        return this;
    }

    public UpdateRequest deleteById(String id) {
        if (this.deleteById == null) {
            this.deleteById = new ArrayList<String>();
        }
        this.deleteById.add(id);
        return this;
    }

    public UpdateRequest deleteByQuery(String q) {
        if (this.deleteQuery == null) {
            this.deleteQuery = new ArrayList<String>();
        }
        this.deleteQuery.add(q);
        return this;
    }

    public UpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher) {
        return this.setAction(action, waitFlush, waitSearcher, 1);
    }

    public UpdateRequest setAction(ACTION action, boolean waitFlush, boolean waitSearcher, int maxSegments) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        if (action == ACTION.OPTIMIZE) {
            this.params.set("optimize", new String[]{"true"});
            this.params.set("maxSegments", maxSegments);
        } else if (action == ACTION.COMMIT) {
            this.params.set("commit", new String[]{"true"});
        }
        this.params.set("waitFlush", new String[]{waitFlush + ""});
        this.params.set("waitSearcher", new String[]{waitSearcher + ""});
        return this;
    }

    public void setParam(String param, String value) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set(param, new String[]{value});
    }

    public void setParams(ModifiableSolrParams params) {
        this.params = params;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "text/xml; charset=utf-8");
    }

    public String getXML() throws IOException {
        String xml;
        boolean deleteQ;
        StringWriter writer = new StringWriter();
        if (this.documents != null && this.documents.size() > 0) {
            writer.write("<add>");
            for (SolrInputDocument doc : this.documents) {
                if (doc == null) continue;
                ClientUtils.writeXML(doc, writer);
            }
            writer.write("</add>");
        }
        boolean deleteI = this.deleteById != null && this.deleteById.size() > 0;
        boolean bl = deleteQ = this.deleteQuery != null && this.deleteQuery.size() > 0;
        if (deleteI || deleteQ) {
            writer.append("<delete>");
            if (deleteI) {
                for (String id : this.deleteById) {
                    writer.append("<id>");
                    XML.escapeCharData((String)id, (Writer)writer);
                    writer.append("</id>");
                }
            }
            if (deleteQ) {
                for (String q : this.deleteQuery) {
                    writer.append("<query>");
                    XML.escapeCharData((String)q, (Writer)writer);
                    writer.append("</query>");
                }
            }
            writer.append("</delete>");
        }
        return (xml = writer.toString()).length() > 0 ? xml : null;
    }

    public ModifiableSolrParams getParams() {
        return this.params;
    }

    @Override
    public UpdateResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = System.currentTimeMillis();
        UpdateResponse res = new UpdateResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }

    public boolean isWaitFlush() {
        return this.params != null && this.params.getBool("waitFlush", false);
    }

    public boolean isWaitSearcher() {
        return this.params != null && this.params.getBool("waitSearcher", false);
    }

    public ACTION getAction() {
        if (this.params == null) {
            return null;
        }
        if (this.params.getBool("commit", false)) {
            return ACTION.COMMIT;
        }
        if (this.params.getBool("optimize", false)) {
            return ACTION.OPTIMIZE;
        }
        return null;
    }

    public void setWaitFlush(boolean waitFlush) {
        this.setParam("waitFlush", waitFlush + "");
    }

    public void setWaitSearcher(boolean waitSearcher) {
        this.setParam("waitSearcher", waitSearcher + "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ACTION {
        COMMIT,
        OPTIMIZE;

    }
}

