/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.services.WikittyCacheJCS;
import org.nuiton.wikitty.services.WikittyServiceAccessStat;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.nuiton.wikitty.services.XMPPNotifierTransporter;

public class WikittyConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(WikittyConfig.class);

    public WikittyConfig() {
        this((String[])null);
    }

    public WikittyConfig(String[] args) {
        block2: {
            this.init();
            try {
                this.parse(args);
            }
            catch (ArgumentsParserException eee) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't load wikitty configuration", (Throwable)eee);
            }
        }
    }

    public WikittyConfig(String configFilename) {
        this(new String[]{"--option", "config.file", configFilename});
    }

    public WikittyConfig(Properties props) {
        this();
        for (String key : props.stringPropertyNames()) {
            this.setDefaultOption(key, props.getProperty(key));
        }
    }

    protected void init() {
        this.loadDefaultOptions(WikittyOption.class);
        this.loadActions(WikittyAction.class);
    }

    public static void help() {
        System.out.println("Wikitty configuration and action");
        System.out.println("Options (set with --option <key> <value>:");
        for (WikittyOption wikittyOption : WikittyOption.values()) {
            log.debug((Object)("\t" + wikittyOption.key + "(" + wikittyOption.defaultValue + "):" + wikittyOption.description));
        }
        log.debug((Object)"Actions:");
        for (Enum enum_ : WikittyAction.values()) {
            log.debug((Object)("\t" + Arrays.toString(((WikittyAction)enum_).aliases) + "(" + ((WikittyAction)enum_).action + "):" + ((WikittyAction)enum_).description));
        }
        System.exit(0);
    }

    public static enum WikittyAction implements ApplicationConfig.ActionDef
    {
        HELP(I18n._((String)"Wikitty help"), WikittyConfig.class.getName() + "#help", "-h", "--help");

        public String description;
        public String action;
        public String[] aliases;

        private WikittyAction(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public void setAliases(String[] aliases) {
            this.aliases = aliases;
        }
    }

    public static enum WikittyOption implements ApplicationConfig.OptionDef
    {
        WIKITTY_CONFIG_FILE("config.file", I18n._((String)"Main configuration wikitty file"), "wikitty-config.properties", String.class, true, true),
        WIKITTY_DATA_DIR("wikitty.data.directory", I18n._((String)"Data directory where wikitty store data"), "./target/data", String.class, false, false),
        WIKITTY_STORAGE_JDBC_QUERY_FILE("wikitty.storage.jdbc.queryfile", I18n._((String)"JDBC query configuration file. You can put more than one file to load specific SQL statement for your database. Exemple: wikitty-jdbc-query.properties,wikitty-jdbc-query-mysql.properties"), "wikitty-jdbc-query.properties", String.class, false, false),
        WIKITTY_STORAGE_JDBC_DRIVER("wikitty.storage.jdbc.driver", I18n._((String)"JDBC driver name"), "org.h2.Driver", String.class, false, false),
        WIKITTY_STORAGE_JDBC_URL("wikitty.storage.jdbc.host", I18n._((String)"JDBC url"), "jdbc:h2:file:${" + WIKITTY_DATA_DIR.getKey() + "}/db", String.class, false, false),
        WIKITTY_STORAGE_JDBC_LOGIN("wikitty.storage.jdbc.login", I18n._((String)"JDBC login name"), "sa", String.class, false, false),
        WIKITTY_STORAGE_JDBC_PASSWORD("wikitty.storage.jdbc.password", I18n._((String)"JDBC password"), "", String.class, false, false),
        WIKITTY_STORAGE_JDBC_XADATASOURCE("wikitty.storage.jdbc.xadatasource", I18n._((String)"JDBC xadatasource driver"), "org.h2.jdbcx.JdbcDataSource", String.class, false, false),
        WIKITTY_STORAGE_JDBC_XADATASOURCE_H2_URL("wikitty.storage.jdbc.xadatasource.org.h2.jdbcx.JdbcDataSource.URL", I18n._((String)"JDBC xadatasource property h2 url"), "${" + WIKITTY_STORAGE_JDBC_URL.getKey() + "}", String.class, false, false),
        WIKITTY_STORAGE_JDBC_XADATASOURCE_H2_USER("wikitty.storage.jdbc.xadatasource.org.h2.jdbcx.JdbcDataSource.user", I18n._((String)"JDBC xadatasource property h2 username"), "${" + WIKITTY_STORAGE_JDBC_LOGIN.getKey() + "}", String.class, false, false),
        WIKITTY_STORAGE_JDBC_XADATASOURCE_H2_PASSWORD("wikitty.storage.jdbc.xadatasource.org.h2.jdbcx.JdbcDataSource.password", I18n._((String)"JDBC xadatasource property h2 password"), "${" + WIKITTY_STORAGE_JDBC_PASSWORD.getKey() + "}", String.class, false, false),
        WIKITTY_SEARCHENGINE_SOLR_HOME("wikitty.searchengine.solr.home", I18n._((String)"SolR directory home. You can put solr.xml config file in. If not null, replace solr.solr.home environment vairable"), null, String.class, false, false),
        WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_DATA("wikitty.searchengine.solr.directory.data", I18n._((String)"Solr data directory"), "${" + WIKITTY_DATA_DIR.getKey() + "}/solr", File.class, false, false),
        WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY("wikitty.searchengine.solr.directory.factory", I18n._((String)"SolR storage type possible value: solr.StandardDirectoryFactory or org.nuiton.wikitty.storage.solr.RAMDirectoryFactory (or when solr 4.0 will be used org.apache.solr.core.RAMDirectoryFactory)"), "solr.StandardDirectoryFactory", String.class, false, false),
        WIKITTY_WIKITTYSERVICE_COMPONENTS("wikitty.WikittyService.components", I18n._((String)"WikittyService to use (list must be in right order. ex: org.nuiton.wikitty.WikittyServiceStorage,org.nuiton.wikitty.WikittyServiceNotifier,org.nuiton.wikitty.WikittyServiceCached,org.nuiton.wikitty.WikittyServiceSecurity)"), WikittyServiceInMemory.class.getName(), String.class, false, false),
        WIKITTY_WIKITTYSERVICEINMEMORY_PERSISTENCE("wikitty.WikittyServiceInMemory.persistence", I18n._((String)"Indique si les donnees sont stocker entre deux utilisations."), "false", Boolean.class, false, false),
        WIKITTY_WIKITTYSERVICEINMEMORY_PERSISTENCE_FILE("wikitty.WikittyServiceInMemory.persistence.file", I18n._((String)"Fichier ou les donnees sont stocker"), "${" + WIKITTY_DATA_DIR.getKey() + "}/wikitty-inmemory.ser", File.class, false, false),
        WIKITTY_WIKITTYSERVICESTORAGE_COMPONENTS("wikitty.WikittyServiceStorage.components", I18n._((String)"WikittyServiceStorage component to use (ExtensionStorage, WikittyStorage, SearchEngine)"), "org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC,org.nuiton.wikitty.jdbc.WikittyStorageJDBC,org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr", String.class, false, false),
        WIKITTY_WIKITTYSERVICENOTIFIER_COMPONENTS("wikitty.WikittyServiceNotifier.components", I18n._((String)"WikittyServiceNotifier component to use (transporter classto use for propagate or listen remote event)"), XMPPNotifierTransporter.class.getName(), String.class, false, false),
        WIKITTY_TRANSACTION_WIKITTYSERVICE_COMPONENTS("wikitty.transaction.WikittyService.components", I18n._((String)"WikittyService to use for transaction (must be in memory)ex: org.nuiton.wikitty.services.WikittyServiceInMemory or org.nuiton.wikitty.services.WikittyServiceInMemoryJdbcSolr)"), WikittyServiceInMemory.class.getName(), String.class, false, false),
        WIKITTY_WIKITTYSERVICECACHED_COMPONENTS("wikitty.WikittyServiceCached.components", I18n._((String)"Indique le composant a utiliser pour le cache"), WikittyCacheJCS.class.getName(), String.class, false, false),
        WIKITTY_CACHE_PRIORITY_EXTENSIONS("wikitty.service.cache.priority.extensions", I18n._((String)"Indique la liste des extensions qui doivent etre conservee prioritairement"), "", String.class, false, false),
        WIKITTY_CACHE_SIMPLE_REFERENCE_TYPE("wikitty.service.cache.simple.reference.type", I18n._((String)"Indique le type de reference a utiliser pour les extensions non prioritaires dans le WikittyCacheSimple (soft ou hard)"), "soft", String.class, false, false),
        WIKITTY_WIKITTYSERVICEACCESSSTAT_COMPONENTS("wikitty.WikittyServiceAccessStat.components", I18n._((String)"Indique le composant a utiliser pour le stockage des acces"), WikittyServiceAccessStat.AccessStatStorageWikitty.class.getName(), String.class, false, false),
        WIKITTY_ACCESSSTAT_EXTENSIONS("wikitty.service.accessstat.extensions", I18n._((String)"Indique la liste d'extension dont il faut monitorer l'acces"), "WikittyPubText,WikittyPubData", String.class, false, false),
        WIKITTY_SERVER_CONFIG("wikitty.service.server.config", I18n._((String)"Jetty server configuration file name"), "wikitty-server-config.xml", String.class, false, false),
        WIKITTY_SERVER_URL("wikitty.service.server.url", I18n._((String)"Hessian server url, use by server to know path and port to bind servlet and client to contact server"), "http://service.codelutin.com/wikitty", String.class, false, false),
        WIKITTY_EXPORT_THREADNUMBER("wikitty.addon.export.threadnumber", I18n._((String)"number of thread used to export task"), "1", Integer.class, false, false),
        WIKITTY_EXPORT_DIRECTORY("wikitty.addon.export.directory", I18n._((String)"directory path where export asynchronous file are stored"), "${" + WIKITTY_DATA_DIR.getKey() + "}/export", String.class, false, false),
        WIKITTY_EXPORT_PUBLICURL("wikitty.addon.export.publicurl", I18n._((String)"url used by client to retrieve export file when job is ended"), "file://${" + WIKITTY_DATA_DIR.getKey() + "}/export/", String.class, false, false),
        WIKITTY_CACHE_RESTORE_COPIES("wikitty.service.cache.allwaysRestoreCopies", I18n._((String)"Indique si le cache retourne des copies des objets ou des proxies"), "false", Boolean.class, false, false),
        WIKITTY_EVENT_PROPAGATE("wikitty.service.event.propagate", I18n._((String)"Indique si le service d'event propage sur le reseau les evenements"), "false", Boolean.class, false, false),
        WIKITTY_EVENT_LISTEN("wikitty.service.event.listen", I18n._((String)"Indique si le service d'event ecoute sur le reseau les evenements"), "false", Boolean.class, false, false),
        WIKITTY_EVENT_TRANSPORTER_XMPP_SERVER("wikitty.service.event.transporter.xmpp.server", I18n._((String)"XMPP server to use for XMPP transporter"), "im.codelutin.com", String.class, false, false),
        WIKITTY_EVENT_TRANSPORTER_XMPP_ROOM("wikitty.service.event.transporter.xmpp.room", I18n._((String)"Room to use for XMPP transporter"), "test@conference.im.codelutin.com", String.class, false, false),
        WIKITTY_SLAVE_SYNC_STATE_INTERVALE("wikitty.service.slave.sync.state.intervale", I18n._((String)"Intervale in second where slave service save state synchronisation time"), "300", Integer.class, false, false),
        WIKITTY_SLAVE_SYNC_STATE_FILE("wikitty.service.slave.sync.state.file", I18n._((String)"File path to store synchronisation state"), "${" + WIKITTY_DATA_DIR.getKey() + "}/syncState", String.class, false, false),
        WIKITTY_SLAVE_MASTER_URL("wikitty.service.slave.master.hessian.endpoint", I18n._((String)"Master url service, where to delegate modification action"), null, String.class, false, false),
        WIKITTY_SLAVE_MASTER_XMPP_SERVER("wikitty.service.slave.master.xmpp.server", I18n._((String)"XMPP server to use for synchronization with master"), "im.codelutin.com", String.class, false, false),
        WIKITTY_SLAVE_MASTER_XMPP_ROOM("wikitty.service.slave.master.xmpp.room", I18n._((String)"Room to use for synchronization with master, this room must have history activated"), "test@conference.im.codelutin.com", String.class, false, false),
        WIKITTY_PROXY_TIME_TO_LOG_INFO("wikitty.proxy.timeToLog.info", I18n._((String)"maximum time before send log info with time consumed"), "1000", Integer.class, false, false),
        WIKITTY_PROXY_TIME_TO_LOG_WARN("wikitty.proxy.timeToLog.warn", I18n._((String)"maximum time before send log warn with time consumed"), "3000", Integer.class, false, false),
        JCS_DEFAULT("jcs.default", I18n._((String)"jcs auxiliares to use"), "", String.class, false, false),
        JCS_DEFAULT_CACHEATTRIBUTES_MAXOBJECTS("jcs.default.cacheattributes.MaxObjects", I18n._((String)"jcs maximum number of items allowed in memory"), "1000", String.class, false, false);

        public String key;
        public String description;
        public String defaultValue;
        public Class<?> type;
        public boolean isTransient;
        public boolean isFinal;

        private WikittyOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isTransient = isTransient;
            this.isFinal = isFinal;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }
    }
}

