/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.converter;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.CountryEnum;
import org.nuiton.i18n.LanguageEnum;

public class LocaleConverter
implements Converter {
    private static final Pattern FULL_SCOPE_PATTERN = Pattern.compile("([a-zA-Z]{2})_([a-zA-Z]{2})");
    private static final Pattern MEDIUM_SCOPE_PATTERN = Pattern.compile("([a-zA-Z]{2})");
    static Log log = LogFactory.getLog(LocaleConverter.class);

    public Object convert(Class aClass, Object value) {
        if (value == null) {
            throw new ConversionException("can not convert null value in " + this + " convertor");
        }
        if (this.isEnabled(aClass)) {
            if (this.isEnabled(value.getClass())) {
                Object result = value;
                return result;
            }
            if (value instanceof String) {
                Locale result = this.valueOf(((String)value).trim());
                return result;
            }
        }
        throw new ConversionException("could not find a convertor for type " + aClass.getName() + " and value : " + value);
    }

    public Locale valueOf(String value) {
        try {
            Locale result = this.convertFullScope(value);
            if (result == null) {
                result = this.convertMediumScope(value);
            }
            if (result == null) {
                throw new ConversionException("could not convert locale " + value);
            }
            return result;
        }
        catch (Exception e) {
            throw new ConversionException("could not convert locale " + value + " for reason " + e.getMessage());
        }
    }

    private Locale convertFullScope(String value) {
        Matcher m = FULL_SCOPE_PATTERN.matcher(value);
        if (m.matches()) {
            LanguageEnum language = LanguageEnum.valueOf(m.group(1).toLowerCase());
            CountryEnum country = CountryEnum.valueOf(m.group(2).toUpperCase());
            if (language == null || country == null) {
                throw new ConversionException("could not convert locale " + value);
            }
            return new Locale(language.name(), country.name());
        }
        return null;
    }

    private Locale convertMediumScope(String value) {
        Matcher m = MEDIUM_SCOPE_PATTERN.matcher(value);
        if (m.matches()) {
            LanguageEnum language = LanguageEnum.valueOf(m.group(1).toLowerCase());
            if (language == null) {
                throw new ConversionException("could not convert locale " + value);
            }
            return new Locale(language.name());
        }
        return null;
    }

    public LocaleConverter() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
    }

    protected boolean isEnabled(Class<?> aClass) {
        return Locale.class.equals(aClass);
    }

    public Class<?> getType() {
        return Locale.class;
    }
}

