/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.FieldType;

public class SolrUtil {
    private static Log log = LogFactory.getLog(SolrUtil.class);

    public static SolrDocument findById(SolrServer solrServer, String id) {
        QueryResponse response;
        id = SolrUtil.quoteForSolr(id);
        SolrQuery query = new SolrQuery("#id:" + id);
        try {
            response = solrServer.query((SolrParams)query);
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Error during find", (Throwable)eee);
        }
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        if (numFound == 1L) {
            return (SolrDocument)results.get(0);
        }
        return null;
    }

    public static String getSolrFieldName(String fqfieldName, FieldType.TYPE type) {
        switch (type) {
            case BINARY: {
                return fqfieldName + "_bi";
            }
            case BOOLEAN: {
                return fqfieldName + "_b";
            }
            case DATE: {
                return fqfieldName + "_dt";
            }
            case STRING: {
                return fqfieldName + "_s";
            }
            case NUMERIC: {
                return fqfieldName + "_d";
            }
            case WIKITTY: {
                return fqfieldName + "_w";
            }
        }
        return fqfieldName;
    }

    public static SolrInputDocument copySolrDocument(SolrDocument source, boolean include, String ... fields) {
        SolrInputDocument result = new SolrInputDocument();
        Collection fieldNames = source.getFieldNames();
        HashSet<String> fieldToCopy = new HashSet<String>();
        if (include) {
            block0: for (String fieldName : fieldNames) {
                for (String fieldRegexp : fields) {
                    if (!fieldName.matches(fieldRegexp)) continue;
                    fieldToCopy.add(fieldName);
                    continue block0;
                }
            }
        } else {
            fieldToCopy.addAll(fieldNames);
            block2: for (String fieldName : fieldNames) {
                for (String fieldRegexp : fields) {
                    if (!fieldName.matches(fieldRegexp)) continue;
                    fieldToCopy.remove(fieldName);
                    continue block2;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copiable field are %s but only field %s are copied", fieldNames, fieldToCopy));
        }
        for (String fieldName : fieldToCopy) {
            Collection fieldValues = source.getFieldValues(fieldName);
            for (Object fieldValue : fieldValues) {
                result.addField(fieldName, fieldValue);
            }
        }
        return result;
    }

    public static String quoteForSolr(String s) {
        String result = s.replaceAll(":", "\\\\:");
        return result;
    }
}

