/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrResourceLoader;

public class CoreDescriptor {
    protected String name;
    protected String instanceDir;
    protected String dataDir;
    protected String configName;
    protected String propertiesName;
    protected String schemaName;
    private final CoreContainer coreContainer;
    private Properties coreProperties;

    public CoreDescriptor(CoreContainer coreContainer, String name, String instanceDir) {
        this.coreContainer = coreContainer;
        this.name = name;
        if (name == null) {
            throw new RuntimeException("Core needs a name");
        }
        if (instanceDir == null) {
            throw new NullPointerException("Missing required 'instanceDir'");
        }
        this.instanceDir = instanceDir = SolrResourceLoader.normalizeDir(instanceDir);
        this.configName = this.getDefaultConfigName();
        this.schemaName = this.getDefaultSchemaName();
    }

    public CoreDescriptor(CoreDescriptor descr) {
        this.instanceDir = descr.instanceDir;
        this.configName = descr.configName;
        this.schemaName = descr.schemaName;
        this.name = descr.name;
        this.dataDir = descr.dataDir;
        this.coreContainer = descr.coreContainer;
    }

    private Properties initImplicitProperties() {
        Properties implicitProperties = new Properties(this.coreContainer.getContainerProperties());
        implicitProperties.setProperty("solr.core.name", this.name);
        implicitProperties.setProperty("solr.core.instanceDir", this.instanceDir);
        implicitProperties.setProperty("solr.core.dataDir", this.getDataDir());
        implicitProperties.setProperty("solr.core.configName", this.configName);
        implicitProperties.setProperty("solr.core.schemaName", this.schemaName);
        return implicitProperties;
    }

    public String getDefaultConfigName() {
        return "solrconfig.xml";
    }

    public String getDefaultSchemaName() {
        return "schema.xml";
    }

    public String getDefaultDataDir() {
        return "data" + File.separator;
    }

    public String getPropertiesName() {
        return this.propertiesName;
    }

    public void setPropertiesName(String propertiesName) {
        this.propertiesName = propertiesName;
    }

    public String getDataDir() {
        String dataDir = this.dataDir;
        if (dataDir == null) {
            dataDir = this.getDefaultDataDir();
        }
        if (new File(dataDir).isAbsolute()) {
            return dataDir;
        }
        if (new File(this.instanceDir).isAbsolute()) {
            return SolrResourceLoader.normalizeDir(SolrResourceLoader.normalizeDir(this.instanceDir) + dataDir);
        }
        return SolrResourceLoader.normalizeDir(this.coreContainer.getSolrHome() + SolrResourceLoader.normalizeDir(this.instanceDir) + dataDir);
    }

    public void setDataDir(String s) {
        this.dataDir = s;
    }

    public String getInstanceDir() {
        return this.instanceDir;
    }

    public void setConfigName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        this.configName = name;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setSchemaName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        this.schemaName = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.name;
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    Properties getCoreProperties() {
        return this.coreProperties;
    }

    public void setCoreProperties(Properties coreProperties) {
        if (this.coreProperties == null) {
            Properties p = this.initImplicitProperties();
            this.coreProperties = new Properties(p);
            if (coreProperties != null) {
                this.coreProperties.putAll((Map<?, ?>)coreProperties);
            }
        }
    }
}

