/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class AnalyzeString
extends Instruction {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private Expression matching;
    private Expression nonMatching;
    private RegularExpression pattern;

    public AnalyzeString(Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, RegularExpression regularExpression) {
        this.select = expression;
        this.regex = expression2;
        this.flags = expression3;
        this.matching = expression4;
        this.nonMatching = expression5;
        this.pattern = regularExpression;
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression6 = (Expression)iterator.next();
            this.adoptChildExpression(expression6);
        }
    }

    public int getInstructionNameCode() {
        return 128;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public Expression getMatchingExpression() {
        return this.matching;
    }

    public Expression getNonMatchingExpression() {
        return this.nonMatching;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.regex = this.regex.simplify(staticContext);
        this.flags = this.flags.simplify(staticContext);
        if (this.matching != null) {
            this.matching = this.matching.simplify(staticContext);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.select);
        this.regex = this.regex.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.regex);
        this.flags = this.flags.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.flags);
        if (this.matching != null) {
            this.matching = this.matching.typeCheck(staticContext, Type.STRING_TYPE);
            this.adoptChildExpression(this.matching);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.typeCheck(staticContext, Type.STRING_TYPE);
            this.adoptChildExpression(this.nonMatching);
        }
        RoleLocator roleLocator = new RoleLocator(4, "analyze-string/select", 0, null);
        roleLocator.setSourceLocator(this);
        this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        roleLocator = new RoleLocator(4, "analyze-string/regex", 0, null);
        roleLocator.setSourceLocator(this);
        this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        roleLocator = new RoleLocator(4, "analyze-string/flags", 0, null);
        roleLocator.setSourceLocator(this);
        this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.select);
        this.regex = this.regex.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.regex);
        this.flags = this.flags.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.flags);
        if (this.matching != null) {
            this.matching = this.matching.optimize(optimizer, staticContext, Type.STRING_TYPE);
            this.adoptChildExpression(this.matching);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.optimize(optimizer, staticContext, Type.STRING_TYPE);
            this.adoptChildExpression(this.nonMatching);
        }
        return this;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (this.matching != null) {
            this.matching.checkPermittedContents(schemaType, staticContext, false);
        }
        if (this.nonMatching != null) {
            this.nonMatching.checkPermittedContents(schemaType, staticContext, false);
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.matching != null) {
            if (this.nonMatching != null) {
                return Type.getCommonSuperType(this.matching.getItemType(typeHierarchy), this.nonMatching.getItemType(typeHierarchy), typeHierarchy);
            }
            return this.matching.getItemType(typeHierarchy);
        }
        if (this.nonMatching != null) {
            return this.nonMatching.getItemType(typeHierarchy);
        }
        return NoNodeTest.getInstance();
    }

    public int computeDependencies() {
        int n = 0;
        n |= this.select.getDependencies();
        n |= this.regex.getDependencies();
        n |= this.flags.getDependencies();
        if (this.matching != null) {
            n |= this.matching.getDependencies() & 0xFFFFFFA1;
        }
        if (this.nonMatching != null) {
            n |= this.nonMatching.getDependencies() & 0xFFFFFFA1;
        }
        return n;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
        this.regex = this.doPromotion(this.regex, promotionOffer);
        this.flags = this.doPromotion(this.flags, promotionOffer);
        if (this.matching != null) {
            this.matching = this.doPromotion(this.matching, promotionOffer);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.doPromotion(this.nonMatching, promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(5);
        arrayList.add(this.select);
        arrayList.add(this.regex);
        arrayList.add(this.flags);
        if (this.matching != null) {
            arrayList.add(this.matching);
        }
        if (this.nonMatching != null) {
            arrayList.add(this.nonMatching);
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item;
        RegexIterator regexIterator = this.getRegexIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(regexIterator);
        xPathContextMajor.setCurrentRegexIterator(regexIterator);
        while ((item = regexIterator.next()) != null) {
            if (regexIterator.isMatching()) {
                if (this.matching == null) continue;
                this.matching.process(xPathContextMajor);
                continue;
            }
            if (this.nonMatching == null) continue;
            this.nonMatching.process(xPathContextMajor);
        }
        return null;
    }

    private RegexIterator getRegexIterator(XPathContext xPathContext) throws XPathException {
        Object object;
        String string = this.select.evaluateAsString(xPathContext);
        RegularExpression regularExpression = this.pattern;
        if (regularExpression == null) {
            object = this.flags.evaluateAsString(xPathContext);
            Platform platform = xPathContext.getConfiguration().getPlatform();
            regularExpression = platform.compileRegularExpression(this.regex.evaluateAsString(xPathContext), true, (CharSequence)object);
        }
        object = regularExpression.analyze(string);
        return object;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        RegexIterator regexIterator = this.getRegexIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(regexIterator);
        xPathContextMajor.setCurrentRegexIterator(regexIterator);
        AnalyzeMappingFunction analyzeMappingFunction = new AnalyzeMappingFunction(regexIterator, xPathContextMajor);
        return new MappingIterator(regexIterator, analyzeMappingFunction, xPathContextMajor);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "analyze-string");
        printStream.println(ExpressionTool.indent(n) + "select = ");
        this.select.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "regex = ");
        this.regex.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "flags = ");
        this.flags.display(n + 1, namePool, printStream);
        if (this.matching != null) {
            printStream.println(ExpressionTool.indent(n) + "matching = ");
            this.matching.display(n + 1, namePool, printStream);
        }
        if (this.nonMatching != null) {
            printStream.println(ExpressionTool.indent(n) + "non-matching = ");
            this.nonMatching.display(n + 1, namePool, printStream);
        }
    }

    private class AnalyzeMappingFunction
    implements MappingFunction {
        private RegexIterator base;
        private XPathContext c2;

        public AnalyzeMappingFunction(RegexIterator regexIterator, XPathContext xPathContext) {
            this.base = regexIterator;
            this.c2 = xPathContext;
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            if (this.base.isMatching()) {
                if (AnalyzeString.this.matching != null) {
                    return AnalyzeString.this.matching.iterate(this.c2);
                }
            } else if (AnalyzeString.this.nonMatching != null) {
                return AnalyzeString.this.nonMatching.iterate(this.c2);
            }
            return null;
        }
    }
}

