/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;

final class AttributeImpl
extends NodeImpl {
    private int nameCode;
    private int typeCode;
    private String value;

    public AttributeImpl(ElementImpl elementImpl, int n) {
        this.parent = elementImpl;
        this.index = n;
        AttributeCollection attributeCollection = elementImpl.getAttributeList();
        this.nameCode = attributeCollection.getNameCode(n);
        this.value = attributeCollection.getValue(n);
        this.typeCode = attributeCollection.getTypeAnnotation(n);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getTypeAnnotation() {
        return this.typeCode;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AttributeImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        AttributeImpl attributeImpl = (AttributeImpl)nodeInfo;
        return this.parent.isSameNodeInfo(attributeImpl.parent) && (this.nameCode & 0xFFFFF) == (attributeImpl.nameCode & 0xFFFFF);
    }

    public int hashCode() {
        return this.parent.hashCode() ^ this.getFingerprint();
    }

    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + 32768L + (long)this.index;
    }

    public final int getNodeKind() {
        return 2;
    }

    public String getStringValue() {
        return this.value;
    }

    public NodeInfo getNextSibling() {
        return null;
    }

    public NodeInfo getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (nodeImpl == this) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        this.getParent().generateId(fastStringBuffer);
        fastStringBuffer.append('a');
        fastStringBuffer.append(Integer.toString(this.index));
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        int n3 = this.getNameCode();
        int n4 = bl ? this.getTypeAnnotation() : -1;
        receiver.attribute(n3, n4, this.getStringValue(), n2, 0);
    }
}

