/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.init;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.init.I18nInitializer;

public class DefaultI18nInitializer
extends I18nInitializer {
    private static final Log log = LogFactory.getLog(DefaultI18nInitializer.class);
    public static String UNIQUE_BUNDLE_DEF = "%1$s-definition.properties";
    public static String UNIQUE_BUNDLE_ENTRY = "%1$s_%2$s.properties";
    public static String BUNDLE_DEF_LOCALES = "locales";
    public static String BUNDLE_DEF_VERSION = "version";
    public static String BUNDLES_FOR_LOCALE = "bundles.";
    protected final String bundleName;
    protected ClassLoader loader;
    protected String i18nPath;
    protected URL definitionURL;
    public static final String DEFAULT_I18N_PATH = "META-INF/";

    public DefaultI18nInitializer(String bundleName) throws NullPointerException {
        this(bundleName, null, null);
    }

    public DefaultI18nInitializer(String bundleName, ClassLoader loader) throws NullPointerException {
        this(bundleName, loader, null);
    }

    public DefaultI18nInitializer(String bundleName, ClassLoader loader, String i18nPath) throws NullPointerException {
        if (bundleName == null) {
            throw new NullPointerException("parameter 'bundleName' can not be null");
        }
        this.bundleName = bundleName;
        this.loader = loader == null ? this.getClass().getClassLoader() : loader;
        this.i18nPath = i18nPath == null ? DEFAULT_I18N_PATH : i18nPath;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getI18nPath() {
        return this.i18nPath;
    }

    protected void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected void setI18nPath(String i18nPath) {
        this.i18nPath = i18nPath;
    }

    protected URL getResourceURL(String resource) {
        if (log.isInfoEnabled()) {
            log.info((Object)("resource to seek : " + resource));
        }
        URL url = this.getLoader().getResource(resource);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolvDefinition(Properties p) throws Exception {
        String filename = String.format(UNIQUE_BUNDLE_DEF, this.getBundleName());
        URL url = this.getDefinitionURL();
        if (log.isInfoEnabled()) {
            log.info((Object)("definition file to seek : " + url));
        }
        InputStream stream = url.openStream();
        try {
            p.load(stream);
            stream.close();
        }
        finally {
            stream.close();
        }
        String prefix = url.toString();
        prefix = prefix.substring(0, prefix.length() - filename.length());
        return prefix;
    }

    public URL getDefinitionURL() throws NullPointerException {
        if (this.definitionURL == null) {
            String filename = String.format(UNIQUE_BUNDLE_DEF, this.getBundleName());
            String path = this.getI18nPath() + filename;
            this.definitionURL = this.getResourceURL(path);
            if (this.definitionURL == null) {
                throw new NullPointerException("could not find bundle definition file at " + path);
            }
        }
        return this.definitionURL;
    }

    public URL[] resolvURLs(String prefixURL, Properties definition) throws Exception {
        String localesAsStr = definition.getProperty(BUNDLE_DEF_LOCALES);
        Object[] locales = I18nUtil.parseLocales(localesAsStr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected locales : " + Arrays.toString(locales)));
        }
        ArrayList<URL> lUrls = new ArrayList<URL>(locales.length);
        String bundleName = this.getBundleName();
        for (Object l : locales) {
            String url = prefixURL + String.format(UNIQUE_BUNDLE_ENTRY, bundleName, l);
            if (log.isInfoEnabled()) {
                log.info((Object)("Detected resource for locale " + l + " : " + url));
            }
            URL u = new URL(url);
            lUrls.add(u);
        }
        URL[] urls = lUrls.toArray(new URL[lUrls.size()]);
        return urls;
    }

    @Override
    public I18nBundle[] resolvBundles() throws Exception {
        Properties definition = new Properties();
        String prefixURL = this.resolvDefinition(definition);
        URL[] urls = this.resolvURLs(prefixURL, definition);
        I18nBundle[] result = this.resolvBundles(urls);
        return result;
    }
}

