/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime;

import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.Catalog;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.SystemUtilities;

public class ScraperContext
extends Catalog {
    private ScraperContext callerContext = null;
    private SystemUtilities systemUtilities;

    public ScraperContext(Scraper scraper, ScraperContext callerContext) {
        this.callerContext = callerContext;
        this.systemUtilities = new SystemUtilities(scraper);
        this.put("sys", this.systemUtilities);
        this.put("http", scraper.getHttpClientManager().getHttpInfo());
    }

    public ScraperContext(Scraper scraper) {
        this(scraper, null);
    }

    public Variable getVar(String name) {
        Variable value = (Variable)this.get(name);
        if (value == null && this.callerContext != null && name.startsWith("caller.")) {
            return this.callerContext.getVar(name.substring(7));
        }
        return value;
    }

    public Object setVar(Object key, Object value) {
        Variable var = CommonUtil.createVariable(value);
        return super.put(key, var);
    }

    public ScraperContext getCallerContext() {
        return this.callerContext;
    }

    public void dispose() {
        this.systemUtilities.setScraper(null);
    }
}

