/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.nuiton.util.DateUtil;

public class PeriodDates {
    private String pattern;
    private Calendar fromCalendar;
    private Calendar thruCalendar;

    public PeriodDates() {
    }

    public PeriodDates(Date fromDate, Date thruDate) throws IllegalArgumentException {
        if (thruDate != null && fromDate != null && fromDate.after(thruDate)) {
            throw new IllegalArgumentException("The fromDate can't be after the thruDate !");
        }
        this.setFromDate(fromDate);
        this.setThruDate(thruDate);
        this.pattern = "dd/MM/yyyy";
    }

    public PeriodDates(Calendar fromCalendar, Calendar thruCalendar) throws IllegalArgumentException {
        if (thruCalendar != null && fromCalendar != null && fromCalendar.after(thruCalendar)) {
            throw new IllegalArgumentException("The fromDate can't be after the thruDate !");
        }
        this.fromCalendar = fromCalendar;
        this.thruCalendar = thruCalendar;
        this.pattern = "dd/MM/yyyy";
    }

    public static PeriodDates createMonthsPeriodFromToday(int monthAfter) {
        Calendar calendarFrom = Calendar.getInstance();
        Calendar calendarThru = Calendar.getInstance();
        Date minTime = DateUtil.setMinTimeOfDay(new Date());
        calendarFrom.setTime(minTime);
        calendarThru.setTime(minTime);
        if (monthAfter < 0) {
            calendarFrom.add(2, monthAfter);
        } else {
            calendarThru.add(2, monthAfter);
        }
        PeriodDates period = new PeriodDates(calendarFrom, calendarThru);
        period.initDayOfMonthExtremities();
        period.setPattern("MM/yyyy");
        return period;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void initDayOfMonthExtremities() {
        if (this.fromCalendar == null || this.thruCalendar == null) {
            throw new NullPointerException("fromDate or thruDate can't be null to change dayOfMonth extremities");
        }
        this.fromCalendar.set(5, 1);
        int maximum = this.thruCalendar.getActualMaximum(5);
        this.thruCalendar.set(5, maximum);
    }

    public void setFromDate(Date fromDate) {
        if (fromDate != null) {
            if (this.fromCalendar == null) {
                this.fromCalendar = Calendar.getInstance();
            }
            this.fromCalendar.setTime(fromDate);
        } else {
            this.fromCalendar = null;
        }
    }

    public Date getFromDate() {
        return this.fromCalendar != null ? this.fromCalendar.getTime() : null;
    }

    public int getFromMonth() {
        return this.fromCalendar.get(2);
    }

    public void setThruDate(Date thruDate) {
        if (thruDate != null) {
            if (this.thruCalendar == null) {
                this.thruCalendar = Calendar.getInstance();
            }
            this.thruCalendar.setTime(thruDate);
        } else {
            this.thruCalendar = null;
        }
    }

    public Date getThruDate() {
        return this.thruCalendar != null ? this.thruCalendar.getTime() : null;
    }

    public List<Date> getMonths() {
        ArrayList<Date> months = new ArrayList<Date>();
        if (this.fromCalendar == null || this.thruCalendar == null) {
            return months;
        }
        Date tmp = DateUtil.setFirstDayOfMonth(this.fromCalendar.getTime());
        tmp = DateUtil.setMinTimeOfDay(tmp);
        Calendar current = DateUtil.getDefaultCalendar(tmp);
        tmp = DateUtil.setFirstDayOfMonth(this.thruCalendar.getTime());
        tmp = DateUtil.setMinTimeOfDay(tmp);
        Calendar end = DateUtil.getDefaultCalendar(tmp);
        while (!current.equals(end)) {
            months.add(current.getTime());
            current.add(2, 1);
        }
        months.add(current.getTime());
        return months;
    }

    public List<String> getFormatedMonths() {
        ArrayList<String> results = new ArrayList<String>();
        for (Date date : this.getMonths()) {
            String str = DateUtil.formatDate(date, this.pattern);
            results.add(str);
        }
        return results;
    }

    public boolean beforeEnd(Calendar calendar) {
        return calendar.before(this.thruCalendar) || calendar.equals(this.thruCalendar);
    }

    public boolean afterEnd(Calendar calendar) {
        return calendar.after(this.thruCalendar);
    }

    public boolean afterBegin(Calendar calendar) {
        return calendar.after(this.fromCalendar) || calendar.equals(this.fromCalendar);
    }

    public boolean between(Calendar calendar) {
        return this.beforeEnd(calendar) && this.afterBegin(calendar);
    }

    public boolean beforeEnd(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        return this.beforeEnd(calendar);
    }

    public boolean afterEnd(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        return this.afterEnd(calendar);
    }

    public boolean afterBegin(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        return this.afterBegin(calendar);
    }

    public boolean between(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        return this.between(calendar);
    }

    public String toString() {
        String fromStr = DateUtil.formatDate(this.getFromDate(), this.pattern);
        String thruStr = DateUtil.formatDate(this.getThruDate(), this.pattern);
        return "[ " + this.getFromDate() + " (pattern: " + fromStr + ") -> " + this.getThruDate() + " (pattern: " + thruStr + ") ]";
    }
}

