/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.CapitalizationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapitalizationFilterFactory
extends BaseTokenFilterFactory {
    public static final int DEFAULT_MAX_WORD_COUNT = Integer.MAX_VALUE;
    public static final String KEEP = "keep";
    public static final String KEEP_IGNORE_CASE = "keepIgnoreCase";
    public static final String OK_PREFIX = "okPrefix";
    public static final String MIN_WORD_LENGTH = "minWordLength";
    public static final String MAX_WORD_COUNT = "maxWordCount";
    public static final String MAX_TOKEN_LENGTH = "maxTokenLength";
    public static final String ONLY_FIRST_WORD = "onlyFirstWord";
    public static final String FORCE_FIRST_LETTER = "forceFirstLetter";
    CharArraySet keep;
    Collection<char[]> okPrefix = Collections.emptyList();
    int minWordLength = 0;
    int maxWordCount = Integer.MAX_VALUE;
    int maxTokenLength = Integer.MAX_VALUE;
    boolean onlyFirstWord = true;
    boolean forceFirstLetter = true;

    @Override
    public void init(Map<String, String> args) {
        StringTokenizer st;
        super.init(args);
        String k = args.get(KEEP);
        if (k != null) {
            st = new StringTokenizer(k);
            boolean ignoreCase = false;
            String ignoreStr = args.get(KEEP_IGNORE_CASE);
            if ("true".equalsIgnoreCase(ignoreStr)) {
                ignoreCase = true;
            }
            this.keep = new CharArraySet(10, ignoreCase);
            while (st.hasMoreTokens()) {
                k = st.nextToken().trim();
                this.keep.add(k.toCharArray());
            }
        }
        if ((k = args.get(OK_PREFIX)) != null) {
            this.okPrefix = new ArrayList<char[]>();
            st = new StringTokenizer(k);
            while (st.hasMoreTokens()) {
                this.okPrefix.add(st.nextToken().trim().toCharArray());
            }
        }
        if ((k = args.get(MIN_WORD_LENGTH)) != null) {
            this.minWordLength = Integer.valueOf(k);
        }
        if ((k = args.get(MAX_WORD_COUNT)) != null) {
            this.maxWordCount = Integer.valueOf(k);
        }
        if ((k = args.get(MAX_TOKEN_LENGTH)) != null) {
            this.maxTokenLength = Integer.valueOf(k);
        }
        if ((k = args.get(ONLY_FIRST_WORD)) != null) {
            this.onlyFirstWord = Boolean.valueOf(k);
        }
        if ((k = args.get(FORCE_FIRST_LETTER)) != null) {
            this.forceFirstLetter = Boolean.valueOf(k);
        }
    }

    public void processWord(char[] buffer, int offset, int length, int wordCount) {
        if (length < 1) {
            return;
        }
        if (this.onlyFirstWord && wordCount > 0) {
            for (int i = 0; i < length; ++i) {
                buffer[offset + i] = Character.toLowerCase(buffer[offset + i]);
            }
            return;
        }
        if (this.keep != null && this.keep.contains(buffer, offset, length)) {
            if (wordCount == 0 && this.forceFirstLetter) {
                buffer[offset] = Character.toUpperCase(buffer[offset]);
            }
            return;
        }
        if (length < this.minWordLength) {
            return;
        }
        for (char[] prefix : this.okPrefix) {
            if (length < prefix.length) continue;
            boolean match = true;
            for (int i = 0; i < prefix.length; ++i) {
                if (prefix[i] == buffer[offset + i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return;
        }
        buffer[offset] = Character.toUpperCase(buffer[offset]);
        for (int i = 1; i < length; ++i) {
            buffer[offset + i] = Character.toLowerCase(buffer[offset + i]);
        }
    }

    public CapitalizationFilter create(TokenStream input) {
        return new CapitalizationFilter(input, this);
    }
}

