/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class UnboundFunctionLibrary
implements FunctionLibrary {
    private List unboundFunctionCalls = new ArrayList(20);
    private boolean resolving = false;

    public boolean isAvailable(int n, String string, String string2, int n2) {
        return false;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        if (this.resolving) {
            return null;
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFunctionNameCode(n);
        userFunctionCall.setArguments(expressionArray);
        this.unboundFunctionCalls.add(userFunctionCall);
        return userFunctionCall;
    }

    public void bindUnboundFunctionCalls(XQueryFunctionBinder xQueryFunctionBinder, Configuration configuration) throws XPathException {
        this.resolving = true;
        NamePool namePool = configuration.getNamePool();
        Iterator iterator = this.unboundFunctionCalls.iterator();
        while (iterator.hasNext()) {
            String string;
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            int n = userFunctionCall.getFunctionNameCode();
            int n2 = userFunctionCall.getNumberOfArguments();
            String string2 = namePool.getURI(n);
            XQueryFunction xQueryFunction = xQueryFunctionBinder.getDeclaration(n, string2, string = namePool.getLocalName(n), userFunctionCall.getArguments());
            if (xQueryFunction != null) {
                xQueryFunction.registerReference(userFunctionCall);
                userFunctionCall.setStaticType(xQueryFunction.getResultType());
                userFunctionCall.setConfirmed(true);
                continue;
            }
            String string3 = "Cannot find a matching " + n2 + "-argument function named " + namePool.getClarkName(n) + "()";
            if (!configuration.isAllowExternalFunctions()) {
                string3 = string3 + ". Note: external function calls have been disabled";
            }
            StaticError staticError = new StaticError(string3, ExpressionTool.getLocator(userFunctionCall));
            staticError.setErrorCode("XPST0017");
            throw staticError;
        }
    }

    public FunctionLibrary copy() {
        UnboundFunctionLibrary unboundFunctionLibrary = new UnboundFunctionLibrary();
        unboundFunctionLibrary.unboundFunctionCalls = new ArrayList(this.unboundFunctionCalls);
        return unboundFunctionLibrary;
    }
}

