/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: QueryHandler.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-services/src/main/java/com/jurismarches/vradi/services/search/QueryHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services.search;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;

/**
 * a <code>QueryHandler</code> is able to handle lucene queries.
 * 
 * @author $Author: tchemit $
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 0.0.4
 */
public interface QueryHandler {

    /**
     * handles a <code>TermQuery</code>.
     * 
     * @param termquery
     * @param booleanClause
     */
    void termQuery(TermQuery termquery, BooleanClause booleanClause);

    /**
     * handles a <code>PrefixQuery</code>.
     * 
     * @param prefixquery
     * @param booleanClause
     */
    void prefixQuery(PrefixQuery prefixquery, BooleanClause booleanClause);

    /**
     * handles a <code>WildcardQuery</code>.
     * 
     * @param wildcardquery
     * @param booleanClause
     */
    void wildcardQuery(WildcardQuery wildcardquery, BooleanClause booleanClause);

    /**
     * handles a <code>TermRangeQuery</code>.
     * 
     * @param rangequery
     * @param booleanClause
     */
    void rangeQuery(TermRangeQuery rangequery, BooleanClause booleanClause);

    /**
     * indicates the start of new group of queries.
     * 
     * @param booleanClause
     */
    void group(BooleanClause booleanClause);

    /**
     * indicates the end of the current group.
     */
    void ungroup();
}
