/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.ReadOnlyDirectoryReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Constants;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT;
    private long writeLockTimeout = WRITE_LOCK_TIMEOUT;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DISABLE_AUTO_FLUSH = -1;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = -1;
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = -1;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    public static final int MAX_TERM_LENGTH = 16383;
    public static final double DEFAULT_MAX_SYNC_PAUSE_SECONDS;
    private static final int MERGE_READ_BUFFER_SIZE = 4096;
    private static Object MESSAGE_ID_LOCK;
    private static int MESSAGE_ID;
    private int messageID = -1;
    private volatile boolean hitOOM;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private volatile long changeCount;
    private long lastCommitChangeCount;
    private SegmentInfos rollbackSegmentInfos;
    private HashMap rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    private SegmentInfos localRollbackSegmentInfos;
    private boolean localAutoCommit;
    private int localFlushedDocCount;
    private boolean autoCommit = true;
    private SegmentInfos segmentInfos = new SegmentInfos();
    private DocumentsWriter docWriter;
    private IndexFileDeleter deleter;
    private Set segmentsToOptimize = new HashSet();
    private Lock writeLock;
    private int termIndexInterval = 128;
    private boolean closeDir;
    private boolean closed;
    private boolean closing;
    private HashSet mergingSegments = new HashSet();
    private MergePolicy mergePolicy = new LogByteSizeMergePolicy(this);
    private MergeScheduler mergeScheduler = new ConcurrentMergeScheduler();
    private LinkedList pendingMerges = new LinkedList();
    private Set runningMerges = new HashSet();
    private List mergeExceptions = new ArrayList();
    private long mergeGen;
    private boolean stopMerges;
    private int flushCount;
    private int flushDeletesCount;
    private double maxSyncPauseSeconds = DEFAULT_MAX_SYNC_PAUSE_SECONDS;
    private int readCount;
    private Thread writeThread;
    final ReaderPool readerPool = new ReaderPool();
    private int upgradeCount;
    private int readerTermsIndexDivisor = IndexReader.DEFAULT_TERMS_INDEX_DIVISOR;
    private volatile boolean poolReaders;
    private int maxFieldLength;
    private PrintStream infoStream = null;
    private static PrintStream defaultInfoStream;
    private final Object commitLock = new Object();
    private HashSet synced = new HashSet();
    private HashSet syncing = new HashSet();
    private IndexReaderWarmer mergedSegmentWarmer;
    private boolean allowMinus1Position;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexReader getReader() throws IOException {
        return this.getReader(this.readerTermsIndexDivisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getReader(int termInfosIndexDivisor) throws IOException {
        this.ensureOpen();
        if (this.infoStream != null) {
            this.message("flush at getReader");
        }
        this.poolReaders = true;
        this.flush(true, true, false);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.applyDeletes();
            return new ReadOnlyDirectoryReader(this, this.segmentInfos, termInfosIndexDivisor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numDeletedDocs(SegmentInfo info) throws IOException {
        int n;
        block5: {
            SegmentReader reader;
            block3: {
                int n2;
                block4: {
                    reader = this.readerPool.getIfExists(info);
                    try {
                        if (reader == null) break block3;
                        n2 = reader.numDeletedDocs();
                        Object var5_5 = null;
                        if (reader == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var5_7 = null;
                            if (reader == null) break block6;
                            this.readerPool.release(reader);
                        }
                        throw throwable;
                    }
                    this.readerPool.release(reader);
                }
                return n2;
            }
            n = info.getDelCount();
            Object var5_6 = null;
            if (reader == null) break block5;
            this.readerPool.release(reader);
        }
        return n;
    }

    synchronized void acquireWrite() {
        if (!$assertionsDisabled && this.writeThread == Thread.currentThread()) {
            throw new AssertionError();
        }
        while (this.writeThread != null || this.readCount > 0) {
            this.doWait();
        }
        this.ensureOpen();
        this.writeThread = Thread.currentThread();
    }

    synchronized void releaseWrite() {
        if (!$assertionsDisabled && Thread.currentThread() != this.writeThread) {
            throw new AssertionError();
        }
        this.writeThread = null;
        this.notifyAll();
    }

    synchronized void acquireRead() {
        Thread current = Thread.currentThread();
        while (this.writeThread != null && this.writeThread != current) {
            this.doWait();
        }
        ++this.readCount;
    }

    synchronized void upgradeReadToWrite() {
        if (!$assertionsDisabled && this.readCount <= 0) {
            throw new AssertionError();
        }
        ++this.upgradeCount;
        while (this.readCount > this.upgradeCount || this.writeThread != null) {
            this.doWait();
        }
        this.writeThread = Thread.currentThread();
        --this.readCount;
        --this.upgradeCount;
    }

    synchronized void releaseRead() {
        --this.readCount;
        if (!$assertionsDisabled && this.readCount < 0) {
            throw new AssertionError();
        }
        this.notifyAll();
    }

    final synchronized boolean isOpen(boolean includePendingClose) {
        return !this.closed && (!includePendingClose || !this.closing);
    }

    protected final synchronized void ensureOpen(boolean includePendingClose) throws AlreadyClosedException {
        if (!this.isOpen(includePendingClose)) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    protected final synchronized void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    public void message(String message) {
        if (this.infoStream != null) {
            this.infoStream.println("IW " + this.messageID + " [" + Thread.currentThread().getName() + "]: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setMessageID(PrintStream infoStream) {
        if (infoStream != null && this.messageID == -1) {
            Object object = MESSAGE_ID_LOCK;
            synchronized (object) {
                this.messageID = MESSAGE_ID++;
            }
        }
        this.infoStream = infoStream;
    }

    private LogMergePolicy getLogMergePolicy() {
        if (this.mergePolicy instanceof LogMergePolicy) {
            return (LogMergePolicy)this.mergePolicy;
        }
        throw new IllegalArgumentException("this method can only be called when the merge policy is the default LogMergePolicy");
    }

    public boolean getUseCompoundFile() {
        return this.getLogMergePolicy().getUseCompoundFile();
    }

    public void setUseCompoundFile(boolean value) {
        this.getLogMergePolicy().setUseCompoundFile(value);
        this.getLogMergePolicy().setUseCompoundDocStore(value);
    }

    public void setSimilarity(Similarity similarity) {
        this.ensureOpen();
        this.similarity = similarity;
        this.docWriter.setSimilarity(similarity);
    }

    public Similarity getSimilarity() {
        this.ensureOpen();
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.ensureOpen();
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        this.ensureOpen(false);
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true, 10000, null, null);
    }

    public IndexWriter(File path, Analyzer a, boolean create, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true, 10000, null, null);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, true, 10000, null, null);
    }

    public IndexWriter(String path, Analyzer a, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(String path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true, 10000, null, null);
    }

    public IndexWriter(File path, Analyzer a, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(File path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true, 10000, null, null);
    }

    public IndexWriter(Directory d, Analyzer a, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(Directory d, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, true, 10000, null, null);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, autoCommit, 10000, null, null);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, autoCommit, 10000, null, null);
    }

    public IndexWriter(Directory d, Analyzer a, IndexDeletionPolicy deletionPolicy, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, deletionPolicy, false, mfl.getLimit(), null, null);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, deletionPolicy, autoCommit, 10000, null, null);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy, MaxFieldLength mfl) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, false, mfl.getLimit(), null, null);
    }

    IndexWriter(Directory d, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy, MaxFieldLength mfl, DocumentsWriter.IndexingChain indexingChain, IndexCommit commit) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, false, mfl.getLimit(), indexingChain, commit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, autoCommit, 10000, null, null);
    }

    public IndexWriter(Directory d, Analyzer a, IndexDeletionPolicy deletionPolicy, MaxFieldLength mfl, IndexCommit commit) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, false, deletionPolicy, false, mfl.getLimit(), null, commit);
    }

    private void init(Directory d, Analyzer a, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit, int maxFieldLength, DocumentsWriter.IndexingChain indexingChain, IndexCommit commit) throws CorruptIndexException, LockObtainFailedException, IOException {
        if (IndexReader.indexExists(d)) {
            this.init(d, a, false, closeDir, deletionPolicy, autoCommit, maxFieldLength, indexingChain, commit);
        } else {
            this.init(d, a, true, closeDir, deletionPolicy, autoCommit, maxFieldLength, indexingChain, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Directory d, Analyzer a, boolean create, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit, int maxFieldLength, DocumentsWriter.IndexingChain indexingChain, IndexCommit commit) throws CorruptIndexException, LockObtainFailedException, IOException {
        block21: {
            Lock writeLock;
            block22: {
                this.closeDir = closeDir;
                this.directory = d;
                this.analyzer = a;
                this.setMessageID(defaultInfoStream);
                this.maxFieldLength = maxFieldLength;
                if (indexingChain == null) {
                    indexingChain = DocumentsWriter.DefaultIndexingChain;
                }
                if (create) {
                    this.directory.clearLock(WRITE_LOCK_NAME);
                }
                if (!(writeLock = this.directory.makeLock(WRITE_LOCK_NAME)).obtain(this.writeLockTimeout)) {
                    throw new LockObtainFailedException("Index locked for write: " + writeLock);
                }
                this.writeLock = writeLock;
                boolean success = false;
                try {
                    if (create) {
                        boolean doCommit;
                        try {
                            this.segmentInfos.read(this.directory);
                            this.segmentInfos.clear();
                            doCommit = false;
                        }
                        catch (IOException e) {
                            doCommit = true;
                        }
                        if (autoCommit || doCommit) {
                            this.segmentInfos.commit(this.directory);
                            this.synced.addAll(this.segmentInfos.files(this.directory, true));
                        } else {
                            ++this.changeCount;
                        }
                    } else {
                        this.segmentInfos.read(this.directory);
                        if (commit != null) {
                            if (commit.getDirectory() != this.directory) {
                                throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory");
                            }
                            SegmentInfos oldInfos = new SegmentInfos();
                            oldInfos.read(this.directory, commit.getSegmentsFileName());
                            this.segmentInfos.replace(oldInfos);
                            ++this.changeCount;
                            if (this.infoStream != null) {
                                this.message("init: loaded commit \"" + commit.getSegmentsFileName() + "\"");
                            }
                        }
                        this.synced.addAll(this.segmentInfos.files(this.directory, true));
                    }
                    this.autoCommit = autoCommit;
                    this.setRollbackSegmentInfos(this.segmentInfos);
                    this.docWriter = new DocumentsWriter(this.directory, this, indexingChain);
                    this.docWriter.setInfoStream(this.infoStream);
                    this.docWriter.setMaxFieldLength(maxFieldLength);
                    this.deleter = new IndexFileDeleter(this.directory, deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : deletionPolicy, this.segmentInfos, this.infoStream, this.docWriter);
                    if (this.deleter.startingCommitDeleted) {
                        ++this.changeCount;
                    }
                    this.pushMaxBufferedDocs();
                    if (this.infoStream != null) {
                        this.message("init: create=" + create);
                        this.messageState();
                    }
                    success = true;
                    Object var15_15 = null;
                    if (success) break block21;
                    if (this.infoStream == null) break block22;
                    this.message("init: hit exception on init; releasing write lock");
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("init: hit exception on init; releasing write lock");
                        }
                        try {
                            writeLock.release();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        writeLock = null;
                    }
                    throw throwable;
                }
            }
            try {
                writeLock.release();
            }
            catch (Throwable t) {
                // empty catch block
            }
            writeLock = null;
            {
            }
        }
    }

    private synchronized void setRollbackSegmentInfos(SegmentInfos infos) {
        this.rollbackSegmentInfos = (SegmentInfos)infos.clone();
        if (!$assertionsDisabled && this.rollbackSegmentInfos.hasExternalSegments(this.directory)) {
            throw new AssertionError();
        }
        this.rollbackSegments = new HashMap();
        int size = this.rollbackSegmentInfos.size();
        for (int i = 0; i < size; ++i) {
            this.rollbackSegments.put(this.rollbackSegmentInfos.info(i), new Integer(i));
        }
    }

    public void setMergePolicy(MergePolicy mp) {
        this.ensureOpen();
        if (mp == null) {
            throw new NullPointerException("MergePolicy must be non-null");
        }
        if (this.mergePolicy != mp) {
            this.mergePolicy.close();
        }
        this.mergePolicy = mp;
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMergePolicy " + mp);
        }
    }

    public MergePolicy getMergePolicy() {
        this.ensureOpen();
        return this.mergePolicy;
    }

    public synchronized void setMergeScheduler(MergeScheduler mergeScheduler) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (mergeScheduler == null) {
            throw new NullPointerException("MergeScheduler must be non-null");
        }
        if (this.mergeScheduler != mergeScheduler) {
            this.finishMerges(true);
            this.mergeScheduler.close();
        }
        this.mergeScheduler = mergeScheduler;
        if (this.infoStream != null) {
            this.message("setMergeScheduler " + mergeScheduler);
        }
    }

    public MergeScheduler getMergeScheduler() {
        this.ensureOpen();
        return this.mergeScheduler;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.getLogMergePolicy().setMaxMergeDocs(maxMergeDocs);
    }

    public int getMaxMergeDocs() {
        return this.getLogMergePolicy().getMaxMergeDocs();
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.ensureOpen();
        this.maxFieldLength = maxFieldLength;
        this.docWriter.setMaxFieldLength(maxFieldLength);
        if (this.infoStream != null) {
            this.message("setMaxFieldLength " + maxFieldLength);
        }
    }

    public int getMaxFieldLength() {
        this.ensureOpen();
        return this.maxFieldLength;
    }

    public void setReaderTermsIndexDivisor(int divisor) {
        this.ensureOpen();
        if (divisor <= 0) {
            throw new IllegalArgumentException("divisor must be >= 1 (got " + divisor + ")");
        }
        this.readerTermsIndexDivisor = divisor;
        if (this.infoStream != null) {
            this.message("setReaderTermsIndexDivisor " + this.readerTermsIndexDivisor);
        }
    }

    public int getReaderTermsIndexDivisor() {
        this.ensureOpen();
        return this.readerTermsIndexDivisor;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.ensureOpen();
        if (maxBufferedDocs != -1 && maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2 when enabled");
        }
        if (maxBufferedDocs == -1 && this.getRAMBufferSizeMB() == -1.0) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.docWriter.setMaxBufferedDocs(maxBufferedDocs);
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMaxBufferedDocs " + maxBufferedDocs);
        }
    }

    private void pushMaxBufferedDocs() {
        MergePolicy mp;
        if (this.docWriter.getMaxBufferedDocs() != -1 && (mp = this.mergePolicy) instanceof LogDocMergePolicy) {
            LogDocMergePolicy lmp = (LogDocMergePolicy)mp;
            int maxBufferedDocs = this.docWriter.getMaxBufferedDocs();
            if (lmp.getMinMergeDocs() != maxBufferedDocs) {
                if (this.infoStream != null) {
                    this.message("now push maxBufferedDocs " + maxBufferedDocs + " to LogDocMergePolicy");
                }
                lmp.setMinMergeDocs(maxBufferedDocs);
            }
        }
    }

    public int getMaxBufferedDocs() {
        this.ensureOpen();
        return this.docWriter.getMaxBufferedDocs();
    }

    public void setRAMBufferSizeMB(double mb) {
        if (mb > 2048.0) {
            throw new IllegalArgumentException("ramBufferSize " + mb + " is too large; should be comfortably less than 2048");
        }
        if (mb != -1.0 && mb <= 0.0) {
            throw new IllegalArgumentException("ramBufferSize should be > 0.0 MB when enabled");
        }
        if (mb == -1.0 && this.getMaxBufferedDocs() == -1) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.docWriter.setRAMBufferSizeMB(mb);
        if (this.infoStream != null) {
            this.message("setRAMBufferSizeMB " + mb);
        }
    }

    public double getRAMBufferSizeMB() {
        return this.docWriter.getRAMBufferSizeMB();
    }

    public void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.ensureOpen();
        if (maxBufferedDeleteTerms != -1 && maxBufferedDeleteTerms < 1) {
            throw new IllegalArgumentException("maxBufferedDeleteTerms must at least be 1 when enabled");
        }
        this.docWriter.setMaxBufferedDeleteTerms(maxBufferedDeleteTerms);
        if (this.infoStream != null) {
            this.message("setMaxBufferedDeleteTerms " + maxBufferedDeleteTerms);
        }
    }

    public int getMaxBufferedDeleteTerms() {
        this.ensureOpen();
        return this.docWriter.getMaxBufferedDeleteTerms();
    }

    public void setMergeFactor(int mergeFactor) {
        this.getLogMergePolicy().setMergeFactor(mergeFactor);
    }

    public int getMergeFactor() {
        return this.getLogMergePolicy().getMergeFactor();
    }

    public double getMaxSyncPauseSeconds() {
        return this.maxSyncPauseSeconds;
    }

    public void setMaxSyncPauseSeconds(double seconds) {
        this.maxSyncPauseSeconds = seconds;
    }

    public static void setDefaultInfoStream(PrintStream infoStream) {
        defaultInfoStream = infoStream;
    }

    public static PrintStream getDefaultInfoStream() {
        return defaultInfoStream;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.ensureOpen();
        this.setMessageID(infoStream);
        this.docWriter.setInfoStream(infoStream);
        this.deleter.setInfoStream(infoStream);
        if (infoStream != null) {
            this.messageState();
        }
    }

    private void messageState() {
        this.message("setInfoStream: dir=" + this.directory + " autoCommit=" + this.autoCommit + " mergePolicy=" + this.mergePolicy + " mergeScheduler=" + this.mergeScheduler + " ramBufferSizeMB=" + this.docWriter.getRAMBufferSizeMB() + " maxBufferedDocs=" + this.docWriter.getMaxBufferedDocs() + " maxBuffereDeleteTerms=" + this.docWriter.getMaxBufferedDeleteTerms() + " maxFieldLength=" + this.maxFieldLength + " index=" + this.segString());
    }

    public PrintStream getInfoStream() {
        this.ensureOpen();
        return this.infoStream;
    }

    public boolean verbose() {
        return this.infoStream != null;
    }

    public void setWriteLockTimeout(long writeLockTimeout) {
        this.ensureOpen();
        this.writeLockTimeout = writeLockTimeout;
    }

    public long getWriteLockTimeout() {
        this.ensureOpen();
        return this.writeLockTimeout;
    }

    public static void setDefaultWriteLockTimeout(long writeLockTimeout) {
        WRITE_LOCK_TIMEOUT = writeLockTimeout;
    }

    public static long getDefaultWriteLockTimeout() {
        return WRITE_LOCK_TIMEOUT;
    }

    public void close() throws CorruptIndexException, IOException {
        this.close(true);
    }

    public void close(boolean waitForMerges) throws CorruptIndexException, IOException {
        if (this.shouldClose()) {
            if (this.hitOOM) {
                this.rollbackInternal();
            } else {
                this.closeInternal(waitForMerges);
            }
        }
    }

    private synchronized boolean shouldClose() {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            this.doWait();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeInternal(boolean waitForMerges) throws CorruptIndexException, IOException {
        this.docWriter.pauseAllThreads();
        try {
            try {
                if (this.infoStream != null) {
                    this.message("now flush at close");
                }
                this.docWriter.close();
                if (!this.hitOOM) {
                    this.flush(waitForMerges, true, true);
                }
                if (waitForMerges) {
                    this.mergeScheduler.merge(this);
                }
                this.mergePolicy.close();
                this.finishMerges(waitForMerges);
                this.stopMerges = true;
                this.mergeScheduler.close();
                if (this.infoStream != null) {
                    this.message("now call final commit()");
                }
                if (!this.hitOOM) {
                    this.commit(0L);
                }
                if (this.infoStream != null) {
                    this.message("at close: " + this.segString());
                }
                IndexWriter indexWriter2 = this;
                // MONITORENTER : indexWriter2
                this.readerPool.close();
                this.docWriter = null;
                this.deleter.close();
                // MONITOREXIT : indexWriter2
                if (this.closeDir) {
                    this.directory.close();
                }
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
                indexWriter2 = this;
                // MONITORENTER : indexWriter2
                this.closed = true;
                // MONITOREXIT : indexWriter2
            }
            catch (OutOfMemoryError oom) {
                this.handleOOM(oom, "closeInternal");
                Object var6_5 = null;
                IndexWriter indexWriter = this;
                // MONITORENTER : indexWriter
                this.closing = false;
                this.notifyAll();
                if (!this.closed) {
                    if (this.docWriter != null) {
                        this.docWriter.resumeAllThreads();
                    }
                    if (this.infoStream != null) {
                        this.message("hit exception while closing");
                    }
                }
                // MONITOREXIT : indexWriter
                return;
            }
            Object var6_4 = null;
            IndexWriter indexWriter = this;
            // MONITORENTER : indexWriter
            this.closing = false;
            this.notifyAll();
            if (!this.closed) {
                if (this.docWriter != null) {
                    this.docWriter.resumeAllThreads();
                }
                if (this.infoStream != null) {
                    this.message("hit exception while closing");
                }
            }
            // MONITOREXIT : indexWriter
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IndexWriter indexWriter = this;
            // MONITORENTER : indexWriter
            this.closing = false;
            this.notifyAll();
            if (!this.closed) {
                if (this.docWriter != null) {
                    this.docWriter.resumeAllThreads();
                }
                if (this.infoStream != null) {
                    this.message("hit exception while closing");
                }
            }
            // MONITOREXIT : indexWriter
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean flushDocStores() throws IOException {
        String docStoreSegment;
        boolean useCompoundDocStore = false;
        boolean success = false;
        try {
            docStoreSegment = this.docWriter.closeDocStore();
            success = true;
            Object var5_4 = null;
            if (!success && this.infoStream != null) {
                this.message("hit exception closing doc store segment");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!success && this.infoStream != null) {
                this.message("hit exception closing doc store segment");
            }
            throw throwable;
        }
        useCompoundDocStore = this.mergePolicy.useCompoundDocStore(this.segmentInfos);
        if (useCompoundDocStore && docStoreSegment != null && this.docWriter.closedFiles().size() != 0) {
            int numSegments;
            block12: {
                String compoundFileName;
                block13: {
                    if (this.infoStream != null) {
                        this.message("create compound file " + docStoreSegment + "." + "cfx");
                    }
                    success = false;
                    numSegments = this.segmentInfos.size();
                    compoundFileName = docStoreSegment + "." + "cfx";
                    try {
                        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, compoundFileName);
                        Iterator it = this.docWriter.closedFiles().iterator();
                        while (it.hasNext()) {
                            cfsWriter.addFile((String)it.next());
                        }
                        cfsWriter.close();
                        success = true;
                        Object var9_11 = null;
                        if (success) break block12;
                        if (this.infoStream == null) break block13;
                        this.message("hit exception building compound file doc store for segment " + docStoreSegment);
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception building compound file doc store for segment " + docStoreSegment);
                            }
                            this.deleter.deleteFile(compoundFileName);
                        }
                        throw throwable;
                    }
                }
                this.deleter.deleteFile(compoundFileName);
                {
                }
            }
            for (int i = 0; i < numSegments; ++i) {
                SegmentInfo si = this.segmentInfos.info(i);
                if (si.getDocStoreOffset() == -1 || !si.getDocStoreSegment().equals(docStoreSegment)) continue;
                si.setDocStoreIsCompoundFile(true);
            }
            this.checkpoint();
            this.deleter.deleteNewFiles(this.docWriter.closedFiles());
        }
        return useCompoundDocStore;
    }

    public Directory getDirectory() {
        this.ensureOpen(false);
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int docCount() {
        this.ensureOpen();
        return this.maxDoc();
    }

    public synchronized int maxDoc() {
        int count = this.docWriter != null ? this.docWriter.getNumDocsInRAM() : 0;
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            count += this.segmentInfos.info((int)i).docCount;
        }
        return count;
    }

    public synchronized int numDocs() throws IOException {
        int count = this.docWriter != null ? this.docWriter.getNumDocsInRAM() : 0;
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo info = this.segmentInfos.info(i);
            count += info.docCount - info.getDelCount();
        }
        return count;
    }

    public synchronized boolean hasDeletions() throws IOException {
        this.ensureOpen();
        if (this.docWriter.hasDeletes()) {
            return true;
        }
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            if (!this.segmentInfos.info(i).hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public void addDocument(Document doc) throws CorruptIndexException, IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = false;
        boolean success = false;
        try {
            block15: {
                IndexWriter indexWriter;
                try {
                    doFlush = this.docWriter.addDocument(doc, analyzer);
                    success = true;
                    Object var6_5 = null;
                    if (success) break block15;
                    if (this.infoStream != null) {
                        this.message("hit exception adding document");
                    }
                    indexWriter = this;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception adding document");
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            Collection files;
                            if (this.docWriter != null && (files = this.docWriter.abortedFiles()) != null) {
                                this.deleter.deleteNewFiles(files);
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter) {
                    Collection files;
                    if (this.docWriter != null && (files = this.docWriter.abortedFiles()) != null) {
                        this.deleter.deleteNewFiles(files);
                    }
                }
            }
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.handleOOM(oom, "addDocument");
        }
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = this.docWriter.bufferDeleteTerm(term);
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.handleOOM(oom, "deleteDocuments(Term)");
        }
    }

    public void deleteDocuments(Term[] terms) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = this.docWriter.bufferDeleteTerms(terms);
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.handleOOM(oom, "deleteDocuments(Term[])");
        }
    }

    public void deleteDocuments(Query query) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = this.docWriter.bufferDeleteQuery(query);
        if (doFlush) {
            this.flush(true, false, false);
        }
    }

    public void deleteDocuments(Query[] queries) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = this.docWriter.bufferDeleteQueries(queries);
        if (doFlush) {
            this.flush(true, false, false);
        }
    }

    public void updateDocument(Term term, Document doc) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.updateDocument(term, doc, this.getAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush;
            block15: {
                IndexWriter indexWriter;
                doFlush = false;
                boolean success = false;
                try {
                    doFlush = this.docWriter.updateDocument(term, doc, analyzer);
                    success = true;
                    Object var7_7 = null;
                    if (success) break block15;
                    if (this.infoStream != null) {
                        this.message("hit exception updating document");
                    }
                    indexWriter = this;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception updating document");
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            Collection files = this.docWriter.abortedFiles();
                            if (files != null) {
                                this.deleter.deleteNewFiles(files);
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter) {
                    Collection files = this.docWriter.abortedFiles();
                    if (files != null) {
                        this.deleter.deleteNewFiles(files);
                    }
                }
            }
            if (doFlush) {
                this.flush(true, false, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.handleOOM(oom, "updateDocument");
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocsInRAM();
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).docCount;
        }
        return -1;
    }

    final synchronized int getFlushCount() {
        return this.flushCount;
    }

    final synchronized int getFlushDeletesCount() {
        return this.flushDeletesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            ++this.changeCount;
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void optimize() throws CorruptIndexException, IOException {
        this.optimize(true);
    }

    public void optimize(int maxNumSegments) throws CorruptIndexException, IOException {
        this.optimize(maxNumSegments, true);
    }

    public void optimize(boolean doWait) throws CorruptIndexException, IOException {
        this.optimize(1, doWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(int maxNumSegments, boolean doWait) throws CorruptIndexException, IOException {
        MergePolicy.OneMerge merge;
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream != null) {
            this.message("optimize: index now " + this.segString());
        }
        this.flush(true, false, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToOptimize = new HashSet();
            int numSegments = this.segmentInfos.size();
            for (int i = 0; i < numSegments; ++i) {
                this.segmentsToOptimize.add(this.segmentInfos.info(i));
            }
            Iterator it = this.pendingMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                merge.optimize = true;
                merge.maxNumSegmentsOptimize = maxNumSegments;
            }
            it = this.runningMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                merge.optimize = true;
                merge.maxNumSegmentsOptimize = maxNumSegments;
            }
        }
        this.maybeMerge(maxNumSegments, true);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.hitOOM) {
                        throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot complete optimize");
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int size = this.mergeExceptions.size();
                        for (int i = 0; i < size; ++i) {
                            merge = (MergePolicy.OneMerge)this.mergeExceptions.get(0);
                            if (!merge.optimize) continue;
                            IOException err = new IOException("background merge hit exception: " + merge.segString(this.directory));
                            Throwable t = merge.getException();
                            if (t != null) {
                                err.initCause(t);
                            }
                            throw err;
                        }
                    }
                    if (!this.optimizeMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean optimizeMergesPending() {
        Iterator it = this.pendingMerges.iterator();
        while (it.hasNext()) {
            if (!((MergePolicy.OneMerge)it.next()).optimize) continue;
            return true;
        }
        it = this.runningMerges.iterator();
        while (it.hasNext()) {
            if (!((MergePolicy.OneMerge)it.next()).optimize) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expungeDeletes(boolean doWait) throws CorruptIndexException, IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        if (this.infoStream != null) {
            this.message("expungeDeletes: index now " + this.segString());
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = this.mergePolicy.findMergesToExpungeDeletes(this.segmentInfos);
            if (spec != null) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge((MergePolicy.OneMerge)spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    if (this.hitOOM) {
                        throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot complete expungeDeletes");
                    }
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge = (MergePolicy.OneMerge)spec.merges.get(i);
                        if (this.pendingMerges.contains(merge) || this.runningMerges.contains(merge)) {
                            running = true;
                        }
                        if ((t = merge.getException()) == null) continue;
                        IOException ioe = new IOException("background merge hit exception: " + merge.segString(this.directory));
                        ioe.initCause(t);
                        throw ioe;
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void expungeDeletes() throws CorruptIndexException, IOException {
        this.expungeDeletes(true);
    }

    public final void maybeMerge() throws CorruptIndexException, IOException {
        this.maybeMerge(false);
    }

    private final void maybeMerge(boolean optimize) throws CorruptIndexException, IOException {
        this.maybeMerge(1, optimize);
    }

    private final void maybeMerge(int maxNumSegmentsOptimize, boolean optimize) throws CorruptIndexException, IOException {
        this.updatePendingMerges(maxNumSegmentsOptimize, optimize);
        this.mergeScheduler.merge(this);
    }

    private synchronized void updatePendingMerges(int maxNumSegmentsOptimize, boolean optimize) throws CorruptIndexException, IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        if (!$assertionsDisabled && optimize && maxNumSegmentsOptimize <= 0) {
            throw new AssertionError();
        }
        if (this.stopMerges) {
            return;
        }
        if (this.hitOOM) {
            return;
        }
        if (optimize) {
            spec = this.mergePolicy.findMergesForOptimize(this.segmentInfos, maxNumSegmentsOptimize, this.segmentsToOptimize);
            if (spec != null) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = (MergePolicy.OneMerge)spec.merges.get(i);
                    merge.optimize = true;
                    merge.maxNumSegmentsOptimize = maxNumSegmentsOptimize;
                }
            }
        } else {
            spec = this.mergePolicy.findMerges(this.segmentInfos);
        }
        if (spec != null) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge((MergePolicy.OneMerge)spec.merges.get(i));
            }
        }
    }

    synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = (MergePolicy.OneMerge)this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    private synchronized MergePolicy.OneMerge getNextExternalMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        Iterator it = this.pendingMerges.iterator();
        while (it.hasNext()) {
            MergePolicy.OneMerge merge = (MergePolicy.OneMerge)it.next();
            if (!merge.isExternal) continue;
            it.remove();
            this.runningMerges.add(merge);
            return merge;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startTransaction(boolean haveReadLock) throws IOException {
        boolean success = false;
        try {
            if (this.infoStream != null) {
                this.message("now start transaction");
            }
            if (!$assertionsDisabled && this.docWriter.getNumBufferedDeleteTerms() != 0) {
                throw new AssertionError((Object)("calling startTransaction with buffered delete terms not supported: numBufferedDeleteTerms=" + this.docWriter.getNumBufferedDeleteTerms()));
            }
            if (!$assertionsDisabled && this.docWriter.getNumDocsInRAM() != 0) {
                throw new AssertionError((Object)("calling startTransaction with buffered documents not supported: numDocsInRAM=" + this.docWriter.getNumDocsInRAM()));
            }
            this.ensureOpen();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                while (this.stopMerges) {
                    this.doWait();
                }
            }
            success = true;
            Object var6_5 = null;
            if (!success && haveReadLock) {
                this.releaseRead();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!success && haveReadLock) {
                this.releaseRead();
            }
            throw throwable;
        }
        if (haveReadLock) {
            this.upgradeReadToWrite();
        } else {
            this.acquireWrite();
        }
        success = false;
        try {
            this.localRollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
            if (!$assertionsDisabled && this.hasExternalSegments()) {
                throw new AssertionError();
            }
            this.localAutoCommit = this.autoCommit;
            this.localFlushedDocCount = this.docWriter.getFlushedDocCount();
            if (this.localAutoCommit) {
                if (this.infoStream != null) {
                    this.message("flush at startTransaction");
                }
                this.flush(true, false, false);
                this.autoCommit = false;
            } else {
                this.deleter.incRef(this.segmentInfos, false);
            }
            success = true;
            Object var8_8 = null;
            if (!success) {
                this.finishAddIndexes();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!success) {
                this.finishAddIndexes();
            }
            throw throwable;
        }
    }

    private synchronized void rollbackTransaction() throws IOException {
        if (this.infoStream != null) {
            this.message("now rollback transaction");
        }
        this.autoCommit = this.localAutoCommit;
        if (this.docWriter != null) {
            this.docWriter.setFlushedDocCount(this.localFlushedDocCount);
        }
        this.finishMerges(false);
        this.segmentInfos.clear();
        this.segmentInfos.addAll(this.localRollbackSegmentInfos);
        this.localRollbackSegmentInfos = null;
        this.finishAddIndexes();
        this.deleter.checkpoint(this.segmentInfos, false);
        if (!this.autoCommit) {
            this.deleter.decRef(this.segmentInfos);
        }
        this.deleter.refresh();
        this.notifyAll();
        if (!$assertionsDisabled && this.hasExternalSegments()) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commitTransaction() throws IOException {
        block7: {
            if (this.infoStream != null) {
                this.message("now commit transaction");
            }
            this.autoCommit = this.localAutoCommit;
            this.checkpoint();
            if (this.autoCommit) {
                block8: {
                    boolean success = false;
                    try {
                        this.commit(0L);
                        success = true;
                        Object var3_2 = null;
                        if (success) break block7;
                        if (this.infoStream == null) break block8;
                        this.message("hit exception committing transaction");
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception committing transaction");
                            }
                            this.rollbackTransaction();
                        }
                        throw throwable;
                    }
                }
                this.rollbackTransaction();
                {
                    break block7;
                }
            }
            this.deleter.decRef(this.localRollbackSegmentInfos);
        }
        this.localRollbackSegmentInfos = null;
        if (!$assertionsDisabled && this.hasExternalSegments()) {
            throw new AssertionError();
        }
        this.finishAddIndexes();
    }

    public void abort() throws IOException {
        this.rollback();
    }

    public void rollback() throws IOException {
        this.ensureOpen();
        if (this.autoCommit) {
            throw new IllegalStateException("rollback() can only be called when IndexWriter was opened with autoCommit=false");
        }
        if (this.shouldClose()) {
            this.rollbackInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollbackInternal() throws IOException {
        block19: {
            IndexWriter indexWriter;
            boolean success = false;
            this.docWriter.pauseAllThreads();
            try {
                try {
                    this.finishMerges(false);
                    this.mergePolicy.close();
                    this.mergeScheduler.close();
                    IndexWriter indexWriter2 = this;
                    synchronized (indexWriter2) {
                        if (this.pendingCommit != null) {
                            this.pendingCommit.rollbackCommit(this.directory);
                            this.deleter.decRef(this.pendingCommit);
                            this.pendingCommit = null;
                            this.notifyAll();
                        }
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(this.rollbackSegmentInfos);
                        if (!$assertionsDisabled && this.hasExternalSegments()) {
                            throw new AssertionError();
                        }
                        this.docWriter.abort();
                        if (!$assertionsDisabled && !this.testPoint("rollback before checkpoint")) {
                            throw new AssertionError();
                        }
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.deleter.refresh();
                    }
                    this.readerPool.clear(null);
                    this.lastCommitChangeCount = this.changeCount;
                    success = true;
                }
                catch (OutOfMemoryError oom) {
                    this.handleOOM(oom, "rollbackInternal");
                    Object var5_5 = null;
                    IndexWriter indexWriter2 = this;
                    synchronized (indexWriter2) {
                        if (!success) {
                            this.docWriter.resumeAllThreads();
                            this.closing = false;
                            this.notifyAll();
                            if (this.infoStream != null) {
                                this.message("hit exception during rollback");
                            }
                        }
                        break block19;
                    }
                }
                Object var5_4 = null;
                indexWriter = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IndexWriter indexWriter4 = this;
                synchronized (indexWriter4) {
                    if (!success) {
                        this.docWriter.resumeAllThreads();
                        this.closing = false;
                        this.notifyAll();
                        if (this.infoStream != null) {
                            this.message("hit exception during rollback");
                        }
                    }
                    throw throwable;
                }
            }
            synchronized (indexWriter) {
                if (!success) {
                    this.docWriter.resumeAllThreads();
                    this.closing = false;
                    this.notifyAll();
                    if (this.infoStream != null) {
                        this.message("hit exception during rollback");
                    }
                }
            }
        }
        this.closeInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAll() throws IOException {
        this.docWriter.pauseAllThreads();
        try {
            try {
                this.finishMerges(false);
                this.docWriter.abort();
                this.docWriter.setFlushedDocCount(0);
                this.segmentInfos.clear();
                this.deleter.checkpoint(this.segmentInfos, false);
                this.deleter.refresh();
                this.readerPool.clear(null);
                ++this.changeCount;
            }
            catch (OutOfMemoryError oom) {
                this.handleOOM(oom, "deleteAll");
                Object var3_2 = null;
                this.docWriter.resumeAllThreads();
                if (this.infoStream != null) {
                    this.message("hit exception during deleteAll");
                }
            }
            Object var3_1 = null;
            this.docWriter.resumeAllThreads();
            if (this.infoStream != null) {
                this.message("hit exception during deleteAll");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.docWriter.resumeAllThreads();
            if (this.infoStream != null) {
                this.message("hit exception during deleteAll");
            }
            throw throwable;
        }
    }

    private synchronized void finishMerges(boolean waitForMerges) throws IOException {
        if (!waitForMerges) {
            MergePolicy.OneMerge merge;
            this.stopMerges = true;
            Iterator it = this.pendingMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                if (this.infoStream != null) {
                    this.message("now abort pending merge " + merge.segString(this.directory));
                }
                merge.abort();
                this.mergeFinish(merge);
            }
            this.pendingMerges.clear();
            it = this.runningMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                if (this.infoStream != null) {
                    this.message("now abort running merge " + merge.segString(this.directory));
                }
                merge.abort();
            }
            this.acquireRead();
            this.releaseRead();
            while (this.runningMerges.size() > 0) {
                if (this.infoStream != null) {
                    this.message("now wait for " + this.runningMerges.size() + " running merge to abort");
                }
                this.doWait();
            }
            this.stopMerges = false;
            this.notifyAll();
            if (!$assertionsDisabled && 0 != this.mergingSegments.size()) {
                throw new AssertionError();
            }
            if (this.infoStream != null) {
                this.message("all running merges have aborted");
            }
        } else {
            this.waitForMerges();
        }
    }

    public synchronized void waitForMerges() {
        this.acquireRead();
        this.releaseRead();
        while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
            this.doWait();
        }
        if (!$assertionsDisabled && 0 != this.mergingSegments.size()) {
            throw new AssertionError();
        }
    }

    private synchronized void checkpoint() throws IOException {
        ++this.changeCount;
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    private void finishAddIndexes() {
        this.releaseWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockAddIndexes(boolean includePendingClose) {
        this.acquireRead();
        boolean success = false;
        try {
            this.ensureOpen(includePendingClose);
            success = true;
            Object var4_3 = null;
            if (!success) {
                this.releaseRead();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!success) {
                this.releaseRead();
            }
            throw throwable;
        }
    }

    private void resumeAddIndexes() {
        this.releaseRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIndexes(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.noDupDirs(dirs);
        this.docWriter.pauseAllThreads();
        try {
            try {
                block14: {
                    block13: {
                        if (this.infoStream != null) {
                            this.message("flush at addIndexes");
                        }
                        this.flush(true, false, true);
                        boolean success = false;
                        this.startTransaction(false);
                        try {
                            int docCount = 0;
                            IndexWriter indexWriter = this;
                            synchronized (indexWriter) {
                                this.ensureOpen();
                                for (int i = 0; i < dirs.length; ++i) {
                                    SegmentInfo info;
                                    SegmentInfos sis = new SegmentInfos();
                                    sis.read(dirs[i]);
                                    for (int j = 0; j < sis.size(); docCount += info.docCount, ++j) {
                                        info = sis.info(j);
                                        if (!$assertionsDisabled && this.segmentInfos.contains(info)) {
                                            throw new AssertionError();
                                        }
                                        this.segmentInfos.add(info);
                                    }
                                }
                            }
                            this.docWriter.updateFlushedDocCount(docCount);
                            this.optimize();
                            success = true;
                            Object var11_10 = null;
                            if (!success) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var11_11 = null;
                            if (success) {
                                this.commitTransaction();
                                throw throwable;
                            }
                            this.rollbackTransaction();
                            throw throwable;
                        }
                        this.commitTransaction();
                        break block14;
                    }
                    this.rollbackTransaction();
                }
                Object var13_13 = null;
                if (this.docWriter == null) return;
                this.docWriter.resumeAllThreads();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.handleOOM(oom, "addIndexes(Directory[])");
                Object var13_14 = null;
                if (this.docWriter == null) return;
                this.docWriter.resumeAllThreads();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (this.docWriter == null) throw throwable;
            this.docWriter.resumeAllThreads();
            throw throwable;
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory[] dirs) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs.length; ++i) {
            if (dups.contains(dirs[i])) {
                throw new IllegalArgumentException("Directory " + dirs[i] + " appears more than once");
            }
            if (dirs[i] == this.directory) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIndexesNoOptimize(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.noDupDirs(dirs);
        this.docWriter.pauseAllThreads();
        try {
            try {
                block15: {
                    block14: {
                        if (this.infoStream != null) {
                            this.message("flush at addIndexesNoOptimize");
                        }
                        this.flush(true, false, true);
                        boolean success = false;
                        this.startTransaction(false);
                        try {
                            int docCount = 0;
                            IndexWriter indexWriter = this;
                            synchronized (indexWriter) {
                                this.ensureOpen();
                                for (int i = 0; i < dirs.length; ++i) {
                                    SegmentInfo info;
                                    if (this.directory == dirs[i]) {
                                        throw new IllegalArgumentException("Cannot add this index to itself");
                                    }
                                    SegmentInfos sis = new SegmentInfos();
                                    sis.read(dirs[i]);
                                    for (int j = 0; j < sis.size(); docCount += info.docCount, ++j) {
                                        info = sis.info(j);
                                        if (!$assertionsDisabled && this.segmentInfos.contains(info)) {
                                            throw new AssertionError((Object)("dup info dir=" + info.dir + " name=" + info.name));
                                        }
                                        this.segmentInfos.add(info);
                                    }
                                }
                            }
                            this.docWriter.updateFlushedDocCount(docCount);
                            this.maybeMerge();
                            this.ensureOpen();
                            this.resolveExternalSegments();
                            this.ensureOpen();
                            success = true;
                            Object var11_10 = null;
                            if (!success) break block14;
                        }
                        catch (Throwable throwable) {
                            Object var11_11 = null;
                            if (success) {
                                this.commitTransaction();
                                throw throwable;
                            }
                            this.rollbackTransaction();
                            throw throwable;
                        }
                        this.commitTransaction();
                        break block15;
                    }
                    this.rollbackTransaction();
                }
                Object var13_13 = null;
                if (this.docWriter == null) return;
                this.docWriter.resumeAllThreads();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.handleOOM(oom, "addIndexesNoOptimize");
                Object var13_14 = null;
                if (this.docWriter == null) return;
                this.docWriter.resumeAllThreads();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (this.docWriter == null) throw throwable;
            this.docWriter.resumeAllThreads();
            throw throwable;
        }
    }

    private boolean hasExternalSegments() {
        return this.segmentInfos.hasExternalSegments(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExternalSegments() throws CorruptIndexException, IOException {
        boolean any = false;
        boolean done = false;
        while (!done) {
            SegmentInfo info = null;
            MergePolicy.OneMerge merge = null;
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    throw new MergePolicy.MergeAbortedException("rollback() was called or addIndexes* hit an unhandled exception");
                }
                int numSegments = this.segmentInfos.size();
                done = true;
                for (int i = 0; i < numSegments; ++i) {
                    info = this.segmentInfos.info(i);
                    if (info.dir == this.directory) continue;
                    done = false;
                    MergePolicy.OneMerge newMerge = new MergePolicy.OneMerge(this.segmentInfos.range(i, 1 + i), this.mergePolicy instanceof LogMergePolicy && this.getUseCompoundFile());
                    if (!this.registerMerge(newMerge)) continue;
                    merge = newMerge;
                    this.pendingMerges.remove(merge);
                    this.runningMerges.add(merge);
                    break;
                }
                if (!done && merge == null) {
                    merge = this.getNextExternalMerge();
                }
                if (!done && merge == null) {
                    this.doWait();
                }
            }
            if (merge == null) continue;
            any = true;
            this.merge(merge);
        }
        if (any) {
            this.mergeScheduler.merge(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addIndexes(IndexReader[] readers) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.docWriter.pauseAllThreads();
        this.acquireRead();
        try {
            try {
                IndexWriter indexWriter;
                SegmentInfo info = null;
                String mergedName = null;
                SegmentMerger merger = null;
                boolean success = false;
                try {
                    this.flush(true, false, true);
                    this.optimize();
                    success = true;
                    indexWriter = null;
                    if (!success) {
                        this.releaseRead();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (success) throw throwable;
                    this.releaseRead();
                    throw throwable;
                }
                this.startTransaction(true);
                try {
                    mergedName = this.newSegmentName();
                    merger = new SegmentMerger(this, mergedName, null);
                    SegmentReader sReader = null;
                    indexWriter = this;
                    // MONITORENTER : indexWriter
                    if (this.segmentInfos.size() == 1) {
                        sReader = this.readerPool.get(this.segmentInfos.info(0), true, 1024, -1);
                    }
                    // MONITOREXIT : indexWriter
                    success = false;
                    try {
                        if (sReader != null) {
                            merger.add(sReader);
                        }
                        for (int i = 0; i < readers.length; ++i) {
                            merger.add(readers[i]);
                        }
                        int docCount = merger.merge();
                        IndexWriter indexWriter2 = this;
                        // MONITORENTER : indexWriter2
                        this.segmentInfos.clear();
                        info = new SegmentInfo(mergedName, docCount, this.directory, false, true, -1, null, false, merger.hasProx());
                        this.setDiagnostics(info, "addIndexes(IndexReader[])");
                        this.segmentInfos.add(info);
                        // MONITOREXIT : indexWriter2
                        this.docWriter.updateFlushedDocCount(docCount);
                        success = true;
                        Object var11_14 = null;
                        if (sReader != null) {
                            this.readerPool.release(sReader);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (sReader == null) throw throwable;
                        this.readerPool.release(sReader);
                        throw throwable;
                    }
                    Object var13_17 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception in addIndexes during merge");
                        }
                        this.rollbackTransaction();
                    } else {
                        this.commitTransaction();
                    }
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (success) {
                        this.commitTransaction();
                        throw throwable;
                    }
                    if (this.infoStream != null) {
                        this.message("hit exception in addIndexes during merge");
                    }
                    this.rollbackTransaction();
                    throw throwable;
                }
                if (this.mergePolicy instanceof LogMergePolicy && this.getUseCompoundFile()) {
                    List files = null;
                    IndexWriter indexWriter3 = this;
                    // MONITORENTER : indexWriter3
                    if (this.segmentInfos.contains(info)) {
                        files = info.files();
                        this.deleter.incRef(files);
                    }
                    // MONITOREXIT : indexWriter3
                    if (files != null) {
                        success = false;
                        this.startTransaction(false);
                        try {
                            merger.createCompoundFile(mergedName + ".cfs");
                            indexWriter3 = this;
                            // MONITORENTER : indexWriter3
                            info.setUseCompoundFile(true);
                            // MONITOREXIT : indexWriter3
                            success = true;
                            Object var17_20 = null;
                            this.deleter.decRef(files);
                            if (!success) {
                                if (this.infoStream != null) {
                                    this.message("hit exception building compound file in addIndexes during merge");
                                }
                                this.rollbackTransaction();
                            } else {
                                this.commitTransaction();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_21 = null;
                            this.deleter.decRef(files);
                            if (success) {
                                this.commitTransaction();
                                throw throwable;
                            }
                            if (this.infoStream != null) {
                                this.message("hit exception building compound file in addIndexes during merge");
                            }
                            this.rollbackTransaction();
                            throw throwable;
                        }
                    }
                }
                Object var19_23 = null;
                if (this.docWriter == null) return;
                this.docWriter.resumeAllThreads();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.handleOOM(oom, "addIndexes(IndexReader[])");
                Object var19_24 = null;
                if (this.docWriter == null) return;
                this.docWriter.resumeAllThreads();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (this.docWriter == null) throw throwable;
            this.docWriter.resumeAllThreads();
            throw throwable;
        }
    }

    protected void doAfterFlush() throws IOException {
    }

    public final void flush() throws CorruptIndexException, IOException {
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot flush");
        }
        this.flush(true, false, true);
    }

    protected void doBeforeFlush() throws IOException {
    }

    public final void prepareCommit() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.prepareCommit(null);
    }

    public final void prepareCommit(Map commitUserData) throws CorruptIndexException, IOException {
        this.prepareCommit(commitUserData, false);
    }

    private final void prepareCommit(Map commitUserData, boolean internal) throws CorruptIndexException, IOException {
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot commit");
        }
        if (this.autoCommit && !internal) {
            throw new IllegalStateException("this method can only be used when autoCommit is false");
        }
        if (!this.autoCommit && this.pendingCommit != null) {
            throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
        }
        if (this.infoStream != null) {
            this.message("prepareCommit: flush");
        }
        this.flush(true, true, true);
        this.startCommit(0L, commitUserData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(long sizeInBytes) throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            this.startCommit(sizeInBytes, null);
            this.finishCommit();
        }
    }

    public final void commit() throws CorruptIndexException, IOException {
        this.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(Map commitUserData) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.infoStream != null) {
            this.message("commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            if (this.infoStream != null) {
                this.message("commit: enter lock");
            }
            if (this.autoCommit || this.pendingCommit == null) {
                if (this.infoStream != null) {
                    this.message("commit: now prepare");
                }
                this.prepareCommit(commitUserData, true);
            } else if (this.infoStream != null) {
                this.message("commit: already prepared");
            }
            this.finishCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void finishCommit() throws CorruptIndexException, IOException {
        block7: {
            if (this.pendingCommit != null) {
                try {
                    if (this.infoStream != null) {
                        this.message("commit: pendingCommit != null");
                    }
                    this.pendingCommit.finishCommit(this.directory);
                    if (this.infoStream != null) {
                        this.message("commit: wrote segments file \"" + this.pendingCommit.getCurrentSegmentFileName() + "\"");
                    }
                    this.lastCommitChangeCount = this.pendingCommitChangeCount;
                    this.segmentInfos.updateGeneration(this.pendingCommit);
                    this.segmentInfos.setUserData(this.pendingCommit.getUserData());
                    this.setRollbackSegmentInfos(this.pendingCommit);
                    this.deleter.checkpoint(this.pendingCommit, true);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.deleter.decRef(this.pendingCommit);
                    this.pendingCommit = null;
                    this.notifyAll();
                    throw throwable;
                }
                this.deleter.decRef(this.pendingCommit);
                this.pendingCommit = null;
                this.notifyAll();
                {
                    break block7;
                }
            }
            if (this.infoStream != null) {
                this.message("commit: pendingCommit == null; skip");
            }
        }
        if (this.infoStream != null) {
            this.message("commit: done");
        }
    }

    protected final void flush(boolean triggerMerge, boolean flushDocStores, boolean flushDeletes) throws CorruptIndexException, IOException {
        this.ensureOpen(false);
        if (this.doFlush(flushDocStores, flushDeletes) && triggerMerge) {
            this.maybeMerge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean doFlush(boolean flushDocStores, boolean flushDeletes) throws CorruptIndexException, IOException {
        try {
            boolean bl = this.doFlushInternal(flushDocStores, flushDeletes);
            Object var5_4 = null;
            if (this.docWriter.doBalanceRAM()) {
                this.docWriter.balanceRAM();
            }
            this.docWriter.clearFlushPending();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.docWriter.doBalanceRAM()) {
                this.docWriter.balanceRAM();
            }
            this.docWriter.clearFlushPending();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean doFlushInternal(boolean flushDocStores, boolean flushDeletes) throws CorruptIndexException, IOException {
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot flush");
        }
        this.ensureOpen(false);
        if (!$assertionsDisabled && !this.testPoint("startDoFlush")) {
            throw new AssertionError();
        }
        this.doBeforeFlush();
        ++this.flushCount;
        flushDeletes |= this.docWriter.doApplyDeletes();
        flushDeletes |= this.autoCommit;
        if (this.infoStream != null) {
            this.message("flush: now pause all indexing threads");
        }
        if (this.docWriter.pauseAllThreads()) {
            this.docWriter.resumeAllThreads();
            return false;
        }
        try {
            boolean success;
            SegmentInfo newSegment = null;
            int numDocs = this.docWriter.getNumDocsInRAM();
            boolean flushDocs = numDocs > 0;
            flushDocStores |= this.autoCommit;
            String docStoreSegment = this.docWriter.getDocStoreSegment();
            if (!$assertionsDisabled && docStoreSegment == null && numDocs != 0) {
                throw new AssertionError();
            }
            if (docStoreSegment == null) {
                flushDocStores = false;
            }
            int docStoreOffset = this.docWriter.getDocStoreOffset();
            if (!$assertionsDisabled && this.autoCommit && 0 != docStoreOffset) {
                throw new AssertionError();
            }
            boolean docStoreIsCompoundFile = false;
            if (this.infoStream != null) {
                this.message("  flush: segment=" + this.docWriter.getSegment() + " docStoreSegment=" + this.docWriter.getDocStoreSegment() + " docStoreOffset=" + docStoreOffset + " flushDocs=" + flushDocs + " flushDeletes=" + flushDeletes + " flushDocStores=" + flushDocStores + " numDocs=" + numDocs + " numBufDelTerms=" + this.docWriter.getNumBufferedDeleteTerms());
                this.message("  index before flush " + this.segString());
            }
            if (!(!flushDocStores || flushDocs && this.docWriter.getSegment().equals(this.docWriter.getDocStoreSegment()))) {
                if (this.infoStream != null) {
                    this.message("  flush shared docStore segment " + docStoreSegment);
                }
                docStoreIsCompoundFile = this.flushDocStores();
                flushDocStores = false;
            }
            String segment = this.docWriter.getSegment();
            if (!$assertionsDisabled && segment == null && flushDocs) {
                throw new AssertionError();
            }
            if (flushDocs) {
                int flushedDocCount;
                block31: {
                    block32: {
                        success = false;
                        try {
                            flushedDocCount = this.docWriter.flush(flushDocStores);
                            success = true;
                            Object var13_14 = null;
                            if (success) break block31;
                            if (this.infoStream == null) break block32;
                            this.message("hit exception flushing segment " + segment);
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            if (!success) {
                                if (this.infoStream != null) {
                                    this.message("hit exception flushing segment " + segment);
                                }
                                this.deleter.refresh(segment);
                            }
                            throw throwable;
                        }
                    }
                    this.deleter.refresh(segment);
                    {
                    }
                }
                if (0 == docStoreOffset && flushDocStores) {
                    if (!$assertionsDisabled && docStoreSegment == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !docStoreSegment.equals(segment)) {
                        throw new AssertionError();
                    }
                    docStoreOffset = -1;
                    docStoreIsCompoundFile = false;
                    docStoreSegment = null;
                }
                newSegment = new SegmentInfo(segment, flushedDocCount, this.directory, false, true, docStoreOffset, docStoreSegment, docStoreIsCompoundFile, this.docWriter.hasProx());
                this.setDiagnostics(newSegment, "flush");
            }
            this.docWriter.pushDeletes();
            if (flushDocs) {
                this.segmentInfos.add(newSegment);
                this.checkpoint();
            }
            if (flushDocs && this.mergePolicy.useCompoundFile(this.segmentInfos, newSegment)) {
                block33: {
                    block34: {
                        success = false;
                        try {
                            this.docWriter.createCompoundFile(segment);
                            success = true;
                            Object var15_17 = null;
                            if (success) break block33;
                            if (this.infoStream == null) break block34;
                            this.message("hit exception creating compound file for newly flushed segment " + segment);
                        }
                        catch (Throwable throwable) {
                            Object var15_18 = null;
                            if (!success) {
                                if (this.infoStream != null) {
                                    this.message("hit exception creating compound file for newly flushed segment " + segment);
                                }
                                this.deleter.deleteFile(segment + "." + "cfs");
                            }
                            throw throwable;
                        }
                    }
                    this.deleter.deleteFile(segment + "." + "cfs");
                    {
                    }
                }
                newSegment.setUseCompoundFile(true);
                this.checkpoint();
            }
            if (flushDeletes) {
                this.applyDeletes();
            }
            if (flushDocs) {
                this.checkpoint();
            }
            this.doAfterFlush();
            boolean bl = flushDocs;
            Object var17_20 = null;
            this.docWriter.resumeAllThreads();
            return bl;
        }
        catch (OutOfMemoryError oom) {
            try {
                this.handleOOM(oom, "doFlush");
                boolean bl = false;
                Object var17_21 = null;
                this.docWriter.resumeAllThreads();
                return bl;
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                this.docWriter.resumeAllThreads();
                throw throwable;
            }
        }
    }

    public final long ramSizeInBytes() {
        this.ensureOpen();
        return this.docWriter.getRAMUsed();
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocsInRAM();
    }

    private int ensureContiguousMerge(MergePolicy.OneMerge merge) {
        int first = this.segmentInfos.indexOf(merge.segments.info(0));
        if (first == -1) {
            throw new MergePolicy.MergeException("could not find segment " + merge.segments.info((int)0).name + " in current index " + this.segString(), this.directory);
        }
        int numSegments = this.segmentInfos.size();
        int numSegmentsToMerge = merge.segments.size();
        for (int i = 0; i < numSegmentsToMerge; ++i) {
            SegmentInfo info = merge.segments.info(i);
            if (first + i < numSegments && this.segmentInfos.info(first + i).equals(info)) continue;
            if (this.segmentInfos.indexOf(info) == -1) {
                throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info.name + ") that is not in the current index " + this.segString(), this.directory);
            }
            throw new MergePolicy.MergeException("MergePolicy selected non-contiguous segments to merge (" + merge.segString(this.directory) + " vs " + this.segString() + "), which IndexWriter (currently) cannot handle", this.directory);
        }
        return first;
    }

    private synchronized void commitMergedDeletes(MergePolicy.OneMerge merge, SegmentReader mergeReader) throws IOException {
        if (!$assertionsDisabled && !this.testPoint("startCommitMergeDeletes")) {
            throw new AssertionError();
        }
        SegmentInfos sourceSegments = merge.segments;
        if (this.infoStream != null) {
            this.message("commitMergeDeletes " + merge.segString(this.directory));
        }
        int docUpto = 0;
        int delCount = 0;
        for (int i = 0; i < sourceSegments.size(); ++i) {
            int j;
            SegmentInfo info = sourceSegments.info(i);
            int docCount = info.docCount;
            SegmentReader previousReader = merge.readersClone[i];
            SegmentReader currentReader = merge.readers[i];
            if (previousReader.hasDeletions()) {
                if (currentReader.numDeletedDocs() > previousReader.numDeletedDocs()) {
                    for (j = 0; j < docCount; ++j) {
                        if (previousReader.isDeleted(j)) {
                            if (!$assertionsDisabled && !currentReader.isDeleted(j)) {
                                throw new AssertionError();
                            }
                            continue;
                        }
                        if (currentReader.isDeleted(j)) {
                            mergeReader.doDelete(docUpto);
                            ++delCount;
                        }
                        ++docUpto;
                    }
                    continue;
                }
                docUpto += docCount - previousReader.numDeletedDocs();
                continue;
            }
            if (currentReader.hasDeletions()) {
                for (j = 0; j < docCount; ++j) {
                    if (currentReader.isDeleted(j)) {
                        mergeReader.doDelete(docUpto);
                        ++delCount;
                    }
                    ++docUpto;
                }
                continue;
            }
            docUpto += info.docCount;
        }
        if (!$assertionsDisabled && mergeReader.numDeletedDocs() != delCount) {
            throw new AssertionError();
        }
        mergeReader.hasChanges = delCount >= 0;
    }

    private synchronized boolean commitMerge(MergePolicy.OneMerge merge, SegmentMerger merger, int mergedDocCount, SegmentReader mergedReader) throws IOException {
        if (!$assertionsDisabled && !this.testPoint("startCommitMerge")) {
            throw new AssertionError();
        }
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot complete merge");
        }
        if (this.infoStream != null) {
            this.message("commitMerge: " + merge.segString(this.directory) + " index=" + this.segString());
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        if (merge.isAborted()) {
            if (this.infoStream != null) {
                this.message("commitMerge: skipping merge " + merge.segString(this.directory) + ": it was aborted");
            }
            this.deleter.refresh(merge.info.name);
            return false;
        }
        int start = this.ensureContiguousMerge(merge);
        this.commitMergedDeletes(merge, mergedReader);
        this.docWriter.remapDeletes(this.segmentInfos, merger.getDocMaps(), merger.getDelCounts(), merge, mergedDocCount);
        this.setMergeDocStoreIsCompoundFile(merge);
        merge.info.setHasProx(merger.hasProx());
        this.segmentInfos.subList(start, start + merge.segments.size()).clear();
        if (!$assertionsDisabled && this.segmentInfos.contains(merge.info)) {
            throw new AssertionError();
        }
        this.segmentInfos.add(start, merge.info);
        this.checkpoint();
        this.readerPool.clear(merge.segments);
        if (merge.optimize) {
            this.segmentsToOptimize.add(merge.info);
        }
        return true;
    }

    private synchronized void decrefMergeSegments(MergePolicy.OneMerge merge) throws IOException {
        if (!$assertionsDisabled && !merge.increfDone) {
            throw new AssertionError();
        }
        merge.increfDone = false;
    }

    private final void handleMergeException(Throwable t, MergePolicy.OneMerge merge) throws IOException {
        if (this.infoStream != null) {
            this.message("handleMergeException: merge=" + merge.segString(this.directory) + " exc=" + t);
        }
        merge.setException(t);
        this.addMergeException(merge);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void merge(MergePolicy.OneMerge merge) throws CorruptIndexException, IOException {
        boolean success = false;
        try {
            IndexWriter indexWriter;
            try {
                try {
                    this.mergeInit(merge);
                    if (this.infoStream != null) {
                        this.message("now merge\n  merge=" + merge.segString(this.directory) + "\n  merge=" + merge + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge);
                    this.mergeSuccess(merge);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge);
                }
                Object var5_5 = null;
                indexWriter = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception during merge");
                        }
                        if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                            this.deleter.refresh(merge.info.name);
                        }
                    }
                    if (success && !merge.isAborted() && !this.closed && !this.closing) {
                        this.updatePendingMerges(merge.maxNumSegmentsOptimize, merge.optimize);
                    }
                }
                throw throwable;
            }
            synchronized (indexWriter) {
                this.mergeFinish(merge);
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception during merge");
                    }
                    if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                        this.deleter.refresh(merge.info.name);
                    }
                }
                if (success && !merge.isAborted() && !this.closed && !this.closing) {
                    this.updatePendingMerges(merge.maxNumSegmentsOptimize, merge.optimize);
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.handleOOM(oom, "merge");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge merge) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge) throws MergePolicy.MergeAbortedException {
        int i;
        if (merge.registerDone) {
            return true;
        }
        if (this.stopMerges) {
            merge.abort();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + merge.segString(this.directory));
        }
        int count = merge.segments.size();
        boolean isExternal = false;
        for (i = 0; i < count; ++i) {
            SegmentInfo info = merge.segments.info(i);
            if (this.mergingSegments.contains(info)) {
                return false;
            }
            if (this.segmentInfos.indexOf(info) == -1) {
                return false;
            }
            if (info.dir == this.directory) continue;
            isExternal = true;
        }
        this.ensureContiguousMerge(merge);
        this.pendingMerges.add(merge);
        if (this.infoStream != null) {
            this.message("add merge to pendingMerges: " + merge.segString(this.directory) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        for (i = 0; i < count; ++i) {
            this.mergingSegments.add(merge.segments.info(i));
        }
        merge.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final synchronized void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        try {
            this._mergeInit(merge);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (success) throw throwable;
            this.mergeFinish(merge);
            throw throwable;
        }
    }

    private final synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean docStoreIsCompoundFile;
        String docStoreSegment;
        int docStoreOffset;
        if (!$assertionsDisabled && !this.testPoint("startMergeInit")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && merge.optimize && merge.maxNumSegmentsOptimize <= 0) {
            throw new AssertionError();
        }
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot merge");
        }
        if (merge.info != null) {
            return;
        }
        if (merge.isAborted()) {
            return;
        }
        boolean changed = this.applyDeletes();
        if (!$assertionsDisabled && changed && this.autoCommit) {
            throw new AssertionError();
        }
        SegmentInfos sourceSegments = merge.segments;
        int end = sourceSegments.size();
        Directory lastDir = this.directory;
        String lastDocStoreSegment = null;
        int next = -1;
        boolean mergeDocStores = false;
        boolean doFlushDocStore = false;
        String currentDocStoreSegment = this.docWriter.getDocStoreSegment();
        for (int i = 0; i < end; ++i) {
            String docStoreSegment2;
            SegmentInfo si = sourceSegments.info(i);
            if (si.hasDeletions()) {
                mergeDocStores = true;
            }
            if (-1 == si.getDocStoreOffset()) {
                mergeDocStores = true;
            }
            if ((docStoreSegment2 = si.getDocStoreSegment()) == null) {
                mergeDocStores = true;
            } else if (lastDocStoreSegment == null) {
                lastDocStoreSegment = docStoreSegment2;
            } else if (!lastDocStoreSegment.equals(docStoreSegment2)) {
                mergeDocStores = true;
            }
            if (-1 == next) {
                next = si.getDocStoreOffset() + si.docCount;
            } else if (next != si.getDocStoreOffset()) {
                mergeDocStores = true;
            } else {
                next = si.getDocStoreOffset() + si.docCount;
            }
            if (lastDir != si.dir) {
                mergeDocStores = true;
            }
            if (si.getDocStoreOffset() == -1 || currentDocStoreSegment == null || !si.getDocStoreSegment().equals(currentDocStoreSegment)) continue;
            doFlushDocStore = true;
        }
        if (mergeDocStores) {
            docStoreOffset = -1;
            docStoreSegment = null;
            docStoreIsCompoundFile = false;
        } else {
            SegmentInfo si = sourceSegments.info(0);
            docStoreOffset = si.getDocStoreOffset();
            docStoreSegment = si.getDocStoreSegment();
            docStoreIsCompoundFile = si.getDocStoreIsCompoundFile();
        }
        if (mergeDocStores && doFlushDocStore) {
            if (this.infoStream != null) {
                this.message("now flush at merge");
            }
            this.doFlush(true, false);
        }
        merge.increfDone = true;
        merge.mergeDocStores = mergeDocStores;
        merge.info = new SegmentInfo(this.newSegmentName(), 0, this.directory, false, true, docStoreOffset, docStoreSegment, docStoreIsCompoundFile, false);
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("optimize", merge.optimize + "");
        details.put("mergeFactor", end + "");
        details.put("mergeDocStores", mergeDocStores + "");
        this.setDiagnostics(merge.info, "merge", details);
        this.mergingSegments.add(merge.info);
    }

    private void setDiagnostics(SegmentInfo info, String source) {
        this.setDiagnostics(info, source, null);
    }

    private void setDiagnostics(SegmentInfo info, String source, Map details) {
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put("source", source);
        diagnostics.put("lucene.version", Constants.LUCENE_VERSION);
        diagnostics.put("os", Constants.OS_NAME + "");
        diagnostics.put("os.arch", Constants.OS_ARCH + "");
        diagnostics.put("os.version", Constants.OS_VERSION + "");
        diagnostics.put("java.version", Constants.JAVA_VERSION + "");
        diagnostics.put("java.vendor", Constants.JAVA_VENDOR + "");
        if (details != null) {
            diagnostics.putAll(details);
        }
        info.setDiagnostics(diagnostics);
    }

    private synchronized boolean doCommitBeforeMergeCFS(MergePolicy.OneMerge merge) throws IOException {
        long freeableBytes = 0L;
        int size = merge.segments.size();
        for (int i = 0; i < size; ++i) {
            SegmentInfo oldInfo;
            SegmentInfo info = merge.segments.info(i);
            Integer loc = (Integer)this.rollbackSegments.get(info);
            if (loc == null || (oldInfo = this.rollbackSegmentInfos.info(loc)).getUseCompoundFile() == info.getUseCompoundFile()) continue;
            freeableBytes += info.sizeInBytes();
        }
        long totalBytes = 0L;
        int numSegments = this.segmentInfos.size();
        for (int i = 0; i < numSegments; ++i) {
            totalBytes += this.segmentInfos.info(i).sizeInBytes();
        }
        return 3L * freeableBytes > totalBytes;
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge) throws IOException {
        this.notifyAll();
        if (merge.increfDone) {
            this.decrefMergeSegments(merge);
        }
        if (merge.mergeFiles != null) {
            this.deleter.decRef(merge.mergeFiles);
            merge.mergeFiles = null;
        }
        if (merge.registerDone) {
            SegmentInfos sourceSegments = merge.segments;
            int end = sourceSegments.size();
            for (int i = 0; i < end; ++i) {
                this.mergingSegments.remove(sourceSegments.info(i));
            }
            this.mergingSegments.remove(merge.info);
            merge.registerDone = false;
        }
        this.runningMerges.remove(merge);
    }

    private synchronized void setMergeDocStoreIsCompoundFile(MergePolicy.OneMerge merge) {
        String mergeDocStoreSegment = merge.info.getDocStoreSegment();
        if (mergeDocStoreSegment != null && !merge.info.getDocStoreIsCompoundFile()) {
            int size = this.segmentInfos.size();
            for (int i = 0; i < size; ++i) {
                SegmentInfo info = this.segmentInfos.info(i);
                String docStoreSegment = info.getDocStoreSegment();
                if (docStoreSegment == null || !docStoreSegment.equals(mergeDocStoreSegment) || !info.getDocStoreIsCompoundFile()) continue;
                merge.info.setDocStoreIsCompoundFile(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private final int mergeMiddle(MergePolicy.OneMerge merge) throws CorruptIndexException, IOException {
        IndexWriter indexWriter;
        int n;
        SegmentReader mergedReader;
        merge.checkAborted(this.directory);
        String mergedName = merge.info.name;
        SegmentMerger merger = null;
        int mergedDocCount = 0;
        SegmentInfos sourceSegments = merge.segments;
        int numSegments = sourceSegments.size();
        if (this.infoStream != null) {
            this.message("merging " + merge.segString(this.directory));
        }
        merger = new SegmentMerger(this, mergedName, merge);
        merge.readers = new SegmentReader[numSegments];
        merge.readersClone = new SegmentReader[numSegments];
        boolean mergeDocStores = false;
        HashSet<String> dss = new HashSet<String>();
        boolean success = false;
        try {
            boolean loadDocStores;
            int termsIndexDivisor;
            Object reader;
            int totDocCount = 0;
            for (int i = 0; i < numSegments; ++i) {
                SegmentInfo info = sourceSegments.info(i);
                merge.readers[i] = this.readerPool.get(info, merge.mergeDocStores, 4096, -1);
                reader = merge.readers[i];
                SegmentReader clone = merge.readersClone[i] = (SegmentReader)((SegmentReader)reader).clone(true);
                merger.add(clone);
                if (clone.hasDeletions()) {
                    mergeDocStores = true;
                }
                if (info.getDocStoreOffset() != -1) {
                    dss.add(info.getDocStoreSegment());
                }
                totDocCount += clone.numDocs();
            }
            if (this.infoStream != null) {
                this.message("merge: total " + totDocCount + " docs");
            }
            merge.checkAborted(this.directory);
            if (mergeDocStores && !merge.mergeDocStores) {
                merge.mergeDocStores = true;
                IndexWriter i = this;
                synchronized (i) {
                    if (dss.contains(this.docWriter.getDocStoreSegment())) {
                        if (this.infoStream != null) {
                            this.message("now flush at mergeMiddle");
                        }
                        this.doFlush(true, false);
                    }
                }
                for (int i2 = 0; i2 < numSegments; ++i2) {
                    merge.readersClone[i2].openDocStores();
                }
                IndexWriter i2 = this;
                synchronized (i2) {
                    merge.info.setDocStore(-1, null, false);
                }
            }
            mergedDocCount = merge.info.docCount = merger.merge(merge.mergeDocStores);
            if (!$assertionsDisabled && mergedDocCount != totDocCount) {
                throw new AssertionError();
            }
            reader = this;
            synchronized (reader) {
                this.setMergeDocStoreIsCompoundFile(merge);
                if (!$assertionsDisabled && merge.mergeFiles != null) {
                    throw new AssertionError();
                }
                merge.mergeFiles = merge.info.files();
                this.deleter.incRef(merge.mergeFiles);
            }
            if (this.poolReaders && this.mergedSegmentWarmer != null) {
                termsIndexDivisor = this.readerTermsIndexDivisor;
                loadDocStores = true;
            } else {
                termsIndexDivisor = -1;
                loadDocStores = false;
            }
            mergedReader = this.readerPool.get(merge.info, loadDocStores, 1024, termsIndexDivisor);
            if (this.poolReaders && this.mergedSegmentWarmer != null) {
                this.mergedSegmentWarmer.warm(mergedReader);
            }
            if (this.commitMerge(merge, merger, mergedDocCount, mergedReader)) break block119;
            n = 0;
            Object var19_32 = null;
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                this.readerPool.release(mergedReader);
            }
            Object var23_41 = null;
            indexWriter = this;
        }
        catch (Throwable throwable) {
            Object var23_43 = null;
            IndexWriter indexWriter3 = this;
            synchronized (indexWriter3) {
                if (!success) {
                    for (int i = 0; i < numSegments; ++i) {
                        Throwable t222;
                        if (merge.readers[i] != null) {
                            try {
                                this.readerPool.release(merge.readers[i], true);
                            }
                            catch (Throwable t222) {
                                // empty catch block
                            }
                        }
                        if (merge.readersClone[i] == null) continue;
                        try {
                            merge.readersClone[i].close();
                        }
                        catch (Throwable t222) {
                            // empty catch block
                        }
                        if (!$assertionsDisabled && merge.readersClone[i].getRefCount() != 0) {
                            throw new AssertionError();
                        }
                    }
                } else {
                    for (int i = 0; i < numSegments; ++i) {
                        if (merge.readers[i] != null) {
                            this.readerPool.release(merge.readers[i], true);
                        }
                        if (merge.readersClone[i] == null) continue;
                        merge.readersClone[i].close();
                        if (!$assertionsDisabled && merge.readersClone[i].getRefCount() != 0) {
                            throw new AssertionError();
                        }
                    }
                }
            }
            throw throwable;
        }
        synchronized (indexWriter) {
            if (!success) {
                for (int i = 0; i < numSegments; ++i) {
                    Throwable t222;
                    if (merge.readers[i] != null) {
                        try {
                            this.readerPool.release(merge.readers[i], true);
                        }
                        catch (Throwable t222) {
                            // empty catch block
                        }
                    }
                    if (merge.readersClone[i] == null) continue;
                    try {
                        merge.readersClone[i].close();
                    }
                    catch (Throwable t222) {
                        // empty catch block
                    }
                    if (!$assertionsDisabled && merge.readersClone[i].getRefCount() != 0) {
                        throw new AssertionError();
                    }
                }
            } else {
                for (int i = 0; i < numSegments; ++i) {
                    if (merge.readers[i] != null) {
                        this.readerPool.release(merge.readers[i], true);
                    }
                    if (merge.readersClone[i] == null) continue;
                    merge.readersClone[i].close();
                    if (!$assertionsDisabled && merge.readersClone[i].getRefCount() != 0) {
                        throw new AssertionError();
                    }
                }
            }
        }
        {
            IndexWriter indexWriter4;
            block119: {
                return n;
            }
            try {
                Object var19_33 = null;
                indexWriter4 = this;
            }
            catch (Throwable throwable) {
                Object var19_34 = null;
                IndexWriter indexWriter5 = this;
                synchronized (indexWriter5) {
                    this.readerPool.release(mergedReader);
                }
                throw throwable;
            }
            synchronized (indexWriter4) {
                this.readerPool.release(mergedReader);
            }
            success = true;
        }
        Object var23_42 = null;
        IndexWriter indexWriter6 = this;
        synchronized (indexWriter6) {
            if (!success) {
                for (int i = 0; i < numSegments; ++i) {
                    Throwable t222;
                    if (merge.readers[i] != null) {
                        try {
                            this.readerPool.release(merge.readers[i], true);
                        }
                        catch (Throwable t222) {
                            // empty catch block
                        }
                    }
                    if (merge.readersClone[i] == null) continue;
                    try {
                        merge.readersClone[i].close();
                    }
                    catch (Throwable t222) {
                        // empty catch block
                    }
                    if (!$assertionsDisabled && merge.readersClone[i].getRefCount() != 0) {
                        throw new AssertionError();
                    }
                }
            } else {
                for (int i = 0; i < numSegments; ++i) {
                    if (merge.readers[i] != null) {
                        this.readerPool.release(merge.readers[i], true);
                    }
                    if (merge.readersClone[i] == null) continue;
                    merge.readersClone[i].close();
                    if (!$assertionsDisabled && merge.readersClone[i].getRefCount() != 0) {
                        throw new AssertionError();
                    }
                }
            }
        }
        IndexWriter totDocCount = this;
        synchronized (totDocCount) {
            this.deleter.checkpoint(this.segmentInfos, false);
        }
        this.decrefMergeSegments(merge);
        if (merge.useCompoundFile) {
            String compoundFileName;
            block125: {
                IndexWriter indexWriter7;
                if (this.autoCommit && this.doCommitBeforeMergeCFS(merge)) {
                    long size;
                    IndexWriter indexWriter8 = this;
                    synchronized (indexWriter8) {
                        size = merge.info.sizeInBytes();
                    }
                    this.commit(size);
                }
                success = false;
                compoundFileName = mergedName + "." + "cfs";
                try {
                    merger.createCompoundFile(compoundFileName);
                    success = true;
                    Object var32_63 = null;
                    if (success) break block125;
                    if (this.infoStream != null) {
                        this.message("hit exception creating compound file during merge");
                    }
                    indexWriter7 = this;
                }
                catch (Throwable throwable) {
                    Object var32_66 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file during merge");
                        }
                        IndexWriter indexWriter9 = this;
                        synchronized (indexWriter9) {
                            this.deleter.deleteFile(compoundFileName);
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter7) {
                    this.deleter.deleteFile(compoundFileName);
                }
                {
                    catch (IOException ioe) {
                        IndexWriter indexWriter10 = this;
                        synchronized (indexWriter10) {
                            if (merge.isAborted()) {
                                success = true;
                            } else {
                                this.handleMergeException(ioe, merge);
                            }
                        }
                        Object var32_64 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception creating compound file during merge");
                            }
                            IndexWriter indexWriter11 = this;
                            synchronized (indexWriter11) {
                                this.deleter.deleteFile(compoundFileName);
                            }
                        }
                        break block125;
                    }
                    catch (Throwable t) {
                        this.handleMergeException(t, merge);
                        Object var32_65 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception creating compound file during merge");
                            }
                            IndexWriter indexWriter12 = this;
                            synchronized (indexWriter12) {
                                this.deleter.deleteFile(compoundFileName);
                            }
                        }
                    }
                }
            }
            if (merge.isAborted()) {
                if (this.infoStream != null) {
                    this.message("abort merge after building CFS");
                }
                this.deleter.deleteFile(compoundFileName);
                return 0;
            }
            IndexWriter indexWriter13 = this;
            synchronized (indexWriter13) {
                if (this.segmentInfos.indexOf(merge.info) == -1 || merge.isAborted()) {
                    this.deleter.deleteFile(compoundFileName);
                } else {
                    merge.info.setUseCompoundFile(true);
                    this.checkpoint();
                }
            }
        }
        if (this.autoCommit) {
            long size;
            IndexWriter indexWriter14 = this;
            synchronized (indexWriter14) {
                size = merge.info.sizeInBytes();
            }
            this.commit(size);
        }
        return mergedDocCount;
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge) {
        if (!$assertionsDisabled && merge.getException() == null) {
            throw new AssertionError();
        }
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean applyDeletes() throws CorruptIndexException, IOException {
        boolean changed;
        block8: {
            SegmentInfos rollback;
            block9: {
                if (!$assertionsDisabled && !this.testPoint("startApplyDeletes")) {
                    throw new AssertionError();
                }
                ++this.flushDeletesCount;
                rollback = (SegmentInfos)this.segmentInfos.clone();
                boolean success = false;
                try {
                    changed = this.docWriter.applyDeletes(this.segmentInfos);
                    success = true;
                    Object var5_4 = null;
                    if (success) break block8;
                    if (this.infoStream == null) break block9;
                    this.message("hit exception flushing deletes");
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception flushing deletes");
                        }
                        int size = rollback.size();
                        for (int i = 0; i < size; ++i) {
                            String newDelFileName = this.segmentInfos.info(i).getDelFileName();
                            String delFileName = rollback.info(i).getDelFileName();
                            if (newDelFileName == null || newDelFileName.equals(delFileName)) continue;
                            this.deleter.deleteFile(newDelFileName);
                        }
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(rollback);
                    }
                    throw throwable;
                }
            }
            int size = rollback.size();
            for (int i = 0; i < size; ++i) {
                String newDelFileName = this.segmentInfos.info(i).getDelFileName();
                String delFileName = rollback.info(i).getDelFileName();
                if (newDelFileName == null || newDelFileName.equals(delFileName)) continue;
                this.deleter.deleteFile(newDelFileName);
            }
            this.segmentInfos.clear();
            this.segmentInfos.addAll(rollback);
            {
            }
        }
        if (changed) {
            this.checkpoint();
        }
        return changed;
    }

    final synchronized int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTerms().size();
    }

    final synchronized int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    SegmentInfo newestSegment() {
        return this.segmentInfos.info(this.segmentInfos.size() - 1);
    }

    public synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    private synchronized String segString(SegmentInfos infos) {
        StringBuffer buffer = new StringBuffer();
        int count = infos.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentInfo info = infos.info(i);
            buffer.append(info.segString(this.directory));
            if (info.dir == this.directory) continue;
            buffer.append("**");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startSync(String fileName, Collection pending) {
        HashSet hashSet = this.synced;
        synchronized (hashSet) {
            if (!this.synced.contains(fileName)) {
                if (!this.syncing.contains(fileName)) {
                    this.syncing.add(fileName);
                    return true;
                }
                pending.add(fileName);
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSync(String fileName, boolean success) {
        HashSet hashSet = this.synced;
        synchronized (hashSet) {
            if (!$assertionsDisabled && !this.syncing.contains(fileName)) {
                throw new AssertionError();
            }
            this.syncing.remove(fileName);
            if (success) {
                this.synced.add(fileName);
            }
            this.synced.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForAllSynced(Collection syncing) throws IOException {
        HashSet hashSet = this.synced;
        synchronized (hashSet) {
            Iterator it = syncing.iterator();
            while (it.hasNext()) {
                String fileName = (String)it.next();
                while (!this.synced.contains(fileName)) {
                    if (!syncing.contains(fileName)) {
                        return false;
                    }
                    try {
                        this.synced.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ie);
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPause(long sizeInBytes) {
        if (this.mergeScheduler instanceof ConcurrentMergeScheduler && this.maxSyncPauseSeconds > 0.0) {
            long pauseTime = 1000L * sizeInBytes / 10L / 1024L / 1024L;
            long maxPauseTime = (long)(this.maxSyncPauseSeconds * 1000.0);
            if (pauseTime > maxPauseTime) {
                pauseTime = maxPauseTime;
            }
            int sleepCount = (int)(pauseTime / 100L);
            for (int i = 0; i < sleepCount; ++i) {
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    if (this.stopMerges || this.closing) {
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(long sizeInBytes, Map commitUserData) throws IOException {
        if (!$assertionsDisabled && !this.testPoint("startStartCommit")) {
            throw new AssertionError();
        }
        if (this.hitOOM) {
            throw new IllegalStateException("this writer hit an OutOfMemoryError; cannot commit");
        }
        try {
            IndexWriter indexWriter;
            long myChangeCount;
            if (this.infoStream != null) {
                this.message("startCommit(): start sizeInBytes=" + sizeInBytes);
            }
            if (sizeInBytes > 0L) {
                this.syncPause(sizeInBytes);
            }
            SegmentInfos toSync = null;
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                if (sizeInBytes > 0L && this.stopMerges) {
                    return;
                }
                this.blockAddIndexes(false);
                if (!$assertionsDisabled && this.hasExternalSegments()) {
                    throw new AssertionError();
                }
                try {
                    if (!$assertionsDisabled && this.lastCommitChangeCount > this.changeCount) {
                        throw new AssertionError();
                    }
                    if (this.changeCount == this.lastCommitChangeCount) {
                        if (this.infoStream != null) {
                            this.message("  skip startCommit(): no changes pending");
                        }
                        Object var11_7 = null;
                        this.resumeAddIndexes();
                        return;
                    }
                    if (this.infoStream != null) {
                        this.message("startCommit index=" + this.segString(this.segmentInfos) + " changeCount=" + this.changeCount);
                    }
                    this.readerPool.commit();
                    toSync = (SegmentInfos)this.segmentInfos.clone();
                    if (commitUserData != null) {
                        toSync.setUserData(commitUserData);
                    }
                    this.deleter.incRef(toSync, false);
                    myChangeCount = this.changeCount;
                    Iterator it = toSync.files(this.directory, false).iterator();
                    while (it.hasNext()) {
                        String fileName = (String)it.next();
                        if (!$assertionsDisabled && !this.directory.fileExists(fileName)) {
                            throw new AssertionError((Object)("file " + fileName + " does not exist"));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    this.resumeAddIndexes();
                    throw throwable;
                }
                Object var11_8 = null;
                this.resumeAddIndexes();
            }
            if (!$assertionsDisabled && !this.testPoint("midStartCommit")) {
                throw new AssertionError();
            }
            boolean setPending = false;
            try {
                ArrayList pending;
                do {
                    pending = new ArrayList();
                    Iterator it = toSync.files(this.directory, false).iterator();
                    while (it.hasNext()) {
                        Object var14_19;
                        String fileName = (String)it.next();
                        if (!this.startSync(fileName, pending)) continue;
                        boolean success = false;
                        try {
                            if (!$assertionsDisabled && !this.directory.fileExists(fileName)) {
                                throw new AssertionError((Object)("file '" + fileName + "' does not exist dir=" + this.directory));
                            }
                            if (this.infoStream != null) {
                                this.message("now sync " + fileName);
                            }
                            this.directory.sync(fileName);
                            success = true;
                            var14_19 = null;
                            this.finishSync(fileName, success);
                        }
                        catch (Throwable throwable) {
                            var14_19 = null;
                            this.finishSync(fileName, success);
                            throw throwable;
                        }
                    }
                } while (!this.waitForAllSynced(pending));
                if (!$assertionsDisabled && !this.testPoint("midStartCommit2")) {
                    throw new AssertionError();
                }
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    while (true) {
                        if (myChangeCount <= this.lastCommitChangeCount) {
                            if (this.infoStream == null) break;
                            this.message("sync superseded by newer infos");
                            break;
                        }
                        if (this.pendingCommit == null) {
                            if (this.segmentInfos.getGeneration() > toSync.getGeneration()) {
                                toSync.updateGeneration(this.segmentInfos);
                            }
                            boolean success = false;
                            try {
                                try {
                                    toSync.prepareCommit(this.directory);
                                    Object var16_21 = null;
                                    this.segmentInfos.updateGeneration(toSync);
                                }
                                catch (Throwable throwable) {
                                    Object var16_22 = null;
                                    this.segmentInfos.updateGeneration(toSync);
                                    throw throwable;
                                }
                                if (!$assertionsDisabled && this.pendingCommit != null) {
                                    throw new AssertionError();
                                }
                                setPending = true;
                                this.pendingCommit = toSync;
                                this.pendingCommitChangeCount = myChangeCount;
                                success = true;
                                Object var18_24 = null;
                                if (success || this.infoStream == null) break;
                                this.message("hit exception committing segments file");
                                break;
                            }
                            catch (Throwable throwable) {
                                Object var18_25 = null;
                                if (!success && this.infoStream != null) {
                                    this.message("hit exception committing segments file");
                                }
                                throw throwable;
                            }
                        }
                        this.doWait();
                    }
                }
                if (this.infoStream != null) {
                    this.message("done all syncs");
                }
                if (!$assertionsDisabled && !this.testPoint("midStartCommitSuccess")) {
                    throw new AssertionError();
                }
                Object var21_28 = null;
                indexWriter = this;
            }
            catch (Throwable throwable) {
                Object var21_29 = null;
                IndexWriter indexWriter4 = this;
                synchronized (indexWriter4) {
                    if (!setPending) {
                        this.deleter.decRef(toSync);
                    }
                }
                throw throwable;
            }
            synchronized (indexWriter) {
                if (!setPending) {
                    this.deleter.decRef(toSync);
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.handleOOM(oom, "startCommit");
        }
        if (!$assertionsDisabled && !this.testPoint("finishStartCommit")) {
            throw new AssertionError();
        }
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock(WRITE_LOCK_NAME).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(String directory) throws IOException {
        boolean bl;
        FSDirectory dir = FSDirectory.getDirectory(directory);
        try {
            bl = IndexWriter.isLocked(dir);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((Directory)dir).close();
            throw throwable;
        }
        ((Directory)dir).close();
        return bl;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock(WRITE_LOCK_NAME).release();
    }

    public void setMergedSegmentWarmer(IndexReaderWarmer warmer) {
        this.mergedSegmentWarmer = warmer;
    }

    public IndexReaderWarmer getMergedSegmentWarmer() {
        return this.mergedSegmentWarmer;
    }

    private void handleOOM(OutOfMemoryError oom, String location) {
        if (this.infoStream != null) {
            this.message("hit OutOfMemoryError inside " + location);
        }
        this.hitOOM = true;
        throw oom;
    }

    public void setAllowMinus1Position() {
        this.allowMinus1Position = true;
        this.docWriter.setAllowMinus1Position();
    }

    boolean getAllowMinus1Position() {
        return this.allowMinus1Position;
    }

    boolean testPoint(String name) {
        return true;
    }

    synchronized boolean nrtIsCurrent(SegmentInfos infos) {
        if (!infos.equals(this.segmentInfos)) {
            return false;
        }
        return !this.docWriter.anyChanges();
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    static {
        $assertionsDisabled = !IndexWriter.class.desiredAssertionStatus();
        WRITE_LOCK_TIMEOUT = 1000L;
        DEFAULT_MAX_SYNC_PAUSE_SECONDS = Constants.WINDOWS ? 10.0 : 0.0;
        MESSAGE_ID_LOCK = new Object();
        MESSAGE_ID = 0;
        defaultInfoStream = null;
    }

    public static abstract class IndexReaderWarmer {
        public abstract void warm(IndexReader var1) throws IOException;
    }

    public static final class MaxFieldLength {
        private int limit;
        private String name;
        public static final MaxFieldLength UNLIMITED = new MaxFieldLength("UNLIMITED", Integer.MAX_VALUE);
        public static final MaxFieldLength LIMITED = new MaxFieldLength("LIMITED", 10000);

        private MaxFieldLength(String name, int limit) {
            this.name = name;
            this.limit = limit;
        }

        public MaxFieldLength(int limit) {
            this("User-specified", limit);
        }

        public int getLimit() {
            return this.limit;
        }

        public String toString() {
            return this.name + ":" + this.limit;
        }
    }

    class ReaderPool {
        private final Map readerMap = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        ReaderPool() {
        }

        synchronized void clear(SegmentInfos infos) throws IOException {
            if (infos == null) {
                Iterator iter = this.readerMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry ent = iter.next();
                    ((SegmentReader)ent.getValue()).hasChanges = false;
                }
            } else {
                int numSegments = infos.size();
                for (int i = 0; i < numSegments; ++i) {
                    SegmentInfo info = infos.info(i);
                    if (!this.readerMap.containsKey(info)) continue;
                    ((SegmentReader)this.readerMap.get((Object)info)).hasChanges = false;
                }
            }
        }

        public synchronized boolean infoIsLive(SegmentInfo info) {
            int idx = IndexWriter.this.segmentInfos.indexOf(info);
            if (!$assertionsDisabled && idx == -1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && IndexWriter.this.segmentInfos.get(idx) != info) {
                throw new AssertionError();
            }
            return true;
        }

        public synchronized SegmentInfo mapToLive(SegmentInfo info) {
            int idx = IndexWriter.this.segmentInfos.indexOf(info);
            if (idx != -1) {
                info = (SegmentInfo)IndexWriter.this.segmentInfos.get(idx);
            }
            return info;
        }

        public synchronized void release(SegmentReader sr) throws IOException {
            this.release(sr, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void release(SegmentReader sr, boolean drop) throws IOException {
            block8: {
                boolean pooled = this.readerMap.containsKey(sr.getSegmentInfo());
                if (!$assertionsDisabled && !(!pooled | this.readerMap.get(sr.getSegmentInfo()) == sr)) {
                    throw new AssertionError();
                }
                sr.decRef();
                if (pooled && (drop || !IndexWriter.this.poolReaders && sr.getRefCount() == 1)) {
                    this.readerMap.remove(sr.getSegmentInfo());
                    boolean success = false;
                    try {
                        sr.close();
                        success = true;
                        Object var6_5 = null;
                        if (success || !sr.hasChanges) break block8;
                        sr.hasChanges = false;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (!success && sr.hasChanges) {
                            sr.hasChanges = false;
                            try {
                                sr.close();
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        sr.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void close() throws IOException {
            Iterator iter = this.readerMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry ent = iter.next();
                SegmentReader sr = (SegmentReader)ent.getValue();
                if (sr.hasChanges) {
                    Object var6_5;
                    if (!$assertionsDisabled && !this.infoIsLive(sr.getSegmentInfo())) {
                        throw new AssertionError();
                    }
                    sr.startCommit();
                    boolean success = false;
                    try {
                        sr.doCommit(null);
                        success = true;
                        var6_5 = null;
                        if (!success) {
                            sr.rollbackCommit();
                        }
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        if (!success) {
                            sr.rollbackCommit();
                        }
                        throw throwable;
                    }
                }
                iter.remove();
                sr.decRef();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void commit() throws IOException {
            Iterator iter = this.readerMap.entrySet().iterator();
            while (iter.hasNext()) {
                Object var6_5;
                Map.Entry ent = iter.next();
                SegmentReader sr = (SegmentReader)ent.getValue();
                if (!sr.hasChanges) continue;
                if (!$assertionsDisabled && !this.infoIsLive(sr.getSegmentInfo())) {
                    throw new AssertionError();
                }
                sr.startCommit();
                boolean success = false;
                try {
                    sr.doCommit(null);
                    success = true;
                    var6_5 = null;
                    if (success) continue;
                    sr.rollbackCommit();
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    if (!success) {
                        sr.rollbackCommit();
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized SegmentReader getReadOnlyClone(SegmentInfo info, boolean doOpenStores, int termInfosIndexDivisor) throws IOException {
            SegmentReader segmentReader;
            SegmentReader sr = this.get(info, doOpenStores, 1024, termInfosIndexDivisor);
            try {
                segmentReader = (SegmentReader)sr.clone(true);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                sr.decRef();
                throw throwable;
            }
            sr.decRef();
            return segmentReader;
        }

        public synchronized SegmentReader get(SegmentInfo info, boolean doOpenStores) throws IOException {
            return this.get(info, doOpenStores, 1024, IndexWriter.this.readerTermsIndexDivisor);
        }

        public synchronized SegmentReader get(SegmentInfo info, boolean doOpenStores, int readBufferSize, int termsIndexDivisor) throws IOException {
            SegmentReader sr;
            if (IndexWriter.this.poolReaders) {
                readBufferSize = 1024;
            }
            if ((sr = (SegmentReader)this.readerMap.get(info)) == null) {
                sr = SegmentReader.get(info, readBufferSize, doOpenStores, termsIndexDivisor);
                if (info.dir == IndexWriter.this.directory) {
                    this.readerMap.put(info, sr);
                }
            } else {
                if (doOpenStores) {
                    sr.openDocStores();
                }
                if (termsIndexDivisor != -1 && !sr.termsIndexLoaded()) {
                    sr.loadTermsIndex(termsIndexDivisor);
                }
            }
            if (info.dir == IndexWriter.this.directory) {
                sr.incRef();
            }
            return sr;
        }

        public synchronized SegmentReader getIfExists(SegmentInfo info) throws IOException {
            SegmentReader sr = (SegmentReader)this.readerMap.get(info);
            if (sr != null) {
                sr.incRef();
            }
            return sr;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$IndexWriter == null ? (class$org$apache$lucene$index$IndexWriter = IndexWriter.class$("org.apache.lucene.index.IndexWriter")) : class$org$apache$lucene$index$IndexWriter).desiredAssertionStatus();
        }
    }
}

