/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ListenerSet;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.JGroupsNotifier;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Tree;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTransaction;

public class WikittyServiceNotifier
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceNotifier.class);
    public static final String WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION = "wikitty.service.event.jgroupschannelname";
    public static final String WIKITTY_EVENT_PROPAGATE_OPTION = "wikitty.service.event.propagateEvent";
    protected boolean propagateCache = false;
    protected WikittyService ws;
    protected ListenerSet<WikittyServiceListener> allWikittyServiceListeners;
    protected ListenerSet<WikittyServiceListener> localWikittyServiceListeners;
    protected ListenerSet<WikittyServiceListener> remoteWikittyServiceListeners;
    protected WikittyServiceListener notifier;

    public WikittyServiceNotifier(WikittyService ws) {
        this(ws, null);
    }

    public WikittyServiceNotifier(WikittyService ws, Properties props) {
        this.ws = ws;
        this.allWikittyServiceListeners = new ListenerSet();
        this.localWikittyServiceListeners = new ListenerSet();
        this.remoteWikittyServiceListeners = new ListenerSet();
        this.addJGroupNotifier(props);
    }

    protected void addJGroupNotifier(Properties props) {
        if (props != null) {
            String jgroupChannel;
            String propagateCacheOption = props.getProperty(WIKITTY_EVENT_PROPAGATE_OPTION, "false");
            this.propagateCache = "true".equalsIgnoreCase(propagateCacheOption);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set propagateCache option to " + this.propagateCache));
            }
            if (!StringUtils.isBlank((String)(jgroupChannel = props.getProperty(WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION)))) {
                this.notifier = new JGroupsNotifier(this, jgroupChannel, this.propagateCache);
                this.addWikittyServiceListener(this.notifier, WikittyService.ServiceListenerType.ALL);
            } else {
                if (this.propagateCache) {
                    throw new IllegalArgumentException("Can't use propagate cache without a valid jgroups channel name !!!");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JGroup synchronisation channel not used ");
                }
            }
        }
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        switch (type) {
            case ALL: {
                this.allWikittyServiceListeners.add((Object)listener);
                break;
            }
            case LOCAL: {
                this.localWikittyServiceListeners.add((Object)listener);
                break;
            }
            case REMOTE: {
                this.remoteWikittyServiceListeners.add((Object)listener);
            }
        }
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        switch (type) {
            case ALL: {
                this.allWikittyServiceListeners.remove((Object)listener);
                break;
            }
            case LOCAL: {
                this.localWikittyServiceListeners.remove((Object)listener);
                break;
            }
            case REMOTE: {
                this.remoteWikittyServiceListeners.remove((Object)listener);
            }
        }
    }

    @Override
    public String login(String login, String password) {
        return this.ws.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        this.ws.logout(securityToken);
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return this.ws.canWrite(securityToken, wikitty);
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return this.ws.canDelete(securityToken, wikittyId);
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return this.ws.canRead(securityToken, wikittyId);
    }

    @Override
    public void clear(String securityToken) {
        this.ws.clear(securityToken);
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        UpdateResponse updateResponse = this.ws.store(securityToken, wikitty);
        updateResponse.update(wikitty);
        this.firePutWikitty(wikitty);
        return updateResponse;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        UpdateResponse updateResponse = this.ws.store(securityToken, wikitties);
        for (Wikitty wikitty : wikitties) {
            updateResponse.update(wikitty);
        }
        this.firePutWikitty(wikitties.toArray(new Wikitty[wikitties.size()]));
        return updateResponse;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        UpdateResponse updateResponse = this.ws.store(securityToken, wikitties, force);
        for (Wikitty wikitty : wikitties) {
            updateResponse.update(wikitty);
        }
        this.firePutWikitty(wikitties.toArray(new Wikitty[wikitties.size()]));
        return updateResponse;
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        UpdateResponse updateResponse = this.ws.store(securityToken, transaction, wikitties, force);
        for (Wikitty wikitty : wikitties) {
            updateResponse.update(wikitty);
        }
        this.firePutWikitty(wikitties.toArray(new Wikitty[wikitties.size()]));
        return updateResponse;
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.ws.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.ws.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        UpdateResponse updateResponse = this.ws.storeExtension(securityToken, ext);
        this.firePutExtension(ext);
        return updateResponse;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        UpdateResponse updateResponse = this.ws.storeExtension(securityToken, exts);
        this.firePutExtension(exts.toArray(new WikittyExtension[exts.size()]));
        return updateResponse;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        UpdateResponse updateResponse = this.ws.storeExtension(securityToken, transaction, exts);
        return updateResponse;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return this.ws.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        return this.ws.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, transaction, name);
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        return this.ws.restore(securityToken, id);
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        return this.ws.restore(securityToken, ids);
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        return this.ws.restore(securityToken, transaction, ids);
    }

    @Override
    public void delete(String securityToken, String id) {
        this.ws.delete(securityToken, id);
        this.fireRemoveWikitty(id);
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        this.ws.delete(securityToken, ids);
        this.fireRemoveWikitty(ids.toArray(new String[ids.size()]));
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        return this.ws.findAllByCriteria(securityToken, criteria);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return this.ws.findAllByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        return this.ws.findByCriteria(securityToken, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return this.ws.findByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public void addLabel(String securityToken, String wikittyId, String label) {
        this.ws.addLabel(securityToken, wikittyId, label);
    }

    @Override
    public PagedResult<String> findAllByLabel(String securityToken, String label, int firstIndex, int endIndex) {
        return this.ws.findAllByLabel(securityToken, label, firstIndex, endIndex);
    }

    @Override
    public Wikitty findByLabel(String securityToken, String label) {
        return this.ws.findByLabel(securityToken, label);
    }

    @Override
    public Set<String> findAllAppliedLabels(String securityToken, String wikittyId) {
        return this.ws.findAllAppliedLabels(securityToken, wikittyId);
    }

    @Override
    public Tree restoreTree(String securityToken, String wikittyId) {
        return this.ws.restoreTree(securityToken, wikittyId);
    }

    @Override
    public List<String> deleteTree(String securityToken, String wikittyId) {
        List<String> result = this.ws.deleteTree(securityToken, wikittyId);
        this.fireRemoveWikitty(result.toArray(new String[result.size()]));
        return result;
    }

    @Override
    public Map.Entry<TreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public Map<TreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        return this.ws.restoreVersion(securityToken, wikittyId, version);
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        return this.ws.syncEngin(securityToken);
    }

    protected void firePutWikitty(Wikitty ... ws) {
        WikittyServiceEvent event = new WikittyServiceEvent(ws);
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Set<String>> idsExtension = new HashMap<String, Set<String>>();
        HashMap<String, String> idsVersion = new HashMap<String, String>();
        for (Wikitty w : ws) {
            ids.add(w.getId());
            HashSet<String> extension = new HashSet<String>();
            extension.addAll(w.getExtensionNames());
            idsExtension.put(w.getId(), extension);
            idsVersion.put(w.getId(), w.getVersion());
        }
        event.setIds(ids);
        event.setIdExtensions(idsExtension);
        event.setIdVersions(idsVersion);
        this.firePutWikitty(event);
    }

    protected void fireRemoveWikitty(String ... wikittyIds) {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws);
        HashSet<String> ids = new HashSet<String>();
        for (String wikittyId : wikittyIds) {
            ids.add(wikittyId);
        }
        event.setIds(ids);
        this.fireRemoveWikitty(event);
    }

    protected void fireClearWikitty() {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws);
        this.fireClearWikitty(event);
    }

    protected void firePutExtension(WikittyExtension ... exts) {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws);
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Set<String>> idsExtension = new HashMap<String, Set<String>>();
        for (WikittyExtension ext : exts) {
            ids.add(ext.getId());
            HashSet<String> extension = new HashSet<String>();
            extension.add(ext.getName());
            extension.add(ext.requires);
            idsExtension.put(ext.getId(), extension);
        }
        event.setIds(ids);
        event.setIdExtensions(idsExtension);
        this.firePutExtension(event);
    }

    protected void fireRemoveExtension(WikittyExtension ... exts) {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws);
        HashSet<String> ids = new HashSet<String>();
        for (WikittyExtension ext : exts) {
            ids.add(ext.getId());
        }
        event.setIds(ids);
        this.fireRemoveExtension(event);
    }

    protected void fireClearExtension() {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws);
        this.fireClearExtension(event);
    }

    protected void firePutWikitty(final WikittyServiceEvent event) {
        Thread eventThread = new Thread("wikitty-event-thread"){

            @Override
            public void run() {
                for (WikittyServiceListener l : WikittyServiceNotifier.this.allWikittyServiceListeners) {
                    l.putWikitty(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.remoteWikittyServiceListeners) {
                        l.putWikitty(event);
                    }
                } else {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.localWikittyServiceListeners) {
                        l.putWikitty(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    protected void fireRemoveWikitty(final WikittyServiceEvent event) {
        Thread eventThread = new Thread("wikitty-event-thread"){

            @Override
            public void run() {
                for (WikittyServiceListener l : WikittyServiceNotifier.this.allWikittyServiceListeners) {
                    l.removeWikitty(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.remoteWikittyServiceListeners) {
                        l.removeWikitty(event);
                    }
                } else {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.localWikittyServiceListeners) {
                        l.removeWikitty(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    protected void fireClearWikitty(final WikittyServiceEvent event) {
        Thread eventThread = new Thread("wikitty-event-thread"){

            @Override
            public void run() {
                for (WikittyServiceListener l : WikittyServiceNotifier.this.allWikittyServiceListeners) {
                    l.clearWikitty(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.remoteWikittyServiceListeners) {
                        l.clearWikitty(event);
                    }
                } else {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.localWikittyServiceListeners) {
                        l.clearWikitty(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    protected void firePutExtension(final WikittyServiceEvent event) {
        Thread eventThread = new Thread("wikitty-event-thread"){

            @Override
            public void run() {
                for (WikittyServiceListener l : WikittyServiceNotifier.this.allWikittyServiceListeners) {
                    l.putExtension(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.remoteWikittyServiceListeners) {
                        l.putExtension(event);
                    }
                } else {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.localWikittyServiceListeners) {
                        l.putExtension(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    protected void fireRemoveExtension(final WikittyServiceEvent event) {
        Thread eventThread = new Thread("wikitty-event-thread"){

            @Override
            public void run() {
                for (WikittyServiceListener l : WikittyServiceNotifier.this.allWikittyServiceListeners) {
                    l.removeExtension(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.remoteWikittyServiceListeners) {
                        l.removeExtension(event);
                    }
                } else {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.localWikittyServiceListeners) {
                        l.removeExtension(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    protected void fireClearExtension(final WikittyServiceEvent event) {
        Thread eventThread = new Thread("wikitty-event-thread"){

            @Override
            public void run() {
                for (WikittyServiceListener l : WikittyServiceNotifier.this.allWikittyServiceListeners) {
                    l.clearExtension(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.remoteWikittyServiceListeners) {
                        l.clearExtension(event);
                    }
                } else {
                    for (WikittyServiceListener l : WikittyServiceNotifier.this.localWikittyServiceListeners) {
                        l.clearExtension(event);
                    }
                }
            }
        };
        eventThread.start();
    }
}

