/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class MultiRequest
extends Request {
    private final Rsp[] responses;
    protected final int expected_mbrs;
    int num_received;
    int num_not_received;
    int num_suspected;

    public MultiRequest(Message m, RequestCorrelator corr, Collection<Address> mbrs, RequestOptions options, int expected_mbrs) {
        super(m, corr, null, options);
        this.expected_mbrs = expected_mbrs;
        this.responses = new Rsp[mbrs.size()];
        this.setTargets(mbrs);
    }

    public MultiRequest(Message m, RequestCorrelator corr, Address target, RequestOptions options, int expected_mbrs) {
        super(m, corr, null, options);
        this.expected_mbrs = expected_mbrs;
        this.responses = new Rsp[1];
        this.setTarget(target);
    }

    public MultiRequest(Message m, Transport transport, Collection<Address> mbrs, RequestOptions options, int expected_mbrs) {
        super(m, null, transport, options);
        this.expected_mbrs = expected_mbrs;
        this.responses = new Rsp[1];
        this.setTargets(mbrs);
    }

    void setTarget(Address mbr) {
        this.responses[0] = new Rsp(mbr);
        ++this.num_not_received;
    }

    void setTargets(Collection<Address> mbrs) {
        int index = 0;
        for (Address mbr : mbrs) {
            this.responses[index++] = new Rsp(mbr);
            ++this.num_not_received;
        }
    }

    public boolean getAnycasting() {
        return this.options.getAnycasting();
    }

    public void setAnycasting(boolean anycasting) {
        this.options.setAnycasting(anycasting);
    }

    @Override
    public void sendRequest() throws Exception {
        ArrayList<Address> targets = null;
        targets = new ArrayList<Address>(this.responses.length);
        for (Rsp rsp : this.responses) {
            targets.add(rsp.getSender());
        }
        this.sendRequest(targets, this.req_id, this.options);
    }

    Rsp findResponse(Address target) {
        for (Rsp rsp : this.responses) {
            if (rsp == null || !target.equals(rsp.getSender())) continue;
            return rsp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender) {
        if (this.done) {
            return;
        }
        Rsp rsp = this.findResponse(sender);
        if (rsp == null) {
            return;
        }
        RspFilter rsp_filter = this.options.getRspFilter();
        boolean responseReceived = false;
        if (!rsp.wasReceived()) {
            responseReceived = rsp_filter == null || rsp_filter.isAcceptable(response_value, sender);
            if (responseReceived) {
                rsp.setValue(response_value);
            }
            rsp.setReceived(responseReceived);
        }
        this.lock.lock();
        try {
            if (responseReceived) {
                ++this.num_received;
            }
            boolean bl = rsp_filter == null ? this.responsesComplete() : (this.done = !rsp_filter.needMoreResponses());
            if (responseReceived || this.done) {
                this.completed.signalAll();
            }
            if (this.done && this.corr != null) {
                this.corr.done(this.req_id);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (responseReceived || this.done) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        boolean changed = false;
        Rsp rsp = this.findResponse(suspected_member);
        if (rsp != null && rsp.setSuspected(true)) {
            rsp.setValue(null);
            changed = true;
            this.lock.lock();
            try {
                ++this.num_suspected;
                this.completed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        Vector<Address> mbrs;
        Vector<Address> vector = mbrs = new_view != null ? new_view.getMembers() : null;
        if (mbrs == null) {
            return;
        }
        boolean changed = false;
        if (this.responses == null || this.responses.length == 0) {
            return;
        }
        this.lock.lock();
        try {
            for (Rsp rsp : this.responses) {
                Address mbr = rsp.getSender();
                if (mbrs.contains(mbr)) continue;
                rsp.setValue(null);
                if (!rsp.setSuspected(true)) continue;
                ++this.num_suspected;
                changed = true;
            }
            if (changed) {
                this.completed.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    public RspList getResults() {
        RspList list = new RspList();
        for (Rsp rsp : this.responses) {
            list.put(rsp.getSender(), rsp);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
        }
        finally {
            this.lock.unlock();
        }
        return this.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        this.lock.lock();
        try {
            if (this.responses.length != 0) {
                ret.append(", entries:\n");
                for (Rsp rsp : this.responses) {
                    Address mbr = rsp.getSender();
                    ret.append(mbr).append(": ").append(rsp).append("\n");
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret.toString();
    }

    private static int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private void sendRequest(List<Address> targetMembers, long requestId, RequestOptions options) throws Exception {
        try {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("sending request (id=").append(this.req_id).append(')'));
            }
            if (this.corr != null) {
                this.corr.sendRequest(requestId, targetMembers, this.request_msg, options.getMode() == 6 ? null : this, options);
            } else if (options.getAnycasting()) {
                for (Address mbr : targetMembers) {
                    Message copy = this.request_msg.copy(true);
                    copy.setDest(mbr);
                    this.transport.send(copy);
                }
            } else {
                this.transport.send(this.request_msg);
            }
        }
        catch (Exception ex) {
            if (this.corr != null) {
                this.corr.done(requestId);
            }
            throw ex;
        }
    }

    @Override
    protected boolean responsesComplete() {
        if (this.done) {
            return true;
        }
        int num_total = this.responses.length;
        switch (this.options.getMode()) {
            case 1: {
                if (this.num_received > 0) {
                    return true;
                }
                if (this.num_suspected < num_total) break;
                return true;
            }
            case 2: {
                return this.num_received + this.num_suspected >= num_total;
            }
            case 3: {
                int majority = MultiRequest.determineMajority(num_total);
                if (this.num_received + this.num_suspected < majority) break;
                return true;
            }
            case 4: {
                int majority = MultiRequest.determineMajority(num_total);
                if (this.num_received < majority) break;
                return true;
            }
            case 5: {
                if (this.expected_mbrs >= num_total) {
                    return this.responsesComplete();
                }
                return this.num_received >= this.expected_mbrs || this.num_received + this.num_not_received < this.expected_mbrs && this.num_received + this.num_suspected >= this.expected_mbrs;
            }
            case 6: {
                return true;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("rsp_mode " + this.options.getMode() + " unknown !");
            }
        }
        return false;
    }
}

