package com.jurismarches.vradi.aspect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.codehaus.aspectwerkz.annotation.AfterFinally;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

/**
 * VradiAspect.
 *
 * @author $Author: schorlet $
 * @version $Revision: 547 $ $Date: 2010-02-23 11:43:13 +0100 (mar., 23 févr. 2010) $
 * @since 19 févr. 2010 05:29:32
 */
@Aspect("perJVM")
public class ServiceAspect {
    @Expression("execution(* com.jurismarches.vradi.services..*(..))"
            + " && !execution(* com.jurismarches.vradi.services.dto..*(..))"
            + " && !execution(@Test * com.jurismarches.vradi.services.*Test.*(..))")
    Pointcut executeMethod;
    
    @Expression("execution(* com.jurismarches.vradi.services.VradiStorageServiceImpl.*(..))")
    Pointcut statMethod;

    TraceLocal traceLocal = new TraceLocal();
    static List<ServiceAspect> instances = new ArrayList<ServiceAspect>();

    public ServiceAspect() {
        instances.add(this);
    }

    static class TraceLocal extends ThreadLocal<VradiTrace> {
        @Override
        protected VradiTrace initialValue() {
            return new VradiTrace(Thread.currentThread().getName());
        }
    }

    protected VradiTrace getTrace() {
        return traceLocal.get();
    }

    @Before("executeMethod || statMethod")
    public void traceBeforeExecute(JoinPoint jp) {
        getTrace().traceBefore();
    }

    @AfterFinally("executeMethod")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature) jp.getSignature()).getMethod();
        getTrace().traceAfterCall(method);
    }
    
    @AfterFinally("statMethod")
    public void statAfterExecute(JoinPoint jp) {
        traceAfterExecute(jp);
        getTrace().printStatisticAndClear();
    }
}
