/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.entities.XmlStreamBean;
import org.sharengo.wikitty.WikittyExtension;

import java.util.HashSet;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiXmlStreamDTO extends XmlStreamBean implements VradiDTO<XmlStream> {

    private static final long serialVersionUID = 1L;

    protected WikittyExtension formType;

    public VradiXmlStreamDTO() {
        XmlStream$xmlFieldBinding = new HashSet<String>();
    }

    @Override
    public void fromWikitty(XmlStream wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setName(wikitty.getName());
            setUrl(wikitty.getUrl());
            XmlStream$xmlFieldBinding.clear();
            addAllXmlFieldBinding(wikitty.getXmlFieldBinding());
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setName(null);
        setUrl(null);
        setFormType(null);
        clearXmlFieldBinding();
    }

    @Override
    public void toWikitty(XmlStream wikitty) {

        wikitty.setName(getName());
        wikitty.setUrl(getUrl());
        wikitty.clearXmlFieldBinding();
        for (String xmlFieldBinding : getXmlFieldBinding()) {
            wikitty.addXmlFieldBinding(xmlFieldBinding);
        }
    }

    public WikittyExtension getFormType() {
        return formType;
    }

    public void setFormType(WikittyExtension formType) {
        Object oldValue = this.formType;
        this.formType = formType;
        propertyChange.firePropertyChange("formType", oldValue, formType);
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void addAllXmlFieldBinding(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                XmlStream$xmlFieldBinding.add(s);
            }
        }
        propertyChange.firePropertyChange("xmlFieldBinding", null, XmlStream$xmlFieldBinding);
    }
}