/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.services;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author letellier
 */
public class ServiceHelper {

    static {
        // make solr quiet (must be done before any instanciation
        Logger.getLogger("org.apache.solr").setLevel(Level.WARNING);
    }

    /**
     * single instance of storage service
     */
    protected static VradiStorageService vradiStorageService = null;
    /**
     * single instance of xml service
     */
    protected static XmlStreamService xmlStreamService = null;

    public synchronized static VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public synchronized static XmlStreamService getXmlStreamService() {
        if (xmlStreamService == null) {
            xmlStreamService = new XmlStreamServiceImpl();
        }
        return xmlStreamService;
    }
}
