package com.jurismarches.vradi.entities;

import static org.nuiton.i18n.I18n._;

/**
 * @author morin
 *         Date: 24 nov. 2009
 *         Time: 15:29:47
 */
public enum SendingStatus {
    TO_SEND(0, _("vradi.email.status.toSend")),
    SENT(1, _("vradi.email.status.sent")),
    WAITING_RECPETION_PROOF(2, _("vradi.email.status.waitingReceptionProof")),
    RECEIVED(3, _("vradi.email.status.received")),
    ERROR(4, _("vradi.email.status.error"));

    private int status;

    private String label;

    SendingStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    static public SendingStatus get(int status) {
        switch (status) {
            case 0:
                return TO_SEND;
            case 1:
                return SENT;
            case 2:
                return WAITING_RECPETION_PROOF;
            case 3:
                return RECEIVED;
            default:
                return ERROR;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String toString() {
        return label;
    }

}
