/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import jidefx.scene.control.field.verifier.PatternVerifier;

public abstract class TemporalPatternVerifier
extends PatternVerifier<Temporal>
implements PatternVerifier.Range<Long> {
    protected TemporalField _temporalField;
    protected TemporalUnit _temporalUnit;
    protected Temporal _value;
    private final long _min;
    private final long _max;
    private boolean _minMaxSet = true;

    public TemporalPatternVerifier(TemporalField temporalField, TemporalUnit temporalUnit) {
        this(temporalField, temporalUnit, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this._minMaxSet = false;
    }

    TemporalPatternVerifier(TemporalField temporalField, TemporalUnit temporalUnit, long min, long max) {
        this._temporalField = temporalField;
        this._temporalUnit = temporalUnit;
        this._min = min;
        this._max = max;
        this._minMaxSet = this._max != Integer.MAX_VALUE && this._min != Integer.MIN_VALUE;
        this._value = LocalDate.now();
    }

    public TemporalField getTemporalField() {
        return this._temporalField;
    }

    @Override
    public Long getMin() {
        return !this._minMaxSet && this._value != null ? this._value.range(this._temporalField).getLargestMinimum() : this._min;
    }

    @Override
    public Long getMax() {
        return !this._minMaxSet && this._value != null ? this._value.range(this._temporalField).getSmallestMaximum() : this._max;
    }
}

