/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.text.NumberFormat;
import java.text.ParseException;
import jidefx.scene.control.field.verifier.RangePatternVerifier;
import jidefx.utils.CommonUtils;

public class IntegerRangePatternVerifier
extends RangePatternVerifier<Integer> {
    public IntegerRangePatternVerifier(int min, int max) {
        super(min, max);
    }

    public IntegerRangePatternVerifier(int min, int max, boolean fixedLength) {
        super(min, max, fixedLength);
    }

    @Override
    public String format(Integer value) {
        if (value == null) {
            return "";
        }
        NumberFormat format = NumberFormat.getInstance();
        if (this._maxLength != -1) {
            format.setMaximumIntegerDigits(this.getMaxLength());
            format.setMinimumIntegerDigits(this.getMinLength());
        }
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        return format.format(value);
    }

    @Override
    public Integer parse(String text) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumIntegerDigits(this.getMaxLength());
        format.setMinimumIntegerDigits(this.getMinLength());
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        try {
            format.parse(text).intValue();
            return Integer.parseInt(text);
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getLocalizedMessage());
        }
    }

    @Override
    public Integer getNextPage(Integer current, boolean restart) {
        int value = current != null && current + 10 < (Integer)this.getMax() ? current + 10 : (restart ? ((Integer)this.getMin()).intValue() : ((Integer)this.getMax()).intValue());
        return value;
    }

    @Override
    public Integer getPreviousPage(Integer current, boolean restart) {
        int value = current != null && current - 10 > (Integer)this.getMin() ? current - 10 : (restart ? ((Integer)this.getMax()).intValue() : ((Integer)this.getMin()).intValue());
        return value;
    }

    @Override
    public Integer getHome(Integer current) {
        return (Integer)this.getMin();
    }

    @Override
    public Integer getEnd(Integer current) {
        return (Integer)this.getMax();
    }

    @Override
    public Integer getNextValue(Integer current, boolean restart) {
        int value = current != null && current < (Integer)this.getMax() ? current + 1 : (restart ? ((Integer)this.getMin()).intValue() : ((Integer)this.getMax()).intValue());
        Boolean valid = this.call(this.format(value));
        return valid != false ? value : this.getNextValue(value, true);
    }

    @Override
    public Integer getPreviousValue(Integer current, boolean restart) {
        int value = current != null && current > (Integer)this.getMin() ? current - 1 : (restart ? ((Integer)this.getMax()).intValue() : ((Integer)this.getMin()).intValue());
        Boolean valid = this.call(this.format(value));
        return valid != false ? value : this.getPreviousValue(value, true);
    }

    public Boolean call(String text) {
        if (text.length() > this.getMaxLength()) {
            return false;
        }
        try {
            int i = this.parse(text);
            if (i >= (Integer)this.getMin() && i <= (Integer)this.getMax()) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            CommonUtils.ignoreException((Exception)e);
        }
        return false;
    }
}

