/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.utils.PredefinedShapes;

public class LabeledTextField
extends DecorationPane {
    private static final String STYLE_CLASS_DEFAULT = "labeled-text-field";
    private static final String STYLE_CLASS_LABEL_BUTTON = "label-button";
    private static final String STYLE_CLASS_CLEAR_BUTTON = "clear-button";
    private static final String STYLE_CLASS_MESSAGE = "message";
    private TextField _textField;
    private Button _clearButton;
    private Button _labelButton;
    private Tooltip _tooltip;
    private Timeline _tooltipHideTimeline = null;
    private Node _clearIcon;
    private Node _magnifyIcon;

    public LabeledTextField() {
        super((Parent)new TextField());
    }

    protected void initializeChildren() {
        super.initializeChildren();
        this._textField = (TextField)this.getContent();
        this._clearButton = new Button();
        this._clearButton.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_CLEAR_BUTTON, "no-background-button"});
        this._clearButton.setVisible(false);
        this._clearButton.setGraphic((Node)PredefinedShapes.getInstance().createClearIcon(12.0));
        this._clearButton.setPrefSize(12.0, 12.0);
        this._clearButton.setMinSize(12.0, 12.0);
        this._clearButton.setMaxSize(12.0, 12.0);
        this._labelButton = new Button();
        this._labelButton.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_LABEL_BUTTON, "no-background-button"});
        this._labelButton.setVisible(true);
        this._labelButton.setPrefSize(12.0, 12.0);
        this._labelButton.setMinSize(12.0, 12.0);
        this._labelButton.setMaxSize(12.0, 12.0);
        DecorationUtils.install((Node)this._textField, (Decorator)new Decorator((Node)this._clearButton, Pos.CENTER_RIGHT, new Point2D(-100.0, 0.0)));
        DecorationUtils.install((Node)this._textField, (Decorator)new Decorator((Node)this._labelButton, Pos.CENTER_LEFT, new Point2D(80.0, 0.0)));
        this._tooltip = new Tooltip();
        this._tooltip.setAutoHide(true);
        this._tooltip.setOpacity(0.8);
    }

    protected void registerListeners() {
        super.registerListeners();
        final TextField textField = this.getTextField();
        final Button clearButton = this.getClearButton();
        clearButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                textField.setText("");
                textField.requestFocus();
            }
        });
        textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                clearButton.setVisible(!textField.getText().isEmpty());
            }
        });
    }

    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
        this.getTooltip().getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_MESSAGE});
    }

    public TextField getTextField() {
        return this._textField;
    }

    public Button getClearButton() {
        return this._clearButton;
    }

    public Button getLabelButton() {
        return this._labelButton;
    }

    private Tooltip getTooltip() {
        return this._tooltip;
    }

    public StringProperty promptTextProperty() {
        return this.getTextField().promptTextProperty();
    }

    public void setPromptText(String promptText) {
        this.getTextField().setPromptText(promptText);
    }

    public String getPromptText() {
        return this.getTextField().getPromptText();
    }

    public StringProperty textProperty() {
        return this.getTextField().textProperty();
    }

    public void setText(String text) {
        this.getTextField().setText(text);
    }

    public void clearText() {
        this.getTextField().clear();
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public StringProperty labelProperty() {
        return this.getLabelButton().textProperty();
    }

    public void setLabel(String text) {
        this.getLabelButton().setText(text);
    }

    public String getLabel() {
        return this.getLabelButton().getText();
    }

    public ObjectProperty<Node> graphicsProperty() {
        return this.getLabelButton().graphicProperty();
    }

    public void setGraphics(Node graphics) {
        this.getLabelButton().setGraphic(graphics);
    }

    public Node getGraphics() {
        return this.getLabelButton().getGraphic();
    }

    public BooleanProperty editableProperty() {
        return this.getTextField().editableProperty();
    }

    public void setEditable(boolean editable) {
        this.getTextField().setEditable(editable);
    }

    public boolean isEditable() {
        return this.getTextField().isEditable();
    }

    protected void showMessage(String message) {
        this.getTooltip().setText(message);
        if (this._tooltipHideTimeline != null) {
            this._tooltipHideTimeline.stop();
        }
        if (message != null) {
            TextField textField = this.getTextField();
            Point2D toolTipPos = textField.localToScene(0.0, textField.getLayoutBounds().getHeight() + 2.0);
            double x = toolTipPos.getX() + textField.getScene().getX() + textField.getScene().getWindow().getX();
            double y = toolTipPos.getY() + textField.getScene().getY() + textField.getScene().getWindow().getY();
            this.getTooltip().show((Node)textField, x, y);
            this._tooltipHideTimeline = new Timeline();
            this._tooltipHideTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.seconds((double)2.0), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    LabeledTextField.this._tooltip.hide();
                    LabeledTextField.this._tooltip.setText(null);
                }
            }, new KeyValue[0]));
            this._tooltipHideTimeline.play();
        } else {
            this.clearMessage();
        }
    }

    public void clearMessage() {
        this.getTooltip().hide();
        this.getTooltip().setText("");
    }

    protected double computePrefHeight(double width) {
        return this.getTextField().prefHeight(width);
    }

    protected double computeMinHeight(double width) {
        return this.getTextField().prefHeight(width);
    }

    protected double computeMaxHeight(double width) {
        return this.getTextField().maxHeight(width);
    }

    public Node getClearIcon() {
        return this._clearIcon;
    }

    private void setClearIcon(Node clearIcon) {
        this._clearIcon = clearIcon;
    }

    public Node getMagnifyIcon() {
        return this._magnifyIcon;
    }

    private void setMagnifyIcon(Node magnifyIcon) {
        this._magnifyIcon = magnifyIcon;
    }
}

