/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.text.Font;
import javafx.util.Callback;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.FontPopupContent;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.verifier.FractionDigitsPatternVerifier;
import jidefx.scene.control.field.verifier.IntegerDigitsPatternVerifier;
import jidefx.scene.control.field.verifier.StringValuesPatternVerifier;
import jidefx.utils.FontUtils;
import jidefx.utils.converter.javafx.FontConverter;

public class FontField
extends PopupField<Font> {
    private static final String STYLE_CLASS_DEFAULT = "font-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new FontConverter().toStringConverter());
        this.getPatternVerifiers().put((Object)"family", (Object)new StringValuesPatternVerifier<Font>(){

            @Override
            protected List<String> createValues() {
                return Font.getFamilies();
            }

            @Override
            public String toTargetValue(Font fieldValue) {
                return fieldValue.getFamily();
            }

            @Override
            public Font fromTargetValue(Font previousFieldValue, String value) {
                return previousFieldValue != null ? FontUtils.createFont((String)value, (String)previousFieldValue.getStyle(), (double)previousFieldValue.getSize()) : FontUtils.createFont((String)value, null, (double)10.0);
            }
        });
        final StringValuesPatternVerifier<Font> verifier = new StringValuesPatternVerifier<Font>(){

            @Override
            protected List<String> createValues() {
                String family = FontField.this.getGroupText(0);
                return FontUtils.getSupportedFontStyles((String)family, (double)10.0);
            }

            @Override
            public String toTargetValue(Font fieldValue) {
                return fieldValue.getStyle();
            }

            @Override
            public Font fromTargetValue(Font previousFieldValue, String value) {
                return previousFieldValue != null ? FontUtils.createFont((String)previousFieldValue.getFamily(), (String)value, (double)previousFieldValue.getSize()) : FontUtils.createFont(null, (String)value, (double)10.0);
            }
        };
        this.getPatternVerifiers().put((Object)"style", (Object)verifier);
        this.valueProperty().addListener((ChangeListener)new ChangeListener<Font>(){

            public void changed(ObservableValue<? extends Font> observable, Font oldValue, Font newValue) {
                verifier.invalidate();
            }
        });
        this.getPatternVerifiers().put((Object)"integer", (Object)new IntegerDigitsPatternVerifier<Font>(0, 999){

            @Override
            public Number toTargetValue(Font fieldValue) {
                return fieldValue.getSize();
            }

            @Override
            public Font fromTargetValue(Font previousFieldValue, Number value) {
                double size = value.doubleValue();
                return previousFieldValue != null ? FontUtils.createFont((String)previousFieldValue.getFamily(), (String)previousFieldValue.getStyle(), (double)size) : FontUtils.createFont(null, null, (double)size);
            }
        });
        this.getPatternVerifiers().put((Object)"fraction", (Object)new FractionDigitsPatternVerifier<Font>(1){

            @Override
            public Number toTargetValue(Font fieldValue) {
                return fieldValue.getSize();
            }

            @Override
            public Font fromTargetValue(Font previousFieldValue, Number value) {
                double size = value.doubleValue();
                return previousFieldValue != null ? FontUtils.createFont((String)previousFieldValue.getFamily(), (String)previousFieldValue.getStyle(), (double)size) : FontUtils.createFont(null, null, (double)size);
            }
        });
        this.setPattern("family, style, integer.fraction");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Font, PopupContent<Font>>(){

            public PopupContent<Font> call(Font param) {
                return new FontPopupContent((Font)FontField.this.getValue());
            }
        });
    }
}

