/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import javafx.util.StringConverter;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;

public class DoubleField
extends FormattedTextField<Double> {
    private static final String STYLE_CLASS_DEFAULT = "double-field";

    public DoubleField() {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double min, double max) {
        this.getPatternVerifiers().put((Object)"double", (Object)new NumberValuePatternVerifier<Double>((Number)min, (Number)max){

            @Override
            public Double toTargetValue(Double fieldValue) {
                return fieldValue;
            }

            @Override
            public Double fromTargetValue(Double previousFieldValue, Number value) {
                return value.doubleValue();
            }
        });
        this.setPattern("double");
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setSpinnersVisible(true);
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new StringConverter<Double>(){

            public String toString(Double o) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            public Double fromString(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        });
    }
}

