/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.ColorPopupContent;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.verifier.HexRangePatternVerifier;
import jidefx.scene.control.field.verifier.IntegerRangePatternVerifier;
import jidefx.utils.converter.javafx.HexColorConverter;
import jidefx.utils.converter.javafx.RgbColorConverter;

public class ColorField
extends PopupField<Color> {
    private ObjectProperty<ColorFormat> _colorFormatProperty;
    private Decorator<Node> _colorRectDecorator;
    private BooleanProperty _colorRectVisibleProperty;
    private static final String STYLE_CLASS_DEFAULT = "color-field";

    public ColorField() {
        this(ColorFormat.RGB);
    }

    public ColorField(ColorFormat colorFormat) {
        this.setColorFormat(colorFormat);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    public ObjectProperty<ColorFormat> colorFormatProperty() {
        if (this._colorFormatProperty == null) {
            this._colorFormatProperty = new SimpleObjectProperty<ColorFormat>((Object)this, "colorFormat"){

                protected void invalidated() {
                    super.invalidated();
                    switch ((ColorFormat)((Object)this.get())) {
                        case RGB: {
                            ColorField.this.setStringConverter(new RgbColorConverter().toStringConverter());
                            ColorField.this.getPatternVerifiers().put((Object)"r", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.getPatternVerifiers().put((Object)"g", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.getPatternVerifiers().put((Object)"b", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.setPattern("r, g, b");
                            break;
                        }
                        case RGBA: {
                            ColorField.this.setStringConverter(new RgbColorConverter(true).toStringConverter());
                            ColorField.this.getPatternVerifiers().put((Object)"r", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.getPatternVerifiers().put((Object)"g", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.getPatternVerifiers().put((Object)"b", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.getPatternVerifiers().put((Object)"a", (Object)new IntegerRangePatternVerifier(0, 255));
                            ColorField.this.setPattern("r, g, b, a");
                            break;
                        }
                        case HEX_RGB: {
                            ColorField.this.setStringConverter(new HexColorConverter().toStringConverter());
                            ColorField.this.getPatternVerifiers().put((Object)"rr", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.getPatternVerifiers().put((Object)"gg", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.getPatternVerifiers().put((Object)"bb", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.setPattern("#rrggbb");
                            break;
                        }
                        case HEX_RGBA: {
                            ColorField.this.setStringConverter(new HexColorConverter(true).toStringConverter());
                            ColorField.this.getPatternVerifiers().put((Object)"aa", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.getPatternVerifiers().put((Object)"rr", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.getPatternVerifiers().put((Object)"gg", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.getPatternVerifiers().put((Object)"bb", (Object)new HexRangePatternVerifier(0, 255, true));
                            ColorField.this.setPattern("#aarrggbb");
                        }
                    }
                }
            };
        }
        return this._colorFormatProperty;
    }

    public ColorFormat getColorFormat() {
        return (ColorFormat)((Object)this.colorFormatProperty().get());
    }

    public void setColorFormat(ColorFormat format) {
        this.colorFormatProperty().set((Object)format);
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.showColorRect();
        this.setPopupContentFactory(new Callback<Color, PopupContent<Color>>(){

            public PopupContent<Color> call(Color param) {
                ColorPopupContent content = new ColorPopupContent();
                content.setValue((Color)ColorField.this.getValue());
                return content;
            }
        });
    }

    public BooleanProperty colorRectVisibleProperty() {
        if (this._colorRectVisibleProperty == null) {
            this._colorRectVisibleProperty = new SimpleBooleanProperty(this, "colorRectVisible"){

                protected void invalidated() {
                    super.invalidated();
                    boolean visible = this.get();
                    if (visible) {
                        ColorField.this.showColorRect();
                    } else {
                        ColorField.this.hideColorRect();
                    }
                }
            };
        }
        return this._colorRectVisibleProperty;
    }

    public boolean isColorRectVisible() {
        return this.colorRectVisibleProperty().get();
    }

    public void setColorRectVisible(boolean colorRectVisible) {
        this.colorRectVisibleProperty().set(colorRectVisible);
    }

    private void showColorRect() {
        if (this._colorRectDecorator == null) {
            Rectangle rectangle = new Rectangle(16.0, 12.0);
            rectangle.fillProperty().bind(this.valueProperty());
            rectangle.setStroke((Paint)Color.GRAY);
            rectangle.disableProperty().bind((ObservableValue)this.disabledProperty());
            this._colorRectDecorator = new Decorator((Node)rectangle, Pos.CENTER_LEFT, new Point2D(90.0, 0.0), new Insets(0.0, 0.0, 0.0, 120.0));
        }
        DecorationUtils.install((Node)this, this._colorRectDecorator);
    }

    private void hideColorRect() {
        if (this._colorRectDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._colorRectDecorator);
        }
    }

    public static enum ColorFormat {
        RGB,
        RGBA,
        HEX_RGB,
        HEX_RGBA;

    }
}

