/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.text.Font;
import javafx.util.Callback;

public class FontNameComboBox
extends ComboBox<String> {
    private BooleanProperty _showFont;

    public FontNameComboBox() {
        this.getItems().addAll((Collection)Font.getFamilies());
        this.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FontNameComboBox.this.setStyle("-fx-font-family:" + (String)FontNameComboBox.this.getSelectionModel().getSelectedItem() + ";");
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new FontComboBoxListViewSkin(this);
    }

    private class FontComboBoxListViewSkin
    extends ComboBoxListViewSkin<String> {
        public FontComboBoxListViewSkin(ComboBox<String> comboBox) {
            super(comboBox);
            FontNameComboBox.this.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> listView) {
                    return new ListCell<String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            FontComboBoxListViewSkin.this.updateDisplayText((ListCell<String>)this, item, empty);
                        }
                    };
                }
            });
        }

        private boolean updateDisplayText(ListCell<String> cell, String item, boolean empty) {
            Font defaultFont = Font.getDefault();
            if (empty) {
                if (cell == null) {
                    return true;
                }
                cell.setGraphic(null);
                cell.setText(null);
                return true;
            }
            String s = item == null ? FontNameComboBox.this.getPromptText() : item;
            cell.setText(s);
            cell.setFont(new Font(s, defaultFont.getSize()));
            cell.setGraphic(null);
            return s == null || s.isEmpty();
        }
    }
}

