/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;
import jidefx.scene.control.combobox.FormattedComboBox;
import jidefx.scene.control.field.CalendarField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.popup.PopupContent;

public class CalendarComboBox
extends FormattedComboBox<Calendar> {
    private static final String STYLE_CLASS_DEFAULT = "calendar-combo-box";
    private StringProperty _patternProperty;

    public CalendarComboBox() {
        this(((SimpleDateFormat)SimpleDateFormat.getDateInstance()).toPattern(), Calendar.getInstance());
    }

    public CalendarComboBox(String pattern) {
        this(pattern, Calendar.getInstance());
    }

    public CalendarComboBox(Calendar calendar) {
        this(((SimpleDateFormat)SimpleDateFormat.getDateInstance()).toPattern(), calendar);
    }

    public CalendarComboBox(String pattern, Calendar calendar) {
        super(calendar);
        this.setPattern(pattern);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
    }

    public StringProperty patternProperty() {
        if (this._patternProperty == null) {
            this._patternProperty = new SimpleStringProperty();
        }
        return this._patternProperty;
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public void setPattern(String pattern) {
        this.patternProperty().set((Object)pattern);
    }

    @Override
    protected FormattedTextField<Calendar> createFormattedTextField() {
        CalendarField field = new CalendarField(this.getPattern());
        field.patternProperty().bind((ObservableValue)this.patternProperty());
        return field;
    }

    @Override
    protected void initializeComboBox() {
        super.initializeComboBox();
        this.setPopupContentFactory(new Callback<Calendar, PopupContent<Calendar>>(){

            public PopupContent<Calendar> call(Calendar param) {
                PopupContent popupContent = (PopupContent)((CalendarField)CalendarComboBox.this.getEditor()).getPopupContentFactory().call((Object)param);
                popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

                    public void changed(ObservableValue<? extends Calendar> observable, Calendar oldValue, Calendar newValue) {
                        CalendarComboBox.this.hide();
                    }
                });
                return popupContent;
            }
        });
    }
}

