/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jidefx.utils.SecurityUtils;

public final class SystemInfo {
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000 = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsVista = false;
    private static boolean _isWindows7 = false;
    private static boolean _isWindows8 = false;
    private static boolean _isWindows2003 = false;
    private static boolean _isClassicWindows = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static JavaVersion _currentVersion;

    private SystemInfo() {
    }

    public static String getJavaVersion() {
        return SecurityUtils.getProperty("java.version", "1.4.2");
    }

    public static String getJavaVendor() {
        return SecurityUtils.getProperty("java.vendor", "");
    }

    public static String getJavaClassVersion() {
        return SecurityUtils.getProperty("java.class.version", "");
    }

    public static String getOS() {
        return SecurityUtils.getProperty("os.name", "Windows XP");
    }

    public static String getOSVersion() {
        return SecurityUtils.getProperty("os.version", "");
    }

    public static String getOSArchitecture() {
        return SecurityUtils.getProperty("os.arch", "");
    }

    public static String getCurrentDirectory() {
        return SecurityUtils.getProperty("user.dir", "");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static void setSupportsTray(boolean support) {
        _supportsTray = support;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isClassicWindows() {
        return _isClassicWindows;
    }

    public static boolean isWindowsNTor2000() {
        return _isWindowsNTor2000;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isWindows7() {
        return _isWindows7;
    }

    public static boolean isWindows8() {
        return _isWindows8;
    }

    public static boolean isWindowsVistaAbove() {
        return _isWindowsVista || _isWindows7 || _isWindows8;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindows2003() {
        return _isWindows2003;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    private static void checkJdkVersion() {
        if (_currentVersion == null) {
            _currentVersion = new JavaVersion(SystemInfo.getJavaVersion());
        }
    }

    public static boolean isJdk13Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.3, 0, 0) >= 0;
    }

    public static boolean isJdk142Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 2, 0) >= 0;
    }

    public static boolean isJdk14Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 0, 0) >= 0;
    }

    public static boolean isJdk15Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.5, 0, 0) >= 0;
    }

    public static boolean isJdk6Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 0) >= 0;
    }

    public static boolean isJdk6u10Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 10) >= 0;
    }

    public static boolean isJdk6u14Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 14) >= 0;
    }

    public static boolean isJdk6u25Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 25) >= 0;
    }

    public static boolean isJdk7Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.7, 0, 0) >= 0;
    }

    public static boolean isJdk8Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.8, 0, 0) >= 0;
    }

    public static boolean isJdkVersion(double majorVersion, int minorVersion, int build) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(majorVersion, minorVersion, build) == 0;
    }

    public static boolean isJdkVersionAbove(double majorVersion, int minorVersion, int build) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(majorVersion, minorVersion, build) >= 0;
    }

    public static boolean isJdkVersionBelow(double majorVersion, int minorVersion, int build) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(majorVersion, minorVersion, build) <= 0;
    }

    public static boolean isCJKLocale() {
        return SystemInfo.isCJKLocale(Locale.getDefault());
    }

    public static boolean isCJKLocale(Locale locale) {
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    static {
        String os = SecurityUtils.getProperty("os.name", "Windows XP");
        _isWindows = os.contains("Windows");
        try {
            String osVersion = SecurityUtils.getProperty("os.version", "5.0");
            Float version = Float.valueOf(osVersion);
            _isClassicWindows = (double)version.floatValue() <= 4.0;
        }
        catch (NumberFormatException ex) {
            _isClassicWindows = false;
        }
        if (os.contains("Windows XP") || os.contains("Windows NT") || os.contains("Windows 2000")) {
            _isWindowsNTor2000 = true;
        }
        if (os.contains("Windows XP")) {
            _isWindowsXP = true;
        }
        if (os.contains("Windows Vista")) {
            _isWindowsVista = true;
        }
        if (os.contains("Windows 7")) {
            _isWindows7 = true;
        }
        if (os.contains("Windows 8")) {
            _isWindows8 = true;
        }
        if (os.contains("Windows 2003")) {
            _isWindows2003 = true;
            _isWindowsXP = true;
        }
        if (os.contains("Windows 95")) {
            _isWindows95 = true;
        }
        if (os.contains("Windows 98")) {
            _isWindows98 = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = os.contains("Solaris") || os.contains("SunOS");
        _isLinux = os.contains("Linux");
        if (os.startsWith("Mac OS")) {
            if (os.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }

    public static class JavaVersion {
        private static Pattern SUN_JAVA_VERSION = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
        private static Pattern SUN_JAVA_VERSION_SIMPLE = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");
        private double _majorVersion;
        private int _minorVersion;
        private int _buildNumber;
        private String _patch;

        public JavaVersion(String version) {
            block11: {
                this._majorVersion = 1.4;
                this._minorVersion = 0;
                this._buildNumber = 0;
                try {
                    String s;
                    Matcher matcher = SUN_JAVA_VERSION.matcher(version);
                    if (!matcher.matches()) break block11;
                    int groups = matcher.groupCount();
                    this._majorVersion = Double.parseDouble(matcher.group(1));
                    if (groups >= 3 && matcher.group(3) != null) {
                        this._minorVersion = Integer.parseInt(matcher.group(3));
                    }
                    if (groups >= 5 && matcher.group(5) != null) {
                        try {
                            this._buildNumber = Integer.parseInt(matcher.group(5));
                        }
                        catch (NumberFormatException e) {
                            this._patch = matcher.group(5);
                        }
                    }
                    if (groups >= 6 && matcher.group(6) != null && (s = matcher.group(6)) != null && s.trim().length() > 0) {
                        this._patch = s;
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        Matcher matcher = SUN_JAVA_VERSION_SIMPLE.matcher(version);
                        if (matcher.matches()) {
                            int groups = matcher.groupCount();
                            this._majorVersion = Double.parseDouble(matcher.group(1));
                            if (groups >= 3 && matcher.group(3) != null) {
                                this._minorVersion = Integer.parseInt(matcher.group(3));
                            }
                        }
                    }
                    catch (NumberFormatException e1) {
                        System.err.println("Please check the installation of your JDK. The version number " + version + " is not right.");
                    }
                }
            }
        }

        public JavaVersion(double major, int minor, int build) {
            this._majorVersion = major;
            this._minorVersion = minor;
            this._buildNumber = build;
        }

        public int compareVersion(double major, int minor, int build) {
            double majorResult = this._majorVersion - major;
            if (majorResult != 0.0) {
                return majorResult < 0.0 ? -1 : 1;
            }
            int result = this._minorVersion - minor;
            if (result != 0) {
                return result;
            }
            return this._buildNumber - build;
        }

        public double getMajorVersion() {
            return this._majorVersion;
        }

        public int getMinorVersion() {
            return this._minorVersion;
        }

        public int getBuildNumber() {
            return this._buildNumber;
        }

        public String getPatch() {
            return this._patch;
        }
    }
}

