/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import com.sun.javafx.Utils;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SkinBase;
import javafx.stage.Screen;

public class FXUtils {
    public static Rectangle2D getScreenBounds(Point2D point) {
        Screen currentScreen = Utils.getScreenForPoint((double)point.getX(), (double)point.getY());
        return Utils.hasFullScreenStage((Screen)currentScreen) ? currentScreen.getBounds() : currentScreen.getVisualBounds();
    }

    public static Insets add(Insets insets1, Insets insets2) {
        if (insets1 == null) {
            return insets2;
        }
        if (insets2 == null) {
            return insets1;
        }
        return new Insets(insets1.getTop() + insets2.getTop(), insets1.getRight() + insets2.getRight(), insets1.getBottom() + insets2.getBottom(), insets1.getLeft() + insets2.getLeft());
    }

    public static boolean isAncestor(Node node, Node ancestorNode) {
        if (node != null && ancestorNode != null) {
            for (Node parent = ancestorNode; parent != null; parent = parent.getParent()) {
                if (parent != node) continue;
                return true;
            }
        }
        return false;
    }

    public static Node findAncestor(Node node, Class classToFind, Class classToStop) {
        for (node = node.getParent(); node != null; node = node.getParent()) {
            if (classToStop != null && classToStop.isAssignableFrom(node.getClass())) {
                return null;
            }
            if (!classToFind.isAssignableFrom(node.getClass())) continue;
            return node;
        }
        return null;
    }

    public static Node findAncestor(Node node, String classNameEndWith, Class classToStop) {
        while (node != null) {
            if (classToStop != null && classToStop.isAssignableFrom(node.getClass())) {
                return null;
            }
            if (node.getClass().getName().endsWith(classNameEndWith)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static <T> void setRecursively(T c, Handler<T> handler) {
        FXUtils.setRecursively0(c, handler);
        handler.postAction(c);
    }

    private static <T> void setRecursively0(T c, Handler<T> handler) {
        if (handler instanceof ConditionHandler && ((ConditionHandler)handler).stopCondition(c)) {
            return;
        }
        if (handler.condition(c)) {
            handler.action(c);
        }
        ObservableList children = null;
        if (c instanceof Parent) {
            children = ((Parent)c).getChildrenUnmodifiable();
        }
        if (children != null) {
            for (Node child : children) {
                if (!(child instanceof Parent)) continue;
                FXUtils.setRecursively0(child, handler);
            }
        }
    }

    public static <T> Object getRecursively(T c, GetHandler<T> handler) {
        return FXUtils.getRecursively0(c, handler);
    }

    private static <T> Object getRecursively0(T c, GetHandler<T> handler) {
        if (handler.condition(c)) {
            return handler.action(c);
        }
        ObservableList children = null;
        if (c instanceof Parent) {
            children = ((Parent)c).getChildrenUnmodifiable();
        } else if (c instanceof SkinBase) {
            children = ((SkinBase)c).getChildren();
        }
        if (children != null) {
            for (Node child : children) {
                Object result;
                if (!(child instanceof Parent) || (result = FXUtils.getRecursively0(child, handler)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static void runThreadSafe(Runnable runnable) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    @FunctionalInterface
    public static interface GetHandler<T> {
        public boolean condition(T var1);

        default public Object action(T c) {
            return c;
        }
    }

    @FunctionalInterface
    public static interface ConditionHandler<T>
    extends Handler<T> {
        default public boolean stopCondition(T c) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface Handler<T> {
        default public boolean condition(T c) {
            return true;
        }

        public void action(T var1);

        default public void postAction(T c) {
        }
    }
}

