/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Window;
import javafx.util.Duration;
import jidefx.scene.control.searchable.Resource;
import jidefx.utils.WildcardSupport;

public abstract class Searchable<T> {
    protected final Node _node;
    private SearchPopup _popup;
    private transient Pattern _pattern;
    private transient String _searchText;
    protected ChangeListener<Boolean> _visibleListener;
    protected ChangeListener<Bounds> _boundsListener;
    protected EventHandler<KeyEvent> _keyListener;
    private int _cursor = -1;
    private ObjectProperty<Pos> _popupPositionProperty;
    private ObjectProperty<Node> _popupPositionRelativeToProperty;
    private Duration _hidePopupDelay = Duration.INDEFINITE;
    private Timeline _hidePopupTimer;
    private boolean _reverseOrder = false;
    private BooleanProperty _searchingProperty;
    private StringProperty _searchingTextProperty;
    private StringProperty _typedTextProperty;
    private ObjectProperty<T> _matchingElementProperty;
    private IntegerProperty _matchingIndexProperty;
    private BooleanProperty _caseSensitiveProperty;
    private BooleanProperty _fromStartProperty;
    private BooleanProperty _wildcardEnabledProperty;
    private WildcardSupport _wildcardSupport = null;
    private ObjectProperty<Duration> _searchingDelayProperty;
    private BooleanProperty _repeatsProperty;
    private StringProperty _searchingLabelProperty;
    public static final String PROPERTY_SEARCHABLE = "Searchable";
    private Set<Integer> _selection;
    private ChangeListener<Number> _windowPositionChangeListener;

    public Searchable(Node node) {
        this._node = node;
        this._selection = new HashSet<Integer>();
        this.updateProperty(this._node, this);
        this.installListeners();
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    public void adjustSelectedIndex(int index, boolean incremental) {
        this.setSelectedIndex(index, incremental);
    }

    protected abstract int getElementCount();

    protected abstract T getElementAt(int var1);

    protected abstract String convertElementToString(T var1);

    private void select(int index, KeyEvent e) {
        if (index != -1) {
            boolean incremental = e != null && this.isIncrementalSelectKey(e);
            this.setSelectedIndex(index, incremental);
            this.setCursor(index, incremental);
            this.updateText(this.getTypedText());
        } else {
            this.updateText(this.getTypedText() + " " + this.getResourceString("Searchable.noMatch"));
        }
        if (index != -1) {
            this.setMatchingElement(this.getElementAt(index));
            this.setMatchingIndex(index);
        } else {
            this.setMatchingElement(null);
            this.setMatchingIndex(-1);
        }
    }

    public void hidePopup() {
        if (this._popup != null) {
            this._popup.hide();
            this._popup = null;
            this.stopHidePopupTimer();
            this.setSearching(false);
            Window window = this._node.getScene().getWindow();
            if (window != null && this._windowPositionChangeListener != null) {
                window.xProperty().removeListener(this._windowPositionChangeListener);
                window.yProperty().removeListener(this._windowPositionChangeListener);
                this._windowPositionChangeListener = null;
            }
        }
        this.setCursor(-1);
    }

    public void installListeners() {
        if (this._visibleListener == null) {
            this._visibleListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> property, Boolean oldValue, Boolean newValue) {
                    if (!newValue.booleanValue()) {
                        Searchable.this.hidePopup();
                    }
                }
            };
        }
        this._node.focusedProperty().addListener(this._visibleListener);
        this._node.visibleProperty().addListener(this._visibleListener);
        if (this._boundsListener == null) {
            this._boundsListener = new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> property, Bounds oldValue, Bounds newValue) {
                    Searchable.this.updatePopupPosition();
                }
            };
        }
        this._node.layoutBoundsProperty().addListener(this._boundsListener);
        if (this._keyListener == null) {
            this._keyListener = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    Searchable.this.keyTypedOrPressed(event);
                }
            };
        }
        this._node.addEventHandler(KeyEvent.ANY, this._keyListener);
    }

    public void uninstallListeners() {
        if (this._visibleListener != null) {
            this._node.visibleProperty().removeListener(this._visibleListener);
            this._node.focusedProperty().removeListener(this._visibleListener);
            this._visibleListener = null;
        }
        if (this._boundsListener != null) {
            this._node.layoutBoundsProperty().removeListener(this._boundsListener);
            this._boundsListener = null;
        }
        if (this._keyListener != null) {
            this._node.removeEventHandler(KeyEvent.ANY, this._keyListener);
            this._keyListener = null;
        }
    }

    protected boolean compare(T element, String searchingText) {
        String text = this.convertElementToString(element);
        return text != null && this.compareAsString(this.isCaseSensitive() ? text : text.toLowerCase(), searchingText);
    }

    protected boolean compareAsString(String text, String searchingText) {
        if (searchingText == null || searchingText.trim().length() == 0) {
            return true;
        }
        if (!this.isWildcardEnabled()) {
            return searchingText.equals(text) || searchingText.length() > 0 && (this.isFromStart() ? text.startsWith(searchingText) : text.contains(searchingText));
        }
        if (this._searchText != null && this._searchText.equals(searchingText) && this._pattern != null) {
            return this._pattern.matcher(text).find();
        }
        WildcardSupport wildcardSupport = this.getWildcardSupport();
        String s = wildcardSupport.convert(searchingText);
        if (searchingText.equals(s)) {
            return this.isFromStart() ? text.startsWith(searchingText) : text.contains(searchingText);
        }
        this._searchText = searchingText;
        try {
            this._pattern = Pattern.compile(this.isFromStart() ? "^" + s : s, this.isCaseSensitive() ? 0 : 2);
            return this._pattern.matcher(text).find();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public int getCursor() {
        return this._cursor;
    }

    public void setCursor(int cursor) {
        this.setCursor(cursor, false);
    }

    public void setCursor(int cursor, boolean incremental) {
        if (!incremental || this._cursor < 0) {
            this._selection.clear();
        }
        if (this._cursor >= 0) {
            this._selection.add(cursor);
        }
        this._cursor = cursor;
    }

    protected void highlightAll() {
        int firstIndex = -1;
        int index = this.getSelectedIndex();
        String text = this.getTypedText();
        while (index != -1) {
            int newIndex = this.findNext(text);
            if ((index = index == newIndex ? -1 : newIndex) == -1) continue;
            if (firstIndex == -1) {
                firstIndex = index;
            }
            this.select(index);
        }
        if (firstIndex != -1) {
            this.select(firstIndex);
        }
    }

    protected void select(int index) {
        if (index != -1) {
            this.setSelectedIndex(index, true);
            this.setCursor(index, true);
            this.setMatchingElement(this.getElementAt(index));
            this.setMatchingIndex(index);
        } else {
            this.setSelectedIndex(-1, false);
            this.setMatchingElement(null);
            this.setMatchingIndex(-1);
        }
    }

    public int findNext(String s) {
        T element;
        int i;
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        int selectedIndex = this.getCurrentIndex();
        for (i = selectedIndex + 1; i < count; ++i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        if (this.isRepeats()) {
            for (i = 0; i < selectedIndex; ++i) {
                element = this.getElementAt(i);
                if (!this.compare(element, str)) continue;
                return i;
            }
        }
        return selectedIndex == -1 ? -1 : (this.compare(this.getElementAt(selectedIndex), str) ? selectedIndex : -1);
    }

    protected int getCurrentIndex() {
        if (this._selection.contains(this.getSelectedIndex())) {
            return this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        }
        this._selection.clear();
        return this.getSelectedIndex();
    }

    public int findPrevious(String s) {
        T element;
        int i;
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        int selectedIndex = this.getCurrentIndex();
        for (i = selectedIndex - 1; i >= 0; --i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        if (this.isRepeats()) {
            for (i = count - 1; i >= selectedIndex; --i) {
                element = this.getElementAt(i);
                if (!this.compare(element, str)) continue;
                return i;
            }
        }
        return selectedIndex == -1 ? -1 : (this.compare(this.getElementAt(selectedIndex), str) ? selectedIndex : -1);
    }

    public int findFromCursor(String s) {
        T element;
        int i;
        int count;
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s);
        }
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int selectedIndex = this.getCurrentIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if ((count = this.getElementCount()) == 0) {
            return -1;
        }
        for (i = selectedIndex; i < count; ++i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        for (i = 0; i < selectedIndex; ++i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        return -1;
    }

    public int reverseFindFromCursor(String s) {
        T element;
        int i;
        int count;
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s);
        }
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int selectedIndex = this.getCurrentIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if ((count = this.getElementCount()) == 0) {
            return -1;
        }
        for (i = selectedIndex; i >= 0; --i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        for (i = count - 1; i >= selectedIndex; --i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        return -1;
    }

    public int findFirst(String s) {
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        for (int i = 0; i < count; ++i) {
            int index = this.getIndex(count, i);
            T element = this.getElementAt(index);
            if (!this.compare(element, str)) continue;
            return index;
        }
        return -1;
    }

    public int findLast(String s) {
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        for (int i = count - 1; i >= 0; --i) {
            T element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        return -1;
    }

    protected void keyTypedOrPressed(KeyEvent e) {
        if (this.isActivateKey(e)) {
            String searchingText = "";
            if (!(e.getEventType() != KeyEvent.KEY_PRESSED || e.isControlDown() || e.isAltDown() || e.isMetaDown())) {
                searchingText = e.getText();
            }
            this.showPopup(searchingText);
            if (e.getCode() != KeyCode.ENTER) {
                e.consume();
            }
        } else if (this.isDeactivateKey(e)) {
            this.hidePopup();
        }
    }

    private int getIndex(int count, int index) {
        return this.isReverseOrder() ? count - index - 1 : index;
    }

    public void showPopup(String searchingText) {
        if (this._popup == null) {
            this._popup = this.createSearchPopup();
            this.setSearching(true);
            this.setTypedText(searchingText);
            this.showPopup();
            this.startHidePopupTimer();
        }
    }

    protected SearchPopup createSearchPopup() {
        return new SearchPopup();
    }

    private void showPopup() {
        Node node = this.getPopupPositionRelativeTo() != null ? this.getPopupPositionRelativeTo() : this._node;
        Window window = node.getScene().getWindow();
        if (window != null) {
            this._popup.show(window);
            this._popup.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    Searchable.this.updatePopupPosition();
                }
            });
            if (this._windowPositionChangeListener == null) {
                this._windowPositionChangeListener = new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                        Searchable.this.updatePopupPosition();
                    }
                };
            }
            window.xProperty().addListener(this._windowPositionChangeListener);
            window.yProperty().addListener(this._windowPositionChangeListener);
            this.updatePopupPosition();
        }
    }

    private void updatePopupPosition() {
        Node node;
        Node node2 = node = this.getPopupPositionRelativeTo() != null ? this.getPopupPositionRelativeTo() : this._node;
        if (this._popup == null || node == null) {
            return;
        }
        double w = this._popup.prefWidth(-1.0);
        double h = this._popup.prefHeight(-1.0);
        Bounds bounds = node.getBoundsInLocal();
        Point2D p = node.localToScreen(bounds.getMinX(), bounds.getMinY());
        Pos pos = this.getPopupPosition();
        double x = 0.0;
        double y = 0.0;
        switch (pos) {
            case TOP_LEFT: {
                x = p.getX();
                y = p.getY() - h;
                break;
            }
            case TOP_CENTER: {
                x = p.getX() + bounds.getWidth() / 2.0 - w / 2.0;
                y = p.getY() - h;
                break;
            }
            case TOP_RIGHT: {
                x = p.getX() - w + bounds.getWidth();
                y = p.getY() - h;
                break;
            }
            case BOTTOM_LEFT: {
                x = p.getX();
                y = p.getY() + bounds.getHeight();
                break;
            }
            case BOTTOM_CENTER: {
                x = p.getX() + bounds.getWidth() / 2.0 - w / 2.0;
                y = p.getY() + bounds.getHeight();
                break;
            }
            case BOTTOM_RIGHT: {
                x = p.getX() - w + bounds.getWidth();
                y = p.getY() + bounds.getHeight();
            }
        }
        this._popup.setX(x);
        this._popup.setY(y);
    }

    protected boolean isFindFirstKey(KeyEvent e) {
        return e.getCode() == KeyCode.HOME;
    }

    protected boolean isFindLastKey(KeyEvent e) {
        return e.getCode() == KeyCode.END;
    }

    protected boolean isFindPreviousKey(KeyEvent e) {
        return e.getCode() == KeyCode.UP;
    }

    protected boolean isFindNextKey(KeyEvent e) {
        return e.getCode() == KeyCode.DOWN;
    }

    protected boolean isNavigationKey(KeyEvent e) {
        return this.isFindFirstKey(e) || this.isFindLastKey(e) || this.isFindNextKey(e) || this.isFindPreviousKey(e);
    }

    protected boolean isActivateKey(KeyEvent e) {
        return e.getEventType() == KeyEvent.KEY_PRESSED && (e.getCode().isLetterKey() || e.getCode().isDigitKey());
    }

    protected boolean isDeactivateKey(KeyEvent e) {
        KeyCode keyCode = e.getCode();
        return keyCode == KeyCode.ENTER || keyCode == KeyCode.ESCAPE || keyCode == KeyCode.PAGE_UP || keyCode == KeyCode.PAGE_DOWN || keyCode == KeyCode.HOME || keyCode == KeyCode.END;
    }

    protected boolean isSelectAllKey(KeyEvent e) {
        return e.isShortcutDown() && e.getCode() == KeyCode.A;
    }

    protected boolean isIncrementalSelectKey(KeyEvent e) {
        return e.isControlDown();
    }

    public BooleanProperty caeSensitiveProperty() {
        if (this._caseSensitiveProperty == null) {
            this._caseSensitiveProperty = new SimpleBooleanProperty();
        }
        return this._caseSensitiveProperty;
    }

    public boolean isCaseSensitive() {
        return this.caeSensitiveProperty().get();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caeSensitiveProperty().set(caseSensitive);
    }

    public ObjectProperty<Duration> searchingDelayProperty() {
        if (this._searchingDelayProperty == null) {
            this._searchingDelayProperty = new SimpleObjectProperty((Object)Duration.millis((double)200.0));
        }
        return this._searchingDelayProperty;
    }

    public Duration getSearchingDelay() {
        return (Duration)this.searchingDelayProperty().get();
    }

    public void setSearchingDelay(Duration searchingDelay) {
        this.searchingDelayProperty().set((Object)searchingDelay);
    }

    public BooleanProperty repeatsProperty() {
        if (this._repeatsProperty == null) {
            this._repeatsProperty = new SimpleBooleanProperty(true);
        }
        return this._repeatsProperty;
    }

    public boolean isRepeats() {
        return this.repeatsProperty().get();
    }

    public void setRepeats(boolean repeats) {
        this.repeatsProperty().set(repeats);
    }

    public BooleanProperty wildcardEnabledProperty() {
        if (this._wildcardEnabledProperty == null) {
            this._wildcardEnabledProperty = new SimpleBooleanProperty();
        }
        return this._wildcardEnabledProperty;
    }

    public boolean isWildcardEnabled() {
        return this.wildcardEnabledProperty().get();
    }

    public void setWildcardEnabled(Boolean wildcardEnabled) {
        this.wildcardEnabledProperty().set(wildcardEnabled.booleanValue());
    }

    public WildcardSupport getWildcardSupport() {
        if (this._wildcardSupport == null) {
            this._wildcardSupport = new WildcardSupport(){};
        }
        return this._wildcardSupport;
    }

    public void setWildcardSupport(WildcardSupport wildcardSupport) {
        this._wildcardSupport = wildcardSupport;
    }

    public StringProperty searchingLabelProperty() {
        if (this._searchingLabelProperty == null) {
            this._searchingLabelProperty = new SimpleStringProperty(this.getResourceString("Searchable.searchFor"));
        }
        return this._searchingLabelProperty;
    }

    public String getSearchLabel() {
        return (String)this.searchingLabelProperty().get();
    }

    public void setSearchLabel(String searchLabel) {
        this.searchingLabelProperty().set((Object)searchLabel);
    }

    public Node getNode() {
        return this._node;
    }

    public ObjectProperty<Pos> popupPositionProperty() {
        if (this._popupPositionProperty == null) {
            this._popupPositionProperty = new SimpleObjectProperty<Pos>((Object)this, "popupPosition", Pos.TOP_LEFT){

                protected void invalidated() {
                    super.invalidated();
                    if (Searchable.this.isPopupVisible()) {
                        Searchable.this.updatePopupPosition();
                    }
                }
            };
        }
        return this._popupPositionProperty;
    }

    public Pos getPopupPosition() {
        return (Pos)this.popupPositionProperty().get();
    }

    public void setPopupPosition(Pos popupPosition) {
        this.popupPositionProperty().set((Object)popupPosition);
    }

    public ObjectProperty<Node> popupPositionRelativeToProperty() {
        if (this._popupPositionRelativeToProperty == null) {
            this._popupPositionRelativeToProperty = new SimpleObjectProperty();
        }
        return this._popupPositionRelativeToProperty;
    }

    public Node getPopupPositionRelativeTo() {
        return (Node)this.popupPositionRelativeToProperty().get();
    }

    public void setPopupPositionRelativeTo(Node popupPositionRelativeTo) {
        this.popupPositionRelativeToProperty().set((Object)popupPositionRelativeTo);
    }

    private void updateText(String newValue) {
        if (this._popup != null) {
            this._popup.setText(newValue);
        }
    }

    public StringProperty searchingTextProperty() {
        if (this._searchingTextProperty == null) {
            this._searchingTextProperty = new SimpleStringProperty();
        }
        return this._searchingTextProperty;
    }

    public String getSearchingText() {
        return (String)this.searchingTextProperty().get();
    }

    public void setSearchingText(String searchingText) {
        this.searchingTextProperty().set((Object)searchingText);
    }

    public StringProperty typedTextProperty() {
        if (this._typedTextProperty == null) {
            this._typedTextProperty = new SimpleStringProperty(this, "typedText", ""){
                private Timeline timer;
                {
                    this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Searchable.this.getSearchingDelay(), (EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent event) {
                            this.applyText();
                        }
                    }, new KeyValue[0])});
                }

                protected void invalidated() {
                    super.invalidated();
                    if (Searchable.this.isPopupVisible()) {
                        Searchable.this.updateText(this.get());
                        Searchable.this.startHidePopupTimer();
                        this.startDelayTimer();
                    }
                }

                protected void applyText() {
                    String text = Searchable.this.getTypedText().trim();
                    Searchable.this.setSearchingText(text);
                    if (text.length() != 0) {
                        int found = Searchable.this.findFromCursor(text);
                        Searchable.this.select(found, null);
                    } else {
                        Searchable.this.hidePopup();
                    }
                }

                void startDelayTimer() {
                    this.timer.setDelay(Searchable.this.getSearchingDelay());
                    if (!Duration.ZERO.equals((Object)Searchable.this.getSearchingDelay())) {
                        if (this.timer.getStatus() == Animation.Status.RUNNING) {
                            this.timer.stop();
                            this.timer.play();
                        } else {
                            this.timer.setCycleCount(1);
                            this.timer.play();
                        }
                    } else {
                        this.applyText();
                    }
                }
            };
        }
        return this._typedTextProperty;
    }

    private String getTypedText() {
        return (String)this.typedTextProperty().get();
    }

    private void setTypedText(String typedText) {
        this.typedTextProperty().set((Object)typedText);
    }

    public BooleanProperty searchingProperty() {
        if (this._searchingProperty == null) {
            this._searchingProperty = new SimpleBooleanProperty();
        }
        return this._searchingProperty;
    }

    public boolean isSearching() {
        return this.searchingProperty().get();
    }

    public void setSearching(boolean searching) {
        this.searchingProperty().set(searching);
    }

    public IntegerProperty matchingIndexProperty() {
        if (this._matchingIndexProperty == null) {
            this._matchingIndexProperty = new SimpleIntegerProperty();
        }
        return this._matchingIndexProperty;
    }

    public int getMatchingIndex() {
        return this.matchingIndexProperty().get();
    }

    public void setMatchingIndex(int matchingIndex) {
        this.matchingIndexProperty().set(matchingIndex);
    }

    public ObjectProperty<T> matchingElementProperty() {
        if (this._matchingElementProperty == null) {
            this._matchingElementProperty = new SimpleObjectProperty();
        }
        return this._matchingElementProperty;
    }

    public T getMatchingElement() {
        return (T)this.matchingElementProperty().get();
    }

    public void setMatchingElement(T matchingElement) {
        this.matchingElementProperty().set(matchingElement);
    }

    public boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this._reverseOrder = reverseOrder;
    }

    protected String getResourceString(String key) {
        return Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    public boolean isPopupVisible() {
        return this._popup != null;
    }

    public BooleanProperty fromStartProperty() {
        if (this._fromStartProperty == null) {
            this._fromStartProperty = new SimpleBooleanProperty(this, "fromStart"){

                protected void invalidated() {
                    super.invalidated();
                    Searchable.this.hidePopup();
                }
            };
        }
        return this._fromStartProperty;
    }

    public boolean isFromStart() {
        return this.fromStartProperty().get();
    }

    public void setFromStart(boolean fromStart) {
        this.fromStartProperty().set(fromStart);
    }

    public static Searchable getSearchable(Node node) {
        Object property = node.getProperties().get((Object)PROPERTY_SEARCHABLE);
        if (property instanceof Searchable) {
            return (Searchable)property;
        }
        return null;
    }

    private void updateProperty(Node node, Searchable searchable) {
        if (node != null) {
            Object clientProperty = this._node.getProperties().get((Object)PROPERTY_SEARCHABLE);
            if (clientProperty instanceof Searchable) {
                ((Searchable)clientProperty).uninstallListeners();
            }
            node.getProperties().put((Object)PROPERTY_SEARCHABLE, (Object)searchable);
        }
    }

    public Duration getHidePopupDelay() {
        return this._hidePopupDelay;
    }

    public void setHidePopupDelay(Duration hidePopupDelay) {
        this._hidePopupDelay = hidePopupDelay;
    }

    private void startHidePopupTimer() {
        if (!Duration.INDEFINITE.equals((Object)this.getHidePopupDelay()) && this._hidePopupTimer == null) {
            this._hidePopupTimer = new Timeline(new KeyFrame[]{new KeyFrame(this.getHidePopupDelay(), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (Searchable.this.isPopupVisible()) {
                        Searchable.this.hidePopup();
                    }
                }
            }, new KeyValue[0])});
            this._hidePopupTimer.setCycleCount(1);
            this._hidePopupTimer.play();
        } else if (this._hidePopupTimer != null && this._hidePopupTimer.getStatus() == Animation.Status.RUNNING) {
            this._hidePopupTimer.stop();
            this._hidePopupTimer.play();
        }
    }

    private void stopHidePopupTimer() {
        if (this._hidePopupTimer != null) {
            this._hidePopupTimer.stop();
            this._hidePopupTimer = null;
        }
    }

    public List<Integer> findAll(String s) {
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = this.getElementCount();
        for (int i = 0; i < count; ++i) {
            T element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            list.add(i);
        }
        return list;
    }

    public String getElementAtAsString(int index) {
        return this.convertElementToString(this.getElementAt(index));
    }

    protected class SearchPopup
    extends Tooltip
    implements EventHandler<KeyEvent> {
        public SearchPopup() {
            this.getStyleClass().add((Object)"searchable-popup");
            this.setEventHandler(KeyEvent.ANY, this);
            Label label = new Label(Searchable.this.getSearchLabel());
            label.getStyleClass().add((Object)"searchable-popup-label");
            this.setGraphic((Node)label);
        }

        public void handle(KeyEvent e) {
            String text = Searchable.this.getTypedText();
            if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                if (Searchable.this.isSelectAllKey(e)) {
                    int count = this.selectAll(e, text);
                    Searchable.this.updateText(text + " " + MessageFormat.format(Searchable.this.getResourceString("Searchable.found"), count));
                    e.consume();
                    return;
                }
                if (Searchable.this.isFindPreviousKey(e)) {
                    int found = Searchable.this.findPrevious(text);
                    Searchable.this.select(found, e);
                    e.consume();
                    return;
                }
                if (Searchable.this.isFindNextKey(e)) {
                    int found = Searchable.this.findNext(text);
                    Searchable.this.select(found, e);
                    e.consume();
                    return;
                }
                if (Searchable.this.isFindFirstKey(e)) {
                    int found = Searchable.this.findFirst(text);
                    Searchable.this.select(found, e);
                    e.consume();
                    return;
                }
                if (Searchable.this.isFindLastKey(e)) {
                    int found = Searchable.this.findLast(text);
                    Searchable.this.select(found, e);
                    e.consume();
                    return;
                }
            }
            if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                String newText = e.getCode() == KeyCode.DELETE ? text.substring(1) : (e.getCode() == KeyCode.BACK_SPACE ? text.substring(0, Math.max(0, text.length() - 1)) : (!e.isAltDown() && !e.isControlDown() && !e.isMetaDown() ? text.concat(e.getText()) : text));
                Searchable.this.setTypedText(newText);
            }
        }

        private int selectAll(KeyEvent e, String text) {
            int newIndex;
            boolean oldRepeats;
            int index;
            boolean oldReverseOrder = Searchable.this.isReverseOrder();
            if (oldReverseOrder) {
                Searchable.this.setReverseOrder(false);
            }
            if ((index = Searchable.this.findFirst(text)) != -1) {
                Searchable.this.setSelectedIndex(index, false);
                Searchable.this.setCursor(index);
            }
            if (oldRepeats = Searchable.this.isRepeats()) {
                Searchable.this.setRepeats(false);
            }
            while (index != -1 && (index = index == (newIndex = Searchable.this.findNext(text)) ? -1 : newIndex) != -1) {
                Searchable.this.select(index, e);
            }
            if (oldRepeats) {
                Searchable.this.setRepeats(oldRepeats);
            }
            if (oldReverseOrder) {
                Searchable.this.setReverseOrder(oldReverseOrder);
            }
            return Searchable.this._selection.size();
        }
    }
}

