/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import jidefx.scene.control.searchable.Searchable;

public class ListViewSearchable<T>
extends Searchable<T> {
    private ListChangeListener<T> _listChangeListener;
    private ChangeListener<ObservableList<T>> _itemsChangeListener;

    public ListViewSearchable(ListView<T> listView) {
        super((Node)listView);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._listChangeListener == null) {
            this._listChangeListener = new ListChangeListener<T>(){

                public void onChanged(ListChangeListener.Change<? extends T> c) {
                    ListViewSearchable.this.hidePopup();
                }
            };
        }
        ((ListView)this._node).getItems().addListener(this._listChangeListener);
        if (this._itemsChangeListener == null) {
            this._itemsChangeListener = new ChangeListener<ObservableList<T>>(){

                public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
                    ListViewSearchable.this.hidePopup();
                }
            };
        }
        ((ListView)this._node).itemsProperty().addListener(this._itemsChangeListener);
    }

    @Override
    public void uninstallListeners() {
        if (this._listChangeListener != null) {
            ((ListView)this._node).getItems().removeListener(this._listChangeListener);
            this._listChangeListener = null;
        }
        if (this._itemsChangeListener != null) {
            ((ListView)this._node).itemsProperty().removeListener(this._itemsChangeListener);
            this._itemsChangeListener = null;
        }
        super.uninstallListeners();
    }

    @Override
    protected int getSelectedIndex() {
        return ((ListView)this._node).getSelectionModel().getSelectedIndex();
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        ListView listView = (ListView)this._node;
        if (incremental) {
            listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            listView.getSelectionModel().select(index);
            listView.scrollTo(index);
        } else {
            listView.getSelectionModel().clearSelection(index);
            listView.getSelectionModel().select(index);
            listView.scrollTo(index);
        }
    }

    @Override
    protected int getElementCount() {
        return ((ListView)this._node).getItems().size();
    }

    @Override
    protected T getElementAt(int index) {
        return (T)((ListView)this._node).getItems().get(index);
    }

    @Override
    protected String convertElementToString(T element) {
        return element != null ? element.toString() : "";
    }
}

