/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;
import jidefx.scene.control.searchable.Searchable;

public class ComboBoxSearchable<T>
extends Searchable<T> {
    private ListChangeListener<T> _listChangeListener;
    private ChangeListener<ObservableList<T>> _itemsChangeListener;
    private BooleanProperty _showPopupProperty;

    public ComboBoxSearchable(ComboBox<T> comboBox) {
        super((Node)comboBox);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._listChangeListener == null) {
            this._listChangeListener = new ListChangeListener<T>(){

                public void onChanged(ListChangeListener.Change<? extends T> c) {
                    ComboBoxSearchable.this.hidePopup();
                }
            };
        }
        ((ComboBox)this._node).getItems().addListener(this._listChangeListener);
        if (this._itemsChangeListener == null) {
            this._itemsChangeListener = new ChangeListener<ObservableList<T>>(){

                public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
                    ComboBoxSearchable.this.hidePopup();
                }
            };
        }
        ((ComboBox)this._node).itemsProperty().addListener(this._itemsChangeListener);
    }

    @Override
    public void uninstallListeners() {
        if (this._listChangeListener != null) {
            ((ComboBox)this._node).getItems().removeListener(this._listChangeListener);
            this._listChangeListener = null;
        }
        if (this._itemsChangeListener != null) {
            ((ComboBox)this._node).itemsProperty().removeListener(this._itemsChangeListener);
            this._itemsChangeListener = null;
        }
        super.uninstallListeners();
    }

    public BooleanProperty showPopupProperty() {
        if (this._showPopupProperty == null) {
            this._showPopupProperty = new SimpleBooleanProperty((Object)this, "showPopup", false);
        }
        return this._showPopupProperty;
    }

    public boolean isShowPopup() {
        return this.showPopupProperty().get();
    }

    public void setShowPopup(boolean showPopup) {
        this.showPopupProperty().set(showPopup);
    }

    @Override
    protected int getSelectedIndex() {
        return ((ComboBox)this._node).getSelectionModel().getSelectedIndex();
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        ComboBox comboBox = (ComboBox)this._node;
        comboBox.getSelectionModel().select(this.getElementAt(index));
        if (this.isShowPopup()) {
            comboBox.show();
        }
    }

    @Override
    protected int getElementCount() {
        return ((ComboBox)this._node).getItems().size();
    }

    @Override
    protected T getElementAt(int index) {
        return (T)((ComboBox)this._node).getItems().get(index);
    }

    @Override
    protected String convertElementToString(T element) {
        ComboBox comboBox = (ComboBox)this._node;
        StringConverter converter = comboBox.getConverter();
        return converter != null ? converter.toString(element) : (element != null ? element.toString() : "");
    }
}

